/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.roundcornerprogressbar;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.akexorcist.roundcornerprogressbar.R;
import com.akexorcist.roundcornerprogressbar.common.AnimatedRoundCornerProgressBar;

@Keep
public class RoundCornerProgressBar
extends AnimatedRoundCornerProgressBar {
    public RoundCornerProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RoundCornerProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @RequiresApi(value=21)
    public RoundCornerProgressBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    public int initLayout() {
        return R.layout.layout_round_corner_progress_bar;
    }

    @Override
    protected void initStyleable(@NonNull Context context, @NonNull AttributeSet attrs) {
    }

    @Override
    protected void initView() {
    }

    @Override
    protected void drawProgress(@NonNull LinearLayout layoutProgress, @NonNull GradientDrawable progressDrawable, float max, float progress, float totalWidth, int radius, int padding, boolean isReverse) {
        int newRadius = radius - padding / 2;
        progressDrawable.setCornerRadii(new float[]{newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius});
        layoutProgress.setBackground((Drawable)progressDrawable);
        float ratio = max / progress;
        int progressWidth = (int)((totalWidth - (float)(padding * 2)) / ratio);
        ViewGroup.MarginLayoutParams progressParams = (ViewGroup.MarginLayoutParams)layoutProgress.getLayoutParams();
        progressParams.width = progressWidth;
        if (padding + progressWidth / 2 < radius) {
            int margin;
            progressParams.topMargin = margin = Math.max(radius - padding, 0) - progressWidth / 2;
            progressParams.bottomMargin = margin;
        } else {
            progressParams.topMargin = 0;
            progressParams.bottomMargin = 0;
        }
        layoutProgress.setLayoutParams((ViewGroup.LayoutParams)progressParams);
    }

    @Override
    protected void onViewDraw() {
    }
}

