/*
 * Decompiled with CFR 0.152.
 */
package com.akexorcist.roundcornerprogressbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.akexorcist.roundcornerprogressbar.R;
import com.akexorcist.roundcornerprogressbar.common.BaseRoundCornerProgressBar;

public class TextRoundCornerProgressBar
extends BaseRoundCornerProgressBar
implements ViewTreeObserver.OnGlobalLayoutListener {
    protected static final int DEFAULT_TEXT_SIZE = 16;
    protected static final int DEFAULT_TEXT_MARGIN = 10;
    private TextView tvProgress;
    private int colorTextProgress;
    private int textProgressSize;
    private int textProgressMargin;
    private String textProgress;

    public TextRoundCornerProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TextRoundCornerProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected int initLayout() {
        return R.layout.layout_text_round_corner_progress_bar;
    }

    @Override
    protected void initStyleable(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.TextRoundCornerProgress);
        this.colorTextProgress = typedArray.getColor(R.styleable.TextRoundCornerProgress_rcTextProgressColor, -1);
        this.textProgressSize = (int)typedArray.getDimension(R.styleable.TextRoundCornerProgress_rcTextProgressSize, this.dp2px(16.0f));
        this.textProgressMargin = (int)typedArray.getDimension(R.styleable.TextRoundCornerProgress_rcTextProgressMargin, this.dp2px(10.0f));
        this.textProgress = typedArray.getString(R.styleable.TextRoundCornerProgress_rcTextProgress);
        typedArray.recycle();
    }

    @Override
    protected void initView() {
        this.tvProgress = (TextView)this.findViewById(R.id.tv_progress);
        this.tvProgress.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    @Override
    protected void drawProgress(LinearLayout layoutProgress, float max, float progress, float totalWidth, int radius, int padding, int colorProgress, boolean isReverse) {
        GradientDrawable backgroundDrawable = this.createGradientDrawable(colorProgress);
        int newRadius = radius - padding / 2;
        backgroundDrawable.setCornerRadii(new float[]{newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius, newRadius});
        if (Build.VERSION.SDK_INT >= 16) {
            layoutProgress.setBackground((Drawable)backgroundDrawable);
        } else {
            layoutProgress.setBackgroundDrawable((Drawable)backgroundDrawable);
        }
        float ratio = max / progress;
        int progressWidth = (int)((totalWidth - (float)(padding * 2)) / ratio);
        ViewGroup.LayoutParams progressParams = layoutProgress.getLayoutParams();
        progressParams.width = progressWidth;
        layoutProgress.setLayoutParams(progressParams);
    }

    @Override
    protected void onViewDraw() {
        this.drawTextProgress();
        this.drawTextProgressSize();
        this.drawTextProgressMargin();
        this.drawTextProgressPosition();
        this.drawTextProgressColor();
    }

    private void drawTextProgress() {
        this.tvProgress.setText((CharSequence)this.textProgress);
    }

    private void drawTextProgressColor() {
        this.tvProgress.setTextColor(this.colorTextProgress);
    }

    private void drawTextProgressSize() {
        this.tvProgress.setTextSize(0, (float)this.textProgressSize);
    }

    private void drawTextProgressMargin() {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.tvProgress.getLayoutParams();
        params.setMargins(this.textProgressMargin, 0, this.textProgressMargin, 0);
        this.tvProgress.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void drawTextProgressPosition() {
        this.clearTextProgressAlign();
        int textProgressWidth = this.tvProgress.getMeasuredWidth() + this.getTextProgressMargin() * 2;
        float ratio = this.getMax() / this.getProgress();
        int progressWidth = (int)((this.getLayoutWidth() - (float)(this.getPadding() * 2)) / ratio);
        if (textProgressWidth + this.textProgressMargin < progressWidth) {
            this.alignTextProgressInsideProgress();
        } else {
            this.alignTextProgressOutsideProgress();
        }
    }

    private void clearTextProgressAlign() {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.tvProgress.getLayoutParams();
        params.addRule(5, 0);
        params.addRule(7, 0);
        params.addRule(0, 0);
        params.addRule(1, 0);
        if (Build.VERSION.SDK_INT >= 17) {
            params.removeRule(16);
            params.removeRule(17);
            params.removeRule(18);
            params.removeRule(19);
        }
        this.tvProgress.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void alignTextProgressInsideProgress() {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.tvProgress.getLayoutParams();
        if (this.isReverse()) {
            params.addRule(5, R.id.layout_progress);
            if (Build.VERSION.SDK_INT >= 17) {
                params.addRule(18, R.id.layout_progress);
            }
        } else {
            params.addRule(7, R.id.layout_progress);
            if (Build.VERSION.SDK_INT >= 17) {
                params.addRule(19, R.id.layout_progress);
            }
        }
        this.tvProgress.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void alignTextProgressOutsideProgress() {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.tvProgress.getLayoutParams();
        if (this.isReverse()) {
            params.addRule(0, R.id.layout_progress);
            if (Build.VERSION.SDK_INT >= 17) {
                params.addRule(16, R.id.layout_progress);
            }
        } else {
            params.addRule(1, R.id.layout_progress);
            if (Build.VERSION.SDK_INT >= 17) {
                params.addRule(17, R.id.layout_progress);
            }
        }
        this.tvProgress.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public String getProgressText() {
        return this.textProgress;
    }

    public void setProgressText(String text) {
        this.textProgress = text;
        this.drawTextProgress();
        this.drawTextProgressPosition();
    }

    @Override
    public void setProgress(float progress) {
        super.setProgress(progress);
        this.drawTextProgressPosition();
    }

    public int getTextProgressColor() {
        return this.colorTextProgress;
    }

    public void setTextProgressColor(int color2) {
        this.colorTextProgress = color2;
        this.drawTextProgressColor();
    }

    public int getTextProgressSize() {
        return this.textProgressSize;
    }

    public void setTextProgressSize(int size) {
        this.textProgressSize = size;
        this.drawTextProgressSize();
        this.drawTextProgressPosition();
    }

    public int getTextProgressMargin() {
        return this.textProgressMargin;
    }

    public void setTextProgressMargin(int margin) {
        this.textProgressMargin = margin;
        this.drawTextProgressMargin();
        this.drawTextProgressPosition();
    }

    public void onGlobalLayout() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.tvProgress.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        } else {
            this.tvProgress.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        this.drawTextProgressPosition();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.colorTextProgress = this.colorTextProgress;
        ss.textProgressSize = this.textProgressSize;
        ss.textProgressMargin = this.textProgressMargin;
        ss.textProgress = this.textProgress;
        return ss;
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.colorTextProgress = ss.colorTextProgress;
        this.textProgressSize = ss.textProgressSize;
        this.textProgressMargin = ss.textProgressMargin;
        this.textProgress = ss.textProgress;
    }

    private static class SavedState
    extends View.BaseSavedState {
        int colorTextProgress;
        int textProgressSize;
        int textProgressMargin;
        String textProgress;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.colorTextProgress = in.readInt();
            this.textProgressSize = in.readInt();
            this.textProgressMargin = in.readInt();
            this.textProgress = in.readString();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.colorTextProgress);
            out.writeInt(this.textProgressSize);
            out.writeInt(this.textProgressMargin);
            out.writeString(this.textProgress);
        }
    }
}

