/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.handler;

import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.model.request.ConfigRequest;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.client.CommonRpcClient;
import com.aizuda.snailjob.server.common.dto.ConfigSyncTask;
import com.aizuda.snailjob.server.common.dto.InstanceLiveInfo;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class ConfigVersionSyncHandler
implements Lifecycle,
Runnable {
    private static final LinkedBlockingQueue<ConfigSyncTask> QUEUE = new LinkedBlockingQueue(256);
    public Thread THREAD = null;
    private final AccessTemplate accessTemplate;
    private final InstanceManager instanceManager;

    public boolean addSyncTask(String groupName, String namespaceId, Integer currentVersion) {
        ConfigSyncTask configSyncTask = new ConfigSyncTask();
        configSyncTask.setCurrentVersion(currentVersion);
        configSyncTask.setNamespaceId(namespaceId);
        configSyncTask.setGroupName(groupName);
        return QUEUE.offer(configSyncTask);
    }

    public void syncVersion(String groupName, String namespaceId) {
        try {
            Set<InstanceLiveInfo> instanceALiveInfoSet = this.instanceManager.getInstanceALiveInfoSet(namespaceId, groupName);
            for (InstanceLiveInfo instanceLiveInfo : instanceALiveInfoSet) {
                ConfigRequest configRequest = this.accessTemplate.getGroupConfigAccess().getConfigInfo(groupName, namespaceId);
                CommonRpcClient rpcClient = RequestBuilder.newBuilder().failover(false).failRetry(true).retryTimes(3).retryInterval(1).nodeInfo(instanceLiveInfo).client(CommonRpcClient.class).build();
                SnailJobLog.LOCAL.info("Synchronization result [{}]", new Object[]{rpcClient.syncConfig(configRequest)});
            }
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("version sync error. groupName:[{}]", new Object[]{groupName, e});
        }
    }

    @Override
    public void start() {
        this.THREAD = new Thread((Runnable)this, "config-version-sync");
        this.THREAD.start();
    }

    @Override
    public void close() {
        if (Objects.nonNull(this.THREAD)) {
            this.THREAD.interrupt();
        }
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                ConfigSyncTask task = QUEUE.take();
                Integer remoteVersion = this.accessTemplate.getGroupConfigAccess().getConfigVersion(task.getGroupName(), task.getNamespaceId());
                if (!Objects.isNull(remoteVersion) && task.getCurrentVersion().equals(remoteVersion)) continue;
                this.syncVersion(task.getGroupName(), task.getNamespaceId());
            }
            catch (InterruptedException e) {
                SnailJobLog.LOCAL.info("[{}] thread stop.", new Object[]{Thread.currentThread().getName()});
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("client refresh expireAt error.", new Object[]{e});
            }
            finally {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    @Generated
    public ConfigVersionSyncHandler(AccessTemplate accessTemplate, InstanceManager instanceManager) {
        this.accessTemplate = accessTemplate;
        this.instanceManager = instanceManager;
    }
}

