/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.allocate.client;

import cn.hutool.core.collection.CollectionUtil;
import com.aizuda.snailjob.server.common.ClientLoadBalance;
import com.aizuda.snailjob.server.common.allocate.client.ClientLoadBalanceManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class ClientLoadBalanceLRU
implements ClientLoadBalance {
    private int size;
    private ConcurrentHashMap<String, LinkedHashMap<String, String>> LRU_CACHE = new ConcurrentHashMap();
    private static long CACHE_VALID_TIME = 0L;

    public ClientLoadBalanceLRU(int size) {
        this.size = size;
    }

    @Override
    public String route(String allocKey, TreeSet<String> clientAllAddressSet) {
        LinkedHashMap<String, String> lruItem;
        if (System.currentTimeMillis() > CACHE_VALID_TIME) {
            this.LRU_CACHE.clear();
            CACHE_VALID_TIME = System.currentTimeMillis() + 43200000L;
        }
        if (Objects.isNull(lruItem = this.LRU_CACHE.get(allocKey))) {
            lruItem = new LinkedHashMap<String, String>(16, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry eldest) {
                    return super.size() > ClientLoadBalanceLRU.this.size;
                }
            };
            this.LRU_CACHE.put(allocKey, lruItem);
        }
        for (String address : clientAllAddressSet) {
            lruItem.computeIfAbsent(address, key -> address);
        }
        ArrayList<String> delKeys = new ArrayList<String>();
        for (String address : lruItem.keySet()) {
            if (clientAllAddressSet.contains(address)) continue;
            delKeys.add(address);
        }
        if (CollectionUtil.isNotEmpty(delKeys)) {
            for (String delKey : delKeys) {
                lruItem.remove(delKey);
            }
        }
        return (String)lruItem.values().stream().findFirst().get();
    }

    @Override
    public int routeType() {
        return ClientLoadBalanceManager.AllocationAlgorithmEnum.LRU.getType();
    }
}

