/*
 * Decompiled with CFR 0.152.
 */
package com.aiven.log.core.writer;

import android.text.TextUtils;
import com.aiven.log.LogManager;
import com.aiven.log.core.IFullLinkQueueListener;
import com.aiven.log.core.writer.BaseWriter;
import com.aiven.log.core.writer.PieWriter;
import com.aiven.log.mode.LinkQueue;
import com.aiven.log.mode.LogBean;
import com.aiven.log.util.LogFileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;

public class CWriter
extends BaseWriter
implements IFullLinkQueueListener {
    private HashMap<String, LinkQueue> tagDivideMap = new HashMap();
    private HashMap<String, PieWriter> executeWritePie;

    @Override
    public void initWriter() {
        File file = LogFileUtil.createFileIfNotExist(LogManager.getInstance().getRootPath(), this.getFileName());
        try {
            this.mWriter = new PrintWriter(new FileOutputStream(file, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startWrite(LogBean log) {
        super.startWrite(log);
        if (LogManager.getInstance().subTag) {
            LinkQueue queue;
            String tag = log.getTag();
            if (TextUtils.isEmpty((CharSequence)tag)) {
                tag = "--ALOG--";
            }
            if ((queue = this.tagDivideMap.get(tag)) == null) {
                queue = new LinkQueue(this);
                this.tagDivideMap.put(tag, queue);
            }
            queue.poll(log);
        }
    }

    @Override
    public void popAll(List<LogBean> beanList) {
        if (beanList != null && beanList.size() > 0) {
            String tag;
            PieWriter writer;
            if (this.executeWritePie == null) {
                this.executeWritePie = new HashMap();
            }
            if ((writer = this.executeWritePie.get(tag = beanList.get(0).getTag())) == null) {
                writer = new PieWriter(beanList, this);
                this.executeWritePie.put(writer.getTag(), writer);
                writer.execute();
            } else {
                writer.setNextList(beanList);
            }
        }
    }

    @Override
    public void writeOver(String tag) {
        try {
            this.executeWritePie.remove(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

