/*
 * Decompiled with CFR 0.152.
 */
package com.aiven.log.core;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.aiven.log.LogManager;
import com.aiven.log.mode.LogBean;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class WholeCrashHandler
implements Thread.UncaughtExceptionHandler {
    private static WholeCrashHandler crashHandler = new WholeCrashHandler();
    private List<AppInfo> mAppInfoMap;
    private PackageManager mPkgManager;
    private PackageInfo mPkgInfo;
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private Context context;

    private WholeCrashHandler() {
    }

    public static WholeCrashHandler getInstance() {
        return crashHandler;
    }

    public void init(Context context) {
        this.context = context;
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.initCfg(context);
    }

    private void initCfg(Context context) {
        if (context == null) {
            return;
        }
        try {
            this.mPkgManager = context.getPackageManager();
            this.mPkgInfo = this.mPkgManager.getPackageInfo(context.getPackageName(), 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (!this.handleException(ex) && this.mDefaultHandler != null) {
            this.mDefaultHandler.uncaughtException(thread, ex);
        } else {
            Process.killProcess((int)Process.myPid());
        }
    }

    private boolean handleException(Throwable ex) {
        if (ex == null) {
            return false;
        }
        if (LogManager.getInstance().getState() == 0 || LogManager.getInstance().getState() == 1) {
            return false;
        }
        if (this.context == null) {
            return false;
        }
        this.collectDeviceInfo();
        String log = this.saveCrashInfo2File(ex);
        Log.e((String)"crash", (String)log);
        LogManager.getInstance().pushLog(new LogBean("crash", log, 3840));
        if (this.mAppInfoMap != null) {
            this.mAppInfoMap.clear();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveCrashInfo2File(Throwable ex) {
        StringBuffer sb = new StringBuffer("\n");
        if (this.mAppInfoMap != null && this.mAppInfoMap.size() > 0) {
            List<AppInfo> list = this.mAppInfoMap;
            synchronized (list) {
                for (int i = 0; i < this.mAppInfoMap.size(); ++i) {
                    sb.append(this.mAppInfoMap.get(i).toString());
                }
            }
        }
        sb.append("\u9519\u8bef\u539f\u56e0:" + ex.toString() + "\n");
        sb.append("\u5177\u4f53\u5982\u4e0b:\n=======================================================\n");
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        ex.printStackTrace(printWriter);
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        printWriter.close();
        String result = ((Object)writer).toString();
        sb.append(result);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectDeviceInfo() {
        if (this.mAppInfoMap == null) {
            this.mAppInfoMap = new ArrayList<AppInfo>();
        }
        List<AppInfo> list = this.mAppInfoMap;
        synchronized (list) {
            if (this.mPkgInfo != null) {
                String versionName = this.mPkgInfo.versionName == null ? "null" : this.mPkgInfo.versionName;
                String versionCode = this.mPkgInfo.versionCode + "";
                this.mAppInfoMap.add(new AppInfo("apk\u57fa\u672c\u4fe1\u606f", ""));
                this.mAppInfoMap.add(new AppInfo("versionName", versionName));
                this.mAppInfoMap.add(new AppInfo("versionCode", versionCode));
                this.mAppInfoMap.add(new AppInfo("\u8bbe\u5907\u57fa\u672c\u4fe1\u606f", ""));
                this.mAppInfoMap.add(new AppInfo("\u578b\u53f7", Build.MODEL));
                this.mAppInfoMap.add(new AppInfo("SDK", String.valueOf(Build.VERSION.SDK_INT)));
                this.mAppInfoMap.add(new AppInfo("SystemVersion", Build.VERSION.RELEASE));
                if (Build.VERSION.SDK_INT >= 21) {
                    this.mAppInfoMap.add(new AppInfo("SUPPORTED_ABIS", this.arrToStr(Build.SUPPORTED_ABIS)));
                    this.mAppInfoMap.add(new AppInfo("SUPPORTED_32_BIT_ABIS", this.arrToStr(Build.SUPPORTED_32_BIT_ABIS)));
                    this.mAppInfoMap.add(new AppInfo("SUPPORTED_64_BIT_ABIS", this.arrToStr(Build.SUPPORTED_64_BIT_ABIS)));
                } else {
                    this.mAppInfoMap.add(new AppInfo("CPU_ABI", Build.CPU_ABI));
                    this.mAppInfoMap.add(new AppInfo("CPU_ABI2", Build.CPU_ABI2));
                }
                this.mAppInfoMap.add(new AppInfo("Product", Build.PRODUCT));
                this.mAppInfoMap.add(new AppInfo("deviceID", Build.ID));
                this.mAppInfoMap.add(new AppInfo("SERIAL", Build.SERIAL));
            }
        }
    }

    private String arrToStr(String[] strs) {
        if (strs != null && strs.length > 0) {
            StringBuffer bf = new StringBuffer();
            for (int i = 0; i < strs.length; ++i) {
                bf.append(strs[i]);
                bf.append("     ");
            }
            return bf.toString();
        }
        return "NULL";
    }

    class AppInfo {
        String key;
        String value;

        public AppInfo(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            if (TextUtils.isEmpty((CharSequence)this.value)) {
                return this.key + "\n";
            }
            return this.key + "=" + this.value + "\n";
        }
    }
}

