/*
 * Decompiled with CFR 0.152.
 */
package com.aiven.log.core.writer;

import com.aiven.log.mode.LogBean;
import com.aiven.log.util.LogTimeUtils;
import java.io.PrintWriter;

public abstract class BaseWriter {
    protected PrintWriter mWriter;

    public BaseWriter() {
        this.initWriter();
    }

    public abstract void initWriter();

    public void startWrite(LogBean log) {
        this.checkIsValid(log);
        if (this.mWriter == null) {
            return;
        }
        this.mWriter.println(log.toString());
        this.mWriter.flush();
    }

    private void checkIsValid(LogBean log) {
        if (this.mWriter == null) {
            this.initWriter();
            return;
        }
        if (System.currentTimeMillis() / 1000L / 60L / 60L / 24L != log.getTime() / 1000L / 60L / 60L / 24L) {
            this.mWriter = null;
            this.initWriter();
        }
    }

    protected String getFileName() {
        return LogTimeUtils.getInstance().getDate() + ".txt";
    }
}

