/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.utils;

import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import androidx.annotation.Nullable;
import com.airbnb.lottie.utils.MiscUtils;
import com.airbnb.lottie.utils.OffscreenLayer;
import com.airbnb.lottie.utils.Utils;

public class DropShadow {
    private float radius = 0.0f;
    private float dx = 0.0f;
    private float dy = 0.0f;
    private int color = 0;
    @Nullable
    private float[] vecs;

    public DropShadow() {
    }

    public DropShadow(float radius, float dx, float dy, int color) {
        this.radius = radius;
        this.dx = dx;
        this.dy = dy;
        this.color = color;
        this.vecs = null;
    }

    public DropShadow(DropShadow other) {
        this.radius = other.radius;
        this.dx = other.dx;
        this.dy = other.dy;
        this.color = other.color;
        this.vecs = null;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getDx() {
        return this.dx;
    }

    public void setDx(float dx) {
        this.dx = dx;
    }

    public float getDy() {
        return this.dy;
    }

    public void setDy(float dy) {
        this.dy = dy;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public boolean sameAs(DropShadow other) {
        return this.radius == other.radius && this.dx == other.dx && this.dy == other.dy && this.color == other.color;
    }

    public void transformBy(Matrix matrix) {
        if (this.vecs == null) {
            this.vecs = new float[2];
        }
        this.vecs[0] = this.dx;
        this.vecs[1] = this.dy;
        matrix.mapVectors(this.vecs);
        this.dx = this.vecs[0];
        this.dy = this.vecs[1];
        this.radius = matrix.mapRadius(this.radius);
    }

    public void multiplyOpacity(int newAlpha) {
        int opacity = Math.round((float)(Color.alpha((int)this.color) * MiscUtils.clamp(newAlpha, 0, 255)) / 255.0f);
        this.color = Color.argb((int)opacity, (int)Color.red((int)this.color), (int)Color.green((int)this.color), (int)Color.blue((int)this.color));
    }

    public void applyTo(Paint paint) {
        if (Color.alpha((int)this.color) > 0) {
            paint.setShadowLayer(Math.max(this.radius, Float.MIN_VALUE), this.dx, this.dy, this.color);
        } else {
            paint.clearShadowLayer();
        }
    }

    public void applyWithAlpha(int alpha, Paint paint) {
        int finalAlpha = Utils.mixOpacities(Color.alpha((int)this.color), MiscUtils.clamp(alpha, 0, 255));
        if (finalAlpha > 0) {
            int newColor = Color.argb((int)finalAlpha, (int)Color.red((int)this.color), (int)Color.green((int)this.color), (int)Color.blue((int)this.color));
            paint.setShadowLayer(Math.max(this.radius, Float.MIN_VALUE), this.dx, this.dy, newColor);
        } else {
            paint.clearShadowLayer();
        }
    }

    public void applyWithAlpha(int alpha, OffscreenLayer.ComposeOp op) {
        op.shadow = new DropShadow(this);
        op.shadow.multiplyOpacity(alpha);
    }

    public void applyTo(OffscreenLayer.ComposeOp op) {
        op.shadow = Color.alpha((int)this.color) > 0 ? this : null;
    }
}

