/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.content.ShapeGroup;
import com.airbnb.lottie.parser.ContentModelParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import java.io.IOException;
import java.util.ArrayList;

class ShapeGroupParser {
    private static final JsonReader.Options NAMES = JsonReader.Options.of("nm", "hd", "it");

    private ShapeGroupParser() {
    }

    static ShapeGroup parse(JsonReader reader, LottieComposition composition) throws IOException {
        String name = null;
        boolean hidden = false;
        ArrayList<ContentModel> items = new ArrayList<ContentModel>();
        block5: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    name = reader.nextString();
                    continue block5;
                }
                case 1: {
                    hidden = reader.nextBoolean();
                    continue block5;
                }
                case 2: {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        ContentModel newItem = ContentModelParser.parse(reader, composition);
                        if (newItem == null) continue;
                        items.add(newItem);
                    }
                    reader.endArray();
                    continue block5;
                }
            }
            reader.skipValue();
        }
        return new ShapeGroup(name, items, hidden);
    }
}

