/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.LottieFeatureFlag;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.MergePathsContent;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.utils.Logger;

public class MergePaths
implements ContentModel {
    private final String name;
    private final MergePathsMode mode;
    private final boolean hidden;

    public MergePaths(String name, MergePathsMode mode, boolean hidden) {
        this.name = name;
        this.mode = mode;
        this.hidden = hidden;
    }

    public String getName() {
        return this.name;
    }

    public MergePathsMode getMode() {
        return this.mode;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    @Nullable
    public Content toContent(LottieDrawable drawable, LottieComposition composition, BaseLayer layer) {
        if (!drawable.isFeatureFlagEnabled(LottieFeatureFlag.MergePathsApi19)) {
            Logger.warning("Animation contains merge paths but they are disabled.");
            return null;
        }
        return new MergePathsContent(this);
    }

    public String toString() {
        return "MergePaths{mode=" + (Object)((Object)this.mode) + '}';
    }

    public static enum MergePathsMode {
        MERGE,
        ADD,
        SUBTRACT,
        INTERSECT,
        EXCLUDE_INTERSECTIONS;


        public static MergePathsMode forId(int id) {
            switch (id) {
                case 1: {
                    return MERGE;
                }
                case 2: {
                    return ADD;
                }
                case 3: {
                    return SUBTRACT;
                }
                case 4: {
                    return INTERSECT;
                }
                case 5: {
                    return EXCLUDE_INTERSECTIONS;
                }
            }
            return MERGE;
        }
    }
}

