/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.content.BlurEffect;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import java.io.IOException;

class BlurEffectParser {
    private static final JsonReader.Options BLUR_EFFECT_NAMES = JsonReader.Options.of("ef");
    private static final JsonReader.Options INNER_BLUR_EFFECT_NAMES = JsonReader.Options.of("ty", "v");

    BlurEffectParser() {
    }

    @Nullable
    static BlurEffect parse(JsonReader reader, LottieComposition composition) throws IOException {
        BlurEffect blurEffect = null;
        block3: while (reader.hasNext()) {
            switch (reader.selectName(BLUR_EFFECT_NAMES)) {
                case 0: {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        BlurEffect be = BlurEffectParser.maybeParseInnerEffect(reader, composition);
                        if (be == null) continue;
                        blurEffect = be;
                    }
                    reader.endArray();
                    continue block3;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        return blurEffect;
    }

    @Nullable
    private static BlurEffect maybeParseInnerEffect(JsonReader reader, LottieComposition composition) throws IOException {
        BlurEffect blurEffect = null;
        boolean isCorrectType = false;
        reader.beginObject();
        block4: while (reader.hasNext()) {
            switch (reader.selectName(INNER_BLUR_EFFECT_NAMES)) {
                case 0: {
                    isCorrectType = reader.nextInt() == 0;
                    continue block4;
                }
                case 1: {
                    if (isCorrectType) {
                        blurEffect = new BlurEffect(AnimatableValueParser.parseFloat(reader, composition));
                        continue block4;
                    }
                    reader.skipValue();
                    continue block4;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        reader.endObject();
        return blurEffect;
    }
}

