/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableColorValue;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatableTextProperties;
import com.airbnb.lottie.model.animatable.AnimatableTextRangeSelector;
import com.airbnb.lottie.model.animatable.AnimatableTextStyle;
import com.airbnb.lottie.model.content.TextRangeUnits;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import com.airbnb.lottie.value.Keyframe;
import java.io.IOException;
import java.util.Collections;

public class AnimatableTextPropertiesParser {
    private static final JsonReader.Options PROPERTIES_NAMES = JsonReader.Options.of("s", "a");
    private static final JsonReader.Options ANIMATABLE_RANGE_PROPERTIES_NAMES = JsonReader.Options.of("s", "e", "o", "r");
    private static final JsonReader.Options ANIMATABLE_PROPERTIES_NAMES = JsonReader.Options.of("fc", "sc", "sw", "t", "o");

    private AnimatableTextPropertiesParser() {
    }

    public static AnimatableTextProperties parse(JsonReader reader, LottieComposition composition) throws IOException {
        AnimatableTextStyle textStyle = null;
        AnimatableTextRangeSelector rangeSelector = null;
        reader.beginObject();
        block4: while (reader.hasNext()) {
            switch (reader.selectName(PROPERTIES_NAMES)) {
                case 0: {
                    rangeSelector = AnimatableTextPropertiesParser.parseAnimatableTextRangeSelector(reader, composition);
                    continue block4;
                }
                case 1: {
                    textStyle = AnimatableTextPropertiesParser.parseAnimatableTextStyle(reader, composition);
                    continue block4;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        reader.endObject();
        return new AnimatableTextProperties(textStyle, rangeSelector);
    }

    private static AnimatableTextRangeSelector parseAnimatableTextRangeSelector(JsonReader reader, LottieComposition composition) throws IOException {
        AnimatableIntegerValue start = null;
        AnimatableIntegerValue end = null;
        AnimatableIntegerValue offset = null;
        TextRangeUnits units = null;
        reader.beginObject();
        block6: while (reader.hasNext()) {
            switch (reader.selectName(ANIMATABLE_RANGE_PROPERTIES_NAMES)) {
                case 0: {
                    start = AnimatableValueParser.parseInteger(reader, composition);
                    continue block6;
                }
                case 1: {
                    end = AnimatableValueParser.parseInteger(reader, composition);
                    continue block6;
                }
                case 2: {
                    offset = AnimatableValueParser.parseInteger(reader, composition);
                    continue block6;
                }
                case 3: {
                    int textRangeUnits = reader.nextInt();
                    if (textRangeUnits != 1 && textRangeUnits != 2) {
                        composition.addWarning("Unsupported text range units: " + textRangeUnits);
                        units = TextRangeUnits.INDEX;
                        continue block6;
                    }
                    units = textRangeUnits == 1 ? TextRangeUnits.PERCENT : TextRangeUnits.INDEX;
                    continue block6;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        reader.endObject();
        if (start == null && end != null) {
            start = new AnimatableIntegerValue(Collections.singletonList(new Keyframe<Integer>(0)));
        }
        return new AnimatableTextRangeSelector(start, end, offset, units);
    }

    private static AnimatableTextStyle parseAnimatableTextStyle(JsonReader reader, LottieComposition composition) throws IOException {
        AnimatableColorValue color = null;
        AnimatableColorValue stroke = null;
        AnimatableFloatValue strokeWidth = null;
        AnimatableFloatValue tracking = null;
        AnimatableIntegerValue opacity = null;
        reader.beginObject();
        block7: while (reader.hasNext()) {
            switch (reader.selectName(ANIMATABLE_PROPERTIES_NAMES)) {
                case 0: {
                    color = AnimatableValueParser.parseColor(reader, composition);
                    continue block7;
                }
                case 1: {
                    stroke = AnimatableValueParser.parseColor(reader, composition);
                    continue block7;
                }
                case 2: {
                    strokeWidth = AnimatableValueParser.parseFloat(reader, composition);
                    continue block7;
                }
                case 3: {
                    tracking = AnimatableValueParser.parseFloat(reader, composition);
                    continue block7;
                }
                case 4: {
                    opacity = AnimatableValueParser.parseInteger(reader, composition);
                    continue block7;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        reader.endObject();
        return new AnimatableTextStyle(color, stroke, strokeWidth, tracking, opacity);
    }
}

