/*
 * Decompiled with CFR 0.152.
 */
package com.agapsys.security.web;

import com.agapsys.security.SecurityManager;
import com.agapsys.security.web.AttributeService;
import com.agapsys.security.web.NotAllowedException;
import com.agapsys.security.web.User;
import com.agapsys.security.web.WebSecurityFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class WebSecurityManager
extends SecurityManager {
    private final AttributeService attributeService = AttributeService.getInstance();

    public abstract User getCurrentUser();

    public abstract void setCurrentUser(User var1);

    public abstract void unregisterCurrentUser();

    protected boolean isAllowed(HttpServletRequest request) {
        return true;
    }

    protected final HttpServletRequest getRequest() {
        return (HttpServletRequest)this.attributeService.getAttribute(WebSecurityFilter.ATTR_HTTP_REQUEST);
    }

    protected final HttpServletResponse getResponse() {
        return (HttpServletResponse)this.attributeService.getAttribute(WebSecurityFilter.ATTR_HTTP_RESPONSE);
    }

    public final boolean isAllowed(String[] requiredRoles) {
        if (!this.isAllowed(this.getRequest())) {
            return false;
        }
        User currentUser = this.getCurrentUser();
        if (currentUser == null) {
            return false;
        }
        if (currentUser.isAdmin()) {
            return true;
        }
        for (String requiredRole : requiredRoles) {
            if (currentUser.getRoles().contains(requiredRole)) continue;
            return false;
        }
        return true;
    }

    public final void onNotAllowed() throws NotAllowedException {
        throw new NotAllowedException(this.getCurrentUser());
    }
}

