/*
 * Decompiled with CFR 0.152.
 */
package com.agapsys.security.web;

import com.agapsys.security.web.User;
import com.agapsys.security.web.WebSecurityManager;
import javax.servlet.http.HttpSession;

public class SessionSecurityManager
extends WebSecurityManager {
    private static final String SESSION_ATTR_USER = SessionSecurityManager.class + ".user";

    @Override
    public User getCurrentUser() {
        HttpSession session = this.getRequest().getSession(false);
        if (session == null) {
            return null;
        }
        return (User)session.getAttribute(SESSION_ATTR_USER);
    }

    @Override
    public void setCurrentUser(User user) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        HttpSession session = this.getRequest().getSession(true);
        session.setAttribute(SESSION_ATTR_USER, (Object)user);
    }

    @Override
    public void unregisterCurrentUser() {
        HttpSession session = this.getRequest().getSession(false);
        if (session != null) {
            session.removeAttribute(SESSION_ATTR_USER);
        }
    }
}

