/*
 * Decompiled with CFR 0.152.
 */
package com.agapsys.security.web;

import com.agapsys.security.web.SessionSecurityManager;
import com.agapsys.security.web.User;
import java.util.Objects;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SessionCsrfSecurityManager
extends SessionSecurityManager {
    private static final String SESSION_ATTR_CSRF_TOKEN = SessionCsrfSecurityManager.class.getName() + ".csrfToken";
    private static final int CSRF_TOKEN_LENGTH = 128;
    public static final String CSRF_HEADER = "X-Csrf-Token";

    private static String getRandomString(int length) throws IllegalArgumentException {
        char[] chars = "abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        return SessionCsrfSecurityManager.getRandomString(length, chars);
    }

    private static String getRandomString(int length, char[] chars) throws IllegalArgumentException {
        if (length < 1) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        if (chars == null || chars.length == 0) {
            throw new IllegalArgumentException("Null/Empty chars");
        }
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            char c = chars[random.nextInt(chars.length)];
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    protected boolean isAllowed(HttpServletRequest request) {
        HttpSession session = this.getRequest().getSession(false);
        if (session == null) {
            return false;
        }
        String sessionToken = (String)session.getAttribute(SESSION_ATTR_CSRF_TOKEN);
        String requestToken = request.getHeader(CSRF_HEADER);
        return Objects.equals(sessionToken, requestToken);
    }

    @Override
    public void setCurrentUser(User user) {
        super.setCurrentUser(user);
        HttpSession session = this.getRequest().getSession(true);
        String token = SessionCsrfSecurityManager.getRandomString(128);
        session.setAttribute(SESSION_ATTR_CSRF_TOKEN, (Object)token);
        this.getResponse().setHeader(CSRF_HEADER, token);
    }

    @Override
    public void unregisterCurrentUser() {
        super.unregisterCurrentUser();
        HttpSession session = this.getRequest().getSession(false);
        if (session != null) {
            session.removeAttribute(SESSION_ATTR_CSRF_TOKEN);
        }
    }
}

