/*
 * Decompiled with CFR 0.152.
 */
package com.afollestad.materialdialogs.folderselector;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.widget.Toast;
import com.afollestad.materialdialogs.DialogAction;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.commons.R;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FolderChooserDialog
extends DialogFragment
implements MaterialDialog.ListCallback {
    private static final String DEFAULT_TAG = "[MD_FOLDER_SELECTOR]";
    private File parentFolder;
    private File[] parentContents;
    private boolean canGoUp = false;
    private FolderCallback callback;

    String[] getContentsArray() {
        if (this.parentContents == null) {
            if (this.canGoUp) {
                return new String[]{this.getBuilder().goUpLabel};
            }
            return new String[0];
        }
        String[] results = new String[this.parentContents.length + (this.canGoUp ? 1 : 0)];
        if (this.canGoUp) {
            results[0] = this.getBuilder().goUpLabel;
        }
        for (int i = 0; i < this.parentContents.length; ++i) {
            results[this.canGoUp ? i + 1 : i] = this.parentContents[i].getName();
        }
        return results;
    }

    File[] listFiles() {
        File[] contents = this.parentFolder.listFiles();
        ArrayList<File> results = new ArrayList<File>();
        if (contents != null) {
            for (File fi : contents) {
                if (!fi.isDirectory()) continue;
                results.add(fi);
            }
            Collections.sort(results, new FolderSorter());
            return results.toArray(new File[results.size()]);
        }
        return null;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        if (Build.VERSION.SDK_INT >= 23 && ActivityCompat.checkSelfPermission((Context)this.getActivity(), (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
            return new MaterialDialog.Builder((Context)this.getActivity()).title(R.string.md_error_label).content(R.string.md_storage_perm_error).positiveText(17039370).build();
        }
        if (this.getArguments() == null || !this.getArguments().containsKey("builder")) {
            throw new IllegalStateException("You must create a FolderChooserDialog using the Builder.");
        }
        if (!this.getArguments().containsKey("current_path")) {
            this.getArguments().putString("current_path", this.getBuilder().initialPath);
        }
        this.parentFolder = new File(this.getArguments().getString("current_path"));
        this.checkIfCanGoUp();
        this.parentContents = this.listFiles();
        MaterialDialog.Builder builder = new MaterialDialog.Builder((Context)this.getActivity()).typeface(this.getBuilder().mediumFont, this.getBuilder().regularFont).title((CharSequence)this.parentFolder.getAbsolutePath()).items((CharSequence[])this.getContentsArray()).itemsCallback((MaterialDialog.ListCallback)this).onPositive(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                dialog.dismiss();
                FolderChooserDialog.this.callback.onFolderSelection(FolderChooserDialog.this, FolderChooserDialog.this.parentFolder);
            }
        }).onNegative(new MaterialDialog.SingleButtonCallback(){

            public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                dialog.dismiss();
            }
        }).autoDismiss(false).positiveText(this.getBuilder().chooseButton).negativeText(this.getBuilder().cancelButton);
        if (this.getBuilder().allowNewFolder) {
            builder.neutralText(this.getBuilder().newFolderButton);
            builder.onNeutral(new MaterialDialog.SingleButtonCallback(){

                public void onClick(@NonNull MaterialDialog dialog, @NonNull DialogAction which) {
                    FolderChooserDialog.this.createNewFolder();
                }
            });
        }
        if ("/".equals(this.getBuilder().initialPath)) {
            this.canGoUp = false;
        }
        return builder.build();
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (this.callback != null) {
            this.callback.onFolderChooserDismissed(this);
        }
    }

    private void createNewFolder() {
        new MaterialDialog.Builder((Context)this.getActivity()).title(this.getBuilder().newFolderButton).input(0, 0, false, new MaterialDialog.InputCallback(){

            public void onInput(@NonNull MaterialDialog dialog, CharSequence input) {
                File newFi = new File(FolderChooserDialog.this.parentFolder, input.toString());
                if (!newFi.mkdir()) {
                    String msg = "Unable to create folder " + newFi.getAbsolutePath() + ", make sure you have the WRITE_EXTERNAL_STORAGE permission or root permissions.";
                    Toast.makeText((Context)FolderChooserDialog.this.getActivity(), (CharSequence)msg, (int)1).show();
                } else {
                    FolderChooserDialog.this.reload();
                }
            }
        }).show();
    }

    public void onSelection(MaterialDialog materialDialog, View view, int i, CharSequence s) {
        if (this.canGoUp && i == 0) {
            this.parentFolder = this.parentFolder.getParentFile();
            if (this.parentFolder.getAbsolutePath().equals("/storage/emulated")) {
                this.parentFolder = this.parentFolder.getParentFile();
            }
            this.canGoUp = this.parentFolder.getParent() != null;
        } else {
            this.parentFolder = this.parentContents[this.canGoUp ? i - 1 : i];
            this.canGoUp = true;
            if (this.parentFolder.getAbsolutePath().equals("/storage/emulated")) {
                this.parentFolder = Environment.getExternalStorageDirectory();
            }
        }
        this.reload();
    }

    private void checkIfCanGoUp() {
        try {
            this.canGoUp = this.parentFolder.getPath().split("/").length > 1;
        }
        catch (IndexOutOfBoundsException e) {
            this.canGoUp = false;
        }
    }

    private void reload() {
        this.parentContents = this.listFiles();
        MaterialDialog dialog = (MaterialDialog)this.getDialog();
        dialog.setTitle((CharSequence)this.parentFolder.getAbsolutePath());
        this.getArguments().putString("current_path", this.parentFolder.getAbsolutePath());
        dialog.setItems((CharSequence[])this.getContentsArray());
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (this.getActivity() instanceof FolderCallback) {
            this.callback = (FolderCallback)this.getActivity();
        } else if (this.getParentFragment() instanceof FolderCallback) {
            this.callback = (FolderCallback)this.getParentFragment();
        } else {
            throw new IllegalStateException("FolderChooserDialog needs to be shown from an Activity/Fragment implementing FolderCallback.");
        }
    }

    public void show(FragmentActivity fragmentActivity) {
        this.show(fragmentActivity.getSupportFragmentManager());
    }

    public void show(FragmentManager fragmentManager) {
        String tag = this.getBuilder().tag;
        Fragment frag = fragmentManager.findFragmentByTag(tag);
        if (frag != null) {
            ((DialogFragment)frag).dismiss();
            fragmentManager.beginTransaction().remove(frag).commit();
        }
        this.show(fragmentManager, tag);
    }

    @NonNull
    private Builder getBuilder() {
        return (Builder)this.getArguments().getSerializable("builder");
    }

    private static class FolderSorter
    implements Comparator<File> {
        private FolderSorter() {
        }

        @Override
        public int compare(File lhs, File rhs) {
            return lhs.getName().compareTo(rhs.getName());
        }
    }

    public static class Builder
    implements Serializable {
        @NonNull
        final transient Context context;
        @StringRes
        int chooseButton;
        @StringRes
        int cancelButton;
        String initialPath;
        String tag;
        boolean allowNewFolder;
        @StringRes
        int newFolderButton;
        String goUpLabel;
        @Nullable
        String mediumFont;
        @Nullable
        String regularFont;

        public Builder(@NonNull Context context) {
            this.context = context;
            this.chooseButton = R.string.md_choose_label;
            this.cancelButton = 0x1040000;
            this.goUpLabel = "...";
            this.initialPath = Environment.getExternalStorageDirectory().getAbsolutePath();
        }

        @NonNull
        public Builder typeface(@Nullable String medium, @Nullable String regular) {
            this.mediumFont = medium;
            this.regularFont = regular;
            return this;
        }

        @NonNull
        public Builder chooseButton(@StringRes int text) {
            this.chooseButton = text;
            return this;
        }

        @NonNull
        public Builder cancelButton(@StringRes int text) {
            this.cancelButton = text;
            return this;
        }

        @NonNull
        public Builder goUpLabel(String text) {
            this.goUpLabel = text;
            return this;
        }

        @NonNull
        public Builder allowNewFolder(boolean allow, @StringRes int buttonLabel) {
            this.allowNewFolder = allow;
            if (buttonLabel == 0) {
                buttonLabel = R.string.new_folder;
            }
            this.newFolderButton = buttonLabel;
            return this;
        }

        @NonNull
        public Builder initialPath(@Nullable String initialPath) {
            if (initialPath == null) {
                initialPath = File.separator;
            }
            this.initialPath = initialPath;
            return this;
        }

        @NonNull
        public Builder tag(@Nullable String tag) {
            if (tag == null) {
                tag = FolderChooserDialog.DEFAULT_TAG;
            }
            this.tag = tag;
            return this;
        }

        @NonNull
        public FolderChooserDialog build() {
            FolderChooserDialog dialog = new FolderChooserDialog();
            Bundle args = new Bundle();
            args.putSerializable("builder", (Serializable)this);
            dialog.setArguments(args);
            return dialog;
        }

        @NonNull
        public FolderChooserDialog show(FragmentManager fragmentManager) {
            FolderChooserDialog dialog = this.build();
            dialog.show(fragmentManager);
            return dialog;
        }

        @NonNull
        public FolderChooserDialog show(FragmentActivity fragmentActivity) {
            return this.show(fragmentActivity.getSupportFragmentManager());
        }
    }

    public static interface FolderCallback {
        public void onFolderSelection(@NonNull FolderChooserDialog var1, @NonNull File var2);

        public void onFolderChooserDismissed(@NonNull FolderChooserDialog var1);
    }
}

