/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.sessions.core;

import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.OrderRequest;
import com.adyen.checkout.components.core.OrderResponse;
import com.adyen.checkout.components.core.internal.Configuration;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.sessions.core.CheckoutSessionResult;
import com.adyen.checkout.sessions.core.SessionModel;
import com.adyen.checkout.sessions.core.SessionPaymentResult;
import com.adyen.checkout.sessions.core.internal.CheckoutSessionInitializer;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0010\b\u0002\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000bH\u0086@\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0086@\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/adyen/checkout/sessions/core/CheckoutSessionProvider;", "", "()V", "createSession", "Lcom/adyen/checkout/sessions/core/CheckoutSessionResult;", "sessionModel", "Lcom/adyen/checkout/sessions/core/SessionModel;", "configuration", "Lcom/adyen/checkout/components/core/internal/Configuration;", "order", "Lcom/adyen/checkout/components/core/OrderRequest;", "Lcom/adyen/checkout/components/core/Order;", "(Lcom/adyen/checkout/sessions/core/SessionModel;Lcom/adyen/checkout/components/core/internal/Configuration;Lcom/adyen/checkout/components/core/OrderRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sessionPaymentResult", "Lcom/adyen/checkout/sessions/core/SessionPaymentResult;", "(Lcom/adyen/checkout/sessions/core/SessionPaymentResult;Lcom/adyen/checkout/components/core/internal/Configuration;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sessions-core_release"})
public final class CheckoutSessionProvider {
    @NotNull
    public static final CheckoutSessionProvider INSTANCE = new CheckoutSessionProvider();

    private CheckoutSessionProvider() {
    }

    @Nullable
    public final Object createSession(@NotNull SessionModel sessionModel, @NotNull Configuration configuration, @Nullable OrderRequest order, @NotNull Continuation<? super CheckoutSessionResult> $completion) {
        return new CheckoutSessionInitializer(sessionModel, configuration, order).setupSession(null, $completion);
    }

    public static /* synthetic */ Object createSession$default(CheckoutSessionProvider checkoutSessionProvider, SessionModel sessionModel, Configuration configuration, OrderRequest orderRequest, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            orderRequest = null;
        }
        return checkoutSessionProvider.createSession(sessionModel, configuration, orderRequest, (Continuation<? super CheckoutSessionResult>)continuation);
    }

    @Nullable
    public final Object createSession(@NotNull SessionPaymentResult sessionPaymentResult, @NotNull Configuration configuration, @NotNull Continuation<? super CheckoutSessionResult> $completion) {
        OrderRequest orderRequest;
        if (sessionPaymentResult.getSessionId() == null) {
            throw new CheckoutException("sessionId must not be null to create a session.", null, 2, null);
        }
        SessionModel sessionModel = new SessionModel(sessionPaymentResult.getSessionId(), sessionPaymentResult.getSessionData());
        OrderResponse orderResponse = sessionPaymentResult.getOrder();
        if (orderResponse != null) {
            OrderResponse orderResponse2 = orderResponse;
            boolean bl = false;
            orderRequest = new OrderRequest(orderResponse2.getPspReference(), orderResponse2.getOrderData());
        } else {
            orderRequest = null;
        }
        OrderRequest order = orderRequest;
        OrderResponse orderResponse3 = sessionPaymentResult.getOrder();
        return new CheckoutSessionInitializer(sessionModel, configuration, order).setupSession((Amount)(orderResponse3 != null ? orderResponse3.getRemainingAmount() : null), $completion);
    }
}

