/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.googlepay.internal.ui.model;

import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.CheckoutConfiguration;
import com.adyen.checkout.components.core.Configuration;
import com.adyen.checkout.components.core.PaymentMethod;
import com.adyen.checkout.components.core.internal.ui.model.CommonComponentParams;
import com.adyen.checkout.components.core.internal.ui.model.CommonComponentParamsMapper;
import com.adyen.checkout.components.core.internal.ui.model.CommonComponentParamsMapperData;
import com.adyen.checkout.components.core.internal.ui.model.DropInOverrideParams;
import com.adyen.checkout.components.core.internal.ui.model.SessionParams;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.googlepay.AllowedAuthMethods;
import com.adyen.checkout.googlepay.AllowedCardNetworks;
import com.adyen.checkout.googlepay.BillingAddressParameters;
import com.adyen.checkout.googlepay.GooglePayConfiguration;
import com.adyen.checkout.googlepay.GooglePayConfigurationKt;
import com.adyen.checkout.googlepay.MerchantInfo;
import com.adyen.checkout.googlepay.ShippingAddressParameters;
import com.adyen.checkout.googlepay.internal.ui.model.GooglePayComponentParams;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\b\u001a\u00020\tJ\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u0004\u0018\u00010\u000fH\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010 \u001a\u00020\u0007*\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParamsMapper;", "", "commonComponentParamsMapper", "Lcom/adyen/checkout/components/core/internal/ui/model/CommonComponentParamsMapper;", "(Lcom/adyen/checkout/components/core/internal/ui/model/CommonComponentParamsMapper;)V", "getAvailableCardNetworksFromApi", "", "", "paymentMethod", "Lcom/adyen/checkout/components/core/PaymentMethod;", "getGooglePayEnvironment", "", "environment", "Lcom/adyen/checkout/core/Environment;", "googlePayConfiguration", "Lcom/adyen/checkout/googlepay/GooglePayConfiguration;", "mapBrandToGooglePayNetwork", "brand", "mapToParams", "Lcom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParams;", "checkoutConfiguration", "Lcom/adyen/checkout/components/core/CheckoutConfiguration;", "deviceLocale", "Ljava/util/Locale;", "dropInOverrideParams", "Lcom/adyen/checkout/components/core/internal/ui/model/DropInOverrideParams;", "componentSessionParams", "Lcom/adyen/checkout/components/core/internal/ui/model/SessionParams;", "commonComponentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/CommonComponentParams;", "getAvailableAuthMethods", "getAvailableCardNetworks", "getPreferredGatewayMerchantId", "Companion", "googlepay_release"})
@SourceDebugExtension(value={"SMAP\nGooglePayComponentParamsMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GooglePayComponentParamsMapper.kt\ncom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParamsMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1611#2,9:146\n1863#2:155\n1864#2:174\n1620#2:175\n16#3,17:156\n1#4:173\n*S KotlinDebug\n*F\n+ 1 GooglePayComponentParamsMapper.kt\ncom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParamsMapper\n*L\n112#1:146,9\n112#1:155\n112#1:174\n112#1:175\n115#1:156,17\n112#1:173\n*E\n"})
public final class GooglePayComponentParamsMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonComponentParamsMapper commonComponentParamsMapper;
    @NotNull
    private static final Amount DEFAULT_AMOUNT = new Amount("USD", 0L);
    @NotNull
    private static final String DEFAULT_TOTAL_PRICE_STATUS = "FINAL";

    public GooglePayComponentParamsMapper(@NotNull CommonComponentParamsMapper commonComponentParamsMapper) {
        Intrinsics.checkNotNullParameter((Object)commonComponentParamsMapper, (String)"commonComponentParamsMapper");
        this.commonComponentParamsMapper = commonComponentParamsMapper;
    }

    @NotNull
    public final GooglePayComponentParams mapToParams(@NotNull CheckoutConfiguration checkoutConfiguration, @NotNull Locale deviceLocale, @Nullable DropInOverrideParams dropInOverrideParams, @Nullable SessionParams componentSessionParams, @NotNull PaymentMethod paymentMethod) {
        Intrinsics.checkNotNullParameter((Object)checkoutConfiguration, (String)"checkoutConfiguration");
        Intrinsics.checkNotNullParameter((Object)deviceLocale, (String)"deviceLocale");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        CommonComponentParamsMapperData commonComponentParamsMapperData = this.commonComponentParamsMapper.mapToParams(checkoutConfiguration, deviceLocale, dropInOverrideParams, componentSessionParams);
        GooglePayConfiguration googlePayConfiguration = GooglePayConfigurationKt.getGooglePayConfiguration(checkoutConfiguration);
        return this.mapToParams(commonComponentParamsMapperData.getCommonComponentParams(), googlePayConfiguration, paymentMethod);
    }

    private final GooglePayComponentParams mapToParams(CommonComponentParams commonComponentParams, GooglePayConfiguration googlePayConfiguration, PaymentMethod paymentMethod) {
        Amount amount = commonComponentParams.getAmount();
        if (amount == null) {
            amount = DEFAULT_AMOUNT;
        }
        Amount amount2 = amount;
        String string = this.getPreferredGatewayMerchantId(googlePayConfiguration, paymentMethod);
        List<String> list = this.getAvailableAuthMethods(googlePayConfiguration);
        List<String> list2 = this.getAvailableCardNetworks(googlePayConfiguration, paymentMethod);
        int n = this.getGooglePayEnvironment(commonComponentParams.getEnvironment(), googlePayConfiguration);
        Object object = googlePayConfiguration;
        if (object == null || (object = ((GooglePayConfiguration)object).getTotalPriceStatus()) == null) {
            object = DEFAULT_TOTAL_PRICE_STATUS;
        }
        Object object2 = object;
        GooglePayConfiguration googlePayConfiguration2 = googlePayConfiguration;
        String string2 = googlePayConfiguration2 != null ? googlePayConfiguration2.getCountryCode() : null;
        GooglePayConfiguration googlePayConfiguration3 = googlePayConfiguration;
        MerchantInfo merchantInfo = googlePayConfiguration3 != null ? googlePayConfiguration3.getMerchantInfo() : null;
        Object object3 = googlePayConfiguration;
        boolean bl = object3 != null && (object3 = ((GooglePayConfiguration)object3).isAllowPrepaidCards()) != null ? (Boolean)object3 : false;
        GooglePayConfiguration googlePayConfiguration4 = googlePayConfiguration;
        Boolean bl2 = googlePayConfiguration4 != null ? googlePayConfiguration4.isAllowCreditCards() : null;
        GooglePayConfiguration googlePayConfiguration5 = googlePayConfiguration;
        Boolean bl3 = googlePayConfiguration5 != null ? googlePayConfiguration5.isAssuranceDetailsRequired() : null;
        Object object4 = googlePayConfiguration;
        boolean bl4 = object4 != null && (object4 = ((GooglePayConfiguration)object4).isEmailRequired()) != null ? (Boolean)object4 : false;
        Object object5 = googlePayConfiguration;
        boolean bl5 = object5 != null && (object5 = ((GooglePayConfiguration)object5).isExistingPaymentMethodRequired()) != null ? (Boolean)object5 : false;
        Object object6 = googlePayConfiguration;
        boolean bl6 = object6 != null && (object6 = ((GooglePayConfiguration)object6).isShippingAddressRequired()) != null ? (Boolean)object6 : false;
        GooglePayConfiguration googlePayConfiguration6 = googlePayConfiguration;
        ShippingAddressParameters shippingAddressParameters = googlePayConfiguration6 != null ? googlePayConfiguration6.getShippingAddressParameters() : null;
        Object object7 = googlePayConfiguration;
        boolean bl7 = object7 != null && (object7 = ((GooglePayConfiguration)object7).isBillingAddressRequired()) != null ? (Boolean)object7 : false;
        GooglePayConfiguration googlePayConfiguration7 = googlePayConfiguration;
        BillingAddressParameters billingAddressParameters = googlePayConfiguration7 != null ? googlePayConfiguration7.getBillingAddressParameters() : null;
        return new GooglePayComponentParams(commonComponentParams, amount2, string, n, (String)object2, string2, merchantInfo, list, list2, bl, bl2, bl3, bl4, bl5, bl6, shippingAddressParameters, bl7, billingAddressParameters);
    }

    private final String getPreferredGatewayMerchantId(GooglePayConfiguration $this$getPreferredGatewayMerchantId, PaymentMethod paymentMethod) {
        Object object = $this$getPreferredGatewayMerchantId;
        if (object == null || (object = ((GooglePayConfiguration)object).getMerchantAccount()) == null) {
            Configuration configuration = paymentMethod.getConfiguration();
            object = configuration != null ? configuration.getGatewayMerchantId() : null;
            if (object == null) {
                throw new ComponentException("GooglePay merchantAccount not found. Update your API version or pass it manually inside your GooglePayConfiguration", null, 2, null);
            }
        }
        return object;
    }

    private final List<String> getAvailableAuthMethods(GooglePayConfiguration $this$getAvailableAuthMethods) {
        Object object = $this$getAvailableAuthMethods;
        if (object == null || (object = ((GooglePayConfiguration)object).getAllowedAuthMethods()) == null) {
            object = AllowedAuthMethods.INSTANCE.getAllAllowedAuthMethods$googlepay_release();
        }
        return object;
    }

    private final List<String> getAvailableCardNetworks(GooglePayConfiguration $this$getAvailableCardNetworks, PaymentMethod paymentMethod) {
        Object object = $this$getAvailableCardNetworks;
        if ((object == null || (object = ((GooglePayConfiguration)object).getAllowedCardNetworks()) == null) && (object = this.getAvailableCardNetworksFromApi(paymentMethod)) == null) {
            object = AllowedCardNetworks.INSTANCE.getAllAllowedCardNetworks$googlepay_release();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAvailableCardNetworksFromApi(PaymentMethod paymentMethod) {
        void $this$mapNotNullTo$iv$iv;
        List list = paymentMethod.getBrands();
        if (list == null) {
            return null;
        }
        List brands = list;
        Iterable $this$mapNotNull$iv = brands;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String brand = (String)element$iv$iv;
            boolean bl2 = false;
            String network = this.mapBrandToGooglePayNetwork(brand);
            if (network == null) {
                GooglePayComponentParamsMapper googlePayComponentParamsMapper = this;
                AdyenLogLevel level$iv = AdyenLogLevel.ERROR;
                Throwable throwable$iv = null;
                boolean $i$f$adyenLog = false;
                if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                    String tag$iv;
                    void $this$adyenLog_u24default$iv;
                    String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                    Intrinsics.checkNotNull((Object)fullClassName$iv);
                    String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                    String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                    AdyenLogLevel adyenLogLevel = level$iv;
                    AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                    boolean bl3 = false;
                    String string2 = "skipping brand " + brand + ", as it is not an allowed card network.";
                    adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
                }
            }
            if (network == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String mapBrandToGooglePayNetwork(String brand) {
        String string;
        if (Intrinsics.areEqual((Object)brand, (Object)"mc")) {
            string = "MASTERCARD";
        } else {
            List<String> list = AllowedCardNetworks.INSTANCE.getAllAllowedCardNetworks$googlepay_release();
            String string2 = brand.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            if (list.contains(string2)) {
                String string3 = brand.toUpperCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            } else {
                string = null;
            }
        }
        return string;
    }

    private final int getGooglePayEnvironment(Environment environment, GooglePayConfiguration googlePayConfiguration) {
        GooglePayConfiguration googlePayConfiguration2 = googlePayConfiguration;
        return (googlePayConfiguration2 != null ? googlePayConfiguration2.getGooglePayEnvironment() : null) != null ? googlePayConfiguration.getGooglePayEnvironment() : (Intrinsics.areEqual((Object)environment, (Object)Environment.TEST) ? 3 : 1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParamsMapper$Companion;", "", "()V", "DEFAULT_AMOUNT", "Lcom/adyen/checkout/components/core/Amount;", "DEFAULT_TOTAL_PRICE_STATUS", "", "googlepay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

