/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.googlepay.internal.ui;

import android.app.Activity;
import android.content.Intent;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.LifecycleOwner;
import com.adyen.checkout.components.core.OrderRequest;
import com.adyen.checkout.components.core.PaymentComponentData;
import com.adyen.checkout.components.core.PaymentMethod;
import com.adyen.checkout.components.core.internal.PaymentComponentEvent;
import com.adyen.checkout.components.core.internal.PaymentObserverRepository;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsEvent;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsManager;
import com.adyen.checkout.components.core.internal.analytics.ErrorEvent;
import com.adyen.checkout.components.core.internal.analytics.GenericEvents;
import com.adyen.checkout.components.core.internal.util.ChannelExtensionsKt;
import com.adyen.checkout.components.core.paymentmethod.GooglePayPaymentMethod;
import com.adyen.checkout.components.core.paymentmethod.PaymentMethodDetails;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.core.internal.data.model.ModelUtils;
import com.adyen.checkout.googlepay.GooglePayButtonParameters;
import com.adyen.checkout.googlepay.GooglePayComponentState;
import com.adyen.checkout.googlepay.internal.data.model.GooglePayPaymentMethodModel;
import com.adyen.checkout.googlepay.internal.ui.GooglePayDelegate;
import com.adyen.checkout.googlepay.internal.ui.model.GooglePayComponentParams;
import com.adyen.checkout.googlepay.internal.util.GooglePayUtils;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wallet.AutoResolveHelper;
import com.google.android.gms.wallet.PaymentData;
import com.google.android.gms.wallet.PaymentDataRequest;
import com.google.android.gms.wallet.PaymentsClient;
import com.google.android.gms.wallet.Wallet;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u001e\u001a\u00020\u000f2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016J\u001a\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0010\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020&2\u0006\u0010,\u001a\u00020-H\u0002J2\u0010/\u001a\u00020&2\u0006\u00100\u001a\u0002012\u0006\u0010,\u001a\u00020-2\u0018\u00102\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f04\u0012\u0004\u0012\u00020&03H\u0016J\b\u00105\u001a\u00020&H\u0016J\u0010\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020\u000fH\u0002J\b\u00108\u001a\u00020&H\u0016J\u0018\u00109\u001a\u00020&2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020(H\u0016J\b\u0010=\u001a\u00020&H\u0002J\u0017\u0010>\u001a\u00020&2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0001\u00a2\u0006\u0002\b?R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015\u00a8\u0006@"}, d2={"Lcom/adyen/checkout/googlepay/internal/ui/DefaultGooglePayDelegate;", "Lcom/adyen/checkout/googlepay/internal/ui/GooglePayDelegate;", "observerRepository", "Lcom/adyen/checkout/components/core/internal/PaymentObserverRepository;", "paymentMethod", "Lcom/adyen/checkout/components/core/PaymentMethod;", "order", "Lcom/adyen/checkout/components/core/OrderRequest;", "componentParams", "Lcom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParams;", "analyticsManager", "Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManager;", "(Lcom/adyen/checkout/components/core/internal/PaymentObserverRepository;Lcom/adyen/checkout/components/core/PaymentMethod;Lcom/adyen/checkout/components/core/OrderRequest;Lcom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParams;Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManager;)V", "_componentStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/adyen/checkout/googlepay/GooglePayComponentState;", "getComponentParams", "()Lcom/adyen/checkout/googlepay/internal/ui/model/GooglePayComponentParams;", "componentStateFlow", "Lkotlinx/coroutines/flow/Flow;", "getComponentStateFlow", "()Lkotlinx/coroutines/flow/Flow;", "exceptionChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/adyen/checkout/core/exception/CheckoutException;", "exceptionFlow", "getExceptionFlow", "submitChannel", "submitFlow", "getSubmitFlow", "createComponentState", "paymentData", "Lcom/google/android/gms/wallet/PaymentData;", "getGooglePayButtonParameters", "Lcom/adyen/checkout/googlepay/GooglePayButtonParameters;", "getPaymentMethodType", "", "handleActivityResult", "", "resultCode", "", "data", "Landroid/content/Intent;", "initialize", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "initializeAnalytics", "observe", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "callback", "Lkotlin/Function1;", "Lcom/adyen/checkout/components/core/internal/PaymentComponentEvent;", "onCleared", "onState", "state", "removeObserver", "startGooglePayScreen", "activity", "Landroid/app/Activity;", "requestCode", "trackThirdPartyErrorEvent", "updateComponentState", "updateComponentState$googlepay_release", "googlepay_release"})
@SourceDebugExtension(value={"SMAP\nDefaultGooglePayDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultGooglePayDelegate.kt\ncom/adyen/checkout/googlepay/internal/ui/DefaultGooglePayDelegate\n+ 2 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n16#2,17:204\n16#2,17:221\n16#2,17:238\n16#2,17:255\n1#3:272\n*S KotlinDebug\n*F\n+ 1 DefaultGooglePayDelegate.kt\ncom/adyen/checkout/googlepay/internal/ui/DefaultGooglePayDelegate\n*L\n73#1:204,17\n110#1:221,17\n140#1:238,17\n149#1:255,17\n*E\n"})
public final class DefaultGooglePayDelegate
implements GooglePayDelegate {
    @NotNull
    private final PaymentObserverRepository observerRepository;
    @NotNull
    private final PaymentMethod paymentMethod;
    @Nullable
    private final OrderRequest order;
    @NotNull
    private final GooglePayComponentParams componentParams;
    @NotNull
    private final AnalyticsManager analyticsManager;
    @NotNull
    private final MutableStateFlow<GooglePayComponentState> _componentStateFlow;
    @NotNull
    private final Flow<GooglePayComponentState> componentStateFlow;
    @NotNull
    private final Channel<CheckoutException> exceptionChannel;
    @NotNull
    private final Flow<CheckoutException> exceptionFlow;
    @NotNull
    private final Channel<GooglePayComponentState> submitChannel;
    @NotNull
    private final Flow<GooglePayComponentState> submitFlow;

    public DefaultGooglePayDelegate(@NotNull PaymentObserverRepository observerRepository, @NotNull PaymentMethod paymentMethod, @Nullable OrderRequest order, @NotNull GooglePayComponentParams componentParams, @NotNull AnalyticsManager analyticsManager) {
        Intrinsics.checkNotNullParameter((Object)observerRepository, (String)"observerRepository");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)analyticsManager, (String)"analyticsManager");
        this.observerRepository = observerRepository;
        this.paymentMethod = paymentMethod;
        this.order = order;
        this.componentParams = componentParams;
        this.analyticsManager = analyticsManager;
        this._componentStateFlow = StateFlowKt.MutableStateFlow((Object)DefaultGooglePayDelegate.createComponentState$default(this, null, 1, null));
        this.componentStateFlow = (Flow)this._componentStateFlow;
        this.exceptionChannel = ChannelExtensionsKt.bufferedChannel();
        this.exceptionFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.exceptionChannel));
        this.submitChannel = ChannelExtensionsKt.bufferedChannel();
        this.submitFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.submitChannel));
    }

    @NotNull
    public GooglePayComponentParams getComponentParams() {
        return this.componentParams;
    }

    @Override
    @NotNull
    public Flow<GooglePayComponentState> getComponentStateFlow() {
        return this.componentStateFlow;
    }

    @Override
    @NotNull
    public Flow<CheckoutException> getExceptionFlow() {
        return this.exceptionFlow;
    }

    @NotNull
    public Flow<GooglePayComponentState> getSubmitFlow() {
        return this.submitFlow;
    }

    public void initialize(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.initializeAnalytics(coroutineScope);
        FlowKt.launchIn((Flow)FlowKt.onEach(this.getComponentStateFlow(), (Function2)((Function2)new Function2<GooglePayComponentState, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ DefaultGooglePayDelegate this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        GooglePayComponentState it = (GooglePayComponentState)this.L$0;
                        DefaultGooglePayDelegate.access$onState(this.this$0, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull GooglePayComponentState p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeAnalytics(CoroutineScope coroutineScope) {
        DefaultGooglePayDelegate defaultGooglePayDelegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.VERBOSE;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string2 = "initializeAnalytics";
            adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
        }
        this.analyticsManager.initialize((Object)this, coroutineScope);
        String string = this.paymentMethod.getType();
        if (string == null) {
            string = "";
        }
        AnalyticsEvent.Info event = GenericEvents.rendered$default((GenericEvents)GenericEvents.INSTANCE, (String)string, null, null, null, (int)14, null);
        this.analyticsManager.trackEvent((AnalyticsEvent)event);
    }

    private final void onState(GooglePayComponentState state) {
        if (state.isValid()) {
            String string = this.paymentMethod.getType();
            if (string == null) {
                string = "";
            }
            AnalyticsEvent.Log event = GenericEvents.INSTANCE.submit(string);
            this.analyticsManager.trackEvent((AnalyticsEvent)event);
            this.submitChannel.trySend-JP2dKIU((Object)state);
        }
    }

    public void observe(@NotNull LifecycleOwner lifecycleOwner, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super PaymentComponentEvent<GooglePayComponentState>, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.observerRepository.addObservers(this.getComponentStateFlow(), this.getExceptionFlow(), this.getSubmitFlow(), lifecycleOwner, coroutineScope, callback);
    }

    public void removeObserver() {
        this.observerRepository.removeObservers();
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void updateComponentState$googlepay_release(@Nullable PaymentData paymentData) {
        DefaultGooglePayDelegate defaultGooglePayDelegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.VERBOSE;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string2 = "updateComponentState";
            adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
        }
        GooglePayComponentState componentState = this.createComponentState(paymentData);
        this._componentStateFlow.tryEmit((Object)componentState);
    }

    private final GooglePayComponentState createComponentState(PaymentData paymentData) {
        boolean bl;
        PaymentData paymentData2 = paymentData;
        if (paymentData2 != null) {
            PaymentData it = paymentData2;
            boolean bl2 = false;
            bl = ((CharSequence)GooglePayUtils.INSTANCE.findToken(it)).length() > 0;
        } else {
            bl = false;
        }
        boolean isValid = bl;
        GooglePayPaymentMethod paymentMethod = GooglePayUtils.INSTANCE.createGooglePayPaymentMethod(paymentData, this.paymentMethod.getType(), this.analyticsManager.getCheckoutAttemptId());
        PaymentComponentData paymentComponentData = new PaymentComponentData((PaymentMethodDetails)paymentMethod, this.order, this.getComponentParams().getAmount(), null, null, null, null, null, null, null, null, null, null, null, 16376, null);
        return new GooglePayComponentState((PaymentComponentData<GooglePayPaymentMethod>)paymentComponentData, isValid, true, paymentData);
    }

    static /* synthetic */ GooglePayComponentState createComponentState$default(DefaultGooglePayDelegate defaultGooglePayDelegate, PaymentData paymentData, int n, Object object) {
        if ((n & 1) != 0) {
            paymentData = null;
        }
        return defaultGooglePayDelegate.createComponentState(paymentData);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startGooglePayScreen(@NotNull Activity activity, int requestCode) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        DefaultGooglePayDelegate defaultGooglePayDelegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string2 = "startGooglePayScreen";
            adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
        }
        PaymentsClient paymentsClient = Wallet.getPaymentsClient((Activity)activity, (Wallet.WalletOptions)GooglePayUtils.INSTANCE.createWalletOptions(this.getComponentParams()));
        Intrinsics.checkNotNullExpressionValue((Object)paymentsClient, (String)"getPaymentsClient(...)");
        PaymentsClient paymentsClient2 = paymentsClient;
        PaymentDataRequest paymentDataRequest = GooglePayUtils.INSTANCE.createPaymentDataRequest(this.getComponentParams());
        AutoResolveHelper.resolveTask((Task)paymentsClient2.loadPaymentData(paymentDataRequest), (Activity)activity, (int)requestCode);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleActivityResult(int resultCode, @Nullable Intent data) {
        DefaultGooglePayDelegate defaultGooglePayDelegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string2 = "handleActivityResult";
            adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
        }
        switch (resultCode) {
            case -1: {
                if (data == null) {
                    this.trackThirdPartyErrorEvent();
                    this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("Result data is null", null, 2, null));
                    return;
                }
                PaymentData paymentData = PaymentData.getFromIntent((Intent)data);
                this.updateComponentState$googlepay_release(paymentData);
                break;
            }
            case 0: {
                this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("Payment canceled.", null, 2, null));
                break;
            }
            case 1: {
                Object object;
                Object object2;
                Status status;
                this.trackThirdPartyErrorEvent();
                Status status2 = status = AutoResolveHelper.getStatusFromIntent((Intent)data);
                if (status2 != null) {
                    Status it = status2;
                    boolean bl = false;
                    object2 = ": " + it.getStatusMessage();
                } else {
                    object2 = object = null;
                }
                if (object2 == null) {
                    object = "";
                }
                String statusMessage = object;
                this.exceptionChannel.trySend-JP2dKIU((Object)new ComponentException("GooglePay returned an error" + statusMessage, null, 2, null));
                break;
            }
        }
    }

    private final void trackThirdPartyErrorEvent() {
        AnalyticsEvent.Error event = GenericEvents.error$default((GenericEvents)GenericEvents.INSTANCE, (String)this.getPaymentMethodType(), (ErrorEvent)ErrorEvent.THIRD_PARTY, null, (int)4, null);
        this.analyticsManager.trackEvent((AnalyticsEvent)event);
    }

    @Override
    @NotNull
    public GooglePayButtonParameters getGooglePayButtonParameters() {
        List<GooglePayPaymentMethodModel> allowedPaymentMethodsList = GooglePayUtils.INSTANCE.getAllowedPaymentMethods$googlepay_release(this.getComponentParams());
        JSONArray jSONArray = ModelUtils.serializeOptList(allowedPaymentMethodsList, GooglePayPaymentMethodModel.SERIALIZER);
        String string = jSONArray != null ? jSONArray.toString() : null;
        if (string == null) {
            string = "";
        }
        String allowedPaymentMethods = string;
        return new GooglePayButtonParameters(allowedPaymentMethods);
    }

    @NotNull
    public String getPaymentMethodType() {
        String string = this.paymentMethod.getType();
        if (string == null) {
            string = "unknown";
        }
        return string;
    }

    public void onCleared() {
        this.removeObserver();
        this.analyticsManager.clear((Object)this);
    }

    public static final /* synthetic */ void access$onState(DefaultGooglePayDelegate $this, GooglePayComponentState state) {
        $this.onState(state);
    }
}

