/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.ui.view;

import android.content.Context;
import android.os.Build;
import android.text.Editable;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.util.AttributeSet;
import com.adyen.checkout.card.internal.util.CardNumberUtils;
import com.adyen.checkout.ui.core.internal.ui.view.AdyenTextInputEditText;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\nR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/adyen/checkout/card/internal/ui/view/CardNumberInput;", "Lcom/adyen/checkout/ui/core/internal/ui/view/AdyenTextInputEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "isAmexCard", "", "rawValue", "", "getRawValue", "()Ljava/lang/String;", "afterTextChanged", "", "editable", "Landroid/text/Editable;", "formatProcessedString", "unformattedString", "setAmexCardFormat", "value", "Companion", "card_release"})
public class CardNumberInput
extends AdyenTextInputEditText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isAmexCard;
    private static final int MAX_DIGIT_SEPARATOR_COUNT = 4;
    @NotNull
    private static final String DIGIT_SEPARATOR = " ";
    @NotNull
    private static final String SUPPORTED_DIGITS = "0123456789";
    @NotNull
    private static final List<Integer> AMEX_CARD_NUMBER_MASK;
    @NotNull
    private static final List<Integer> DEFAULT_CARD_NUMBER_MASK;

    @JvmOverloads
    public CardNumberInput(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.enforceMaxInputLength(23);
        this.setInputType(2);
        this.setKeyListener((KeyListener)DigitsKeyListener.getInstance((String)"0123456789 "));
        if (Build.VERSION.SDK_INT >= 26) {
            String[] stringArray = new String[]{"creditCardNumber"};
            this.setAutofillHints(stringArray);
        }
    }

    public /* synthetic */ CardNumberInput(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public String getRawValue() {
        return StringsKt.replace$default((String)String.valueOf(this.getText()), (String)DIGIT_SEPARATOR, (String)"", (boolean)false, (int)4, null);
    }

    public final void setAmexCardFormat(boolean value) {
        if (!this.isAmexCard && value) {
            this.isAmexCard = true;
            Editable editable = this.getEditableText();
            Intrinsics.checkNotNullExpressionValue((Object)editable, (String)"getEditableText(...)");
            this.afterTextChanged(editable);
            return;
        }
        this.isAmexCard = value;
    }

    protected void afterTextChanged(@NotNull Editable editable) {
        Intrinsics.checkNotNullParameter((Object)editable, (String)"editable");
        String initial = editable.toString();
        String processed = StringsKt.replace$default((String)initial, (String)DIGIT_SEPARATOR, (String)"", (boolean)false, (int)4, null);
        processed = this.formatProcessedString(processed);
        if (!Intrinsics.areEqual((Object)initial, (Object)processed)) {
            editable.replace(0, initial.length(), (CharSequence)processed);
        }
        super.afterTextChanged(editable);
    }

    private final String formatProcessedString(String unformattedString) {
        return CardNumberUtils.INSTANCE.formatCardNumber(unformattedString, this.isAmexCard ? AMEX_CARD_NUMBER_MASK : DEFAULT_CARD_NUMBER_MASK, DIGIT_SEPARATOR);
    }

    @JvmOverloads
    public CardNumberInput(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardNumberInput(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    static {
        Object[] objectArray = new Integer[]{4, 6, 5, 4};
        AMEX_CARD_NUMBER_MASK = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{4, 4, 4, 4, 3};
        DEFAULT_CARD_NUMBER_MASK = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/adyen/checkout/card/internal/ui/view/CardNumberInput$Companion;", "", "()V", "AMEX_CARD_NUMBER_MASK", "", "", "DEFAULT_CARD_NUMBER_MASK", "DIGIT_SEPARATOR", "", "MAX_DIGIT_SEPARATOR_COUNT", "SUPPORTED_DIGITS", "card_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

