/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.provider;

import android.app.Application;
import androidx.activity.ComponentActivity;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.AbstractSavedStateViewModelFactory;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.savedstate.SavedStateRegistryOwner;
import com.adyen.checkout.action.core.internal.DefaultActionHandlingComponent;
import com.adyen.checkout.action.core.internal.provider.GenericActionComponentProvider;
import com.adyen.checkout.action.core.internal.ui.GenericActionDelegate;
import com.adyen.checkout.card.CardComponent;
import com.adyen.checkout.card.CardComponentState;
import com.adyen.checkout.card.CardConfiguration;
import com.adyen.checkout.card.internal.data.api.BinLookupService;
import com.adyen.checkout.card.internal.data.api.DefaultDetectCardTypeRepository;
import com.adyen.checkout.card.internal.ui.CardValidationMapper;
import com.adyen.checkout.card.internal.ui.DefaultCardDelegate;
import com.adyen.checkout.card.internal.ui.StoredCardDelegate;
import com.adyen.checkout.card.internal.ui.model.CardComponentParams;
import com.adyen.checkout.card.internal.ui.model.CardComponentParamsMapper;
import com.adyen.checkout.card.internal.ui.model.InstallmentsParamsMapper;
import com.adyen.checkout.components.core.ComponentCallback;
import com.adyen.checkout.components.core.OrderRequest;
import com.adyen.checkout.components.core.PaymentMethod;
import com.adyen.checkout.components.core.StoredPaymentMethod;
import com.adyen.checkout.components.core.internal.BaseComponentCallback;
import com.adyen.checkout.components.core.internal.ComponentEventHandler;
import com.adyen.checkout.components.core.internal.Configuration;
import com.adyen.checkout.components.core.internal.DefaultComponentEventHandler;
import com.adyen.checkout.components.core.internal.PaymentComponentEvent;
import com.adyen.checkout.components.core.internal.PaymentObserverRepository;
import com.adyen.checkout.components.core.internal.data.api.AnalyticsMapper;
import com.adyen.checkout.components.core.internal.data.api.AnalyticsRepository;
import com.adyen.checkout.components.core.internal.data.api.AnalyticsRepositoryData;
import com.adyen.checkout.components.core.internal.data.api.AnalyticsService;
import com.adyen.checkout.components.core.internal.data.api.DefaultAnalyticsRepository;
import com.adyen.checkout.components.core.internal.data.api.DefaultPublicKeyRepository;
import com.adyen.checkout.components.core.internal.data.api.PublicKeyRepository;
import com.adyen.checkout.components.core.internal.data.api.PublicKeyService;
import com.adyen.checkout.components.core.internal.provider.PaymentComponentProvider;
import com.adyen.checkout.components.core.internal.provider.StoredPaymentComponentProvider;
import com.adyen.checkout.components.core.internal.ui.PaymentComponentDelegate;
import com.adyen.checkout.components.core.internal.ui.model.ComponentParams;
import com.adyen.checkout.components.core.internal.ui.model.SessionParams;
import com.adyen.checkout.components.core.internal.util.ViewModelExtKt;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.core.internal.data.api.HttpClient;
import com.adyen.checkout.core.internal.data.api.HttpClientFactory;
import com.adyen.checkout.cse.internal.BaseCardEncryptor;
import com.adyen.checkout.cse.internal.BaseGenericEncryptor;
import com.adyen.checkout.cse.internal.CardEncryptorFactory;
import com.adyen.checkout.cse.internal.GenericEncryptorFactory;
import com.adyen.checkout.sessions.core.CheckoutSession;
import com.adyen.checkout.sessions.core.SessionComponentCallback;
import com.adyen.checkout.sessions.core.internal.SessionComponentEventHandler;
import com.adyen.checkout.sessions.core.internal.SessionInteractor;
import com.adyen.checkout.sessions.core.internal.SessionSavedStateHandleContainer;
import com.adyen.checkout.sessions.core.internal.data.api.SessionRepository;
import com.adyen.checkout.sessions.core.internal.data.api.SessionService;
import com.adyen.checkout.sessions.core.internal.provider.SessionPaymentComponentProvider;
import com.adyen.checkout.sessions.core.internal.provider.SessionStoredPaymentComponentProvider;
import com.adyen.checkout.sessions.core.internal.ui.model.SessionParamsFactory;
import com.adyen.checkout.ui.core.internal.data.api.AddressRepository;
import com.adyen.checkout.ui.core.internal.data.api.AddressService;
import com.adyen.checkout.ui.core.internal.data.api.DefaultAddressRepository;
import com.adyen.checkout.ui.core.internal.ui.SubmitHandler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u00012 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u00062 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\b0\u00072 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\b0\tB+\b\u0007\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J`\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u00052\u000e\u0010$\u001a\n\u0018\u00010%j\u0004\u0018\u0001`&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J`\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\u00052\u000e\u0010$\u001a\n\u0018\u00010%j\u0004\u0018\u0001`&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016JX\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016JX\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/adyen/checkout/card/internal/provider/CardComponentProvider;", "Lcom/adyen/checkout/components/core/internal/provider/PaymentComponentProvider;", "Lcom/adyen/checkout/card/CardComponent;", "Lcom/adyen/checkout/card/CardConfiguration;", "Lcom/adyen/checkout/card/CardComponentState;", "Lcom/adyen/checkout/components/core/ComponentCallback;", "Lcom/adyen/checkout/components/core/internal/provider/StoredPaymentComponentProvider;", "Lcom/adyen/checkout/sessions/core/internal/provider/SessionPaymentComponentProvider;", "Lcom/adyen/checkout/sessions/core/SessionComponentCallback;", "Lcom/adyen/checkout/sessions/core/internal/provider/SessionStoredPaymentComponentProvider;", "overrideComponentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/ComponentParams;", "overrideSessionParams", "Lcom/adyen/checkout/components/core/internal/ui/model/SessionParams;", "analyticsRepository", "Lcom/adyen/checkout/components/core/internal/data/api/AnalyticsRepository;", "(Lcom/adyen/checkout/components/core/internal/ui/model/ComponentParams;Lcom/adyen/checkout/components/core/internal/ui/model/SessionParams;Lcom/adyen/checkout/components/core/internal/data/api/AnalyticsRepository;)V", "componentParamsMapper", "Lcom/adyen/checkout/card/internal/ui/model/CardComponentParamsMapper;", "assertSupported", "", "paymentMethod", "Lcom/adyen/checkout/components/core/PaymentMethod;", "storedPaymentMethod", "Lcom/adyen/checkout/components/core/StoredPaymentMethod;", "get", "savedStateRegistryOwner", "Landroidx/savedstate/SavedStateRegistryOwner;", "viewModelStoreOwner", "Landroidx/lifecycle/ViewModelStoreOwner;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "configuration", "application", "Landroid/app/Application;", "componentCallback", "order", "Lcom/adyen/checkout/components/core/OrderRequest;", "Lcom/adyen/checkout/components/core/Order;", "key", "", "checkoutSession", "Lcom/adyen/checkout/sessions/core/CheckoutSession;", "isPaymentMethodSupported", "", "card_release"})
public final class CardComponentProvider
implements PaymentComponentProvider<CardComponent, CardConfiguration, CardComponentState, ComponentCallback<CardComponentState>>,
StoredPaymentComponentProvider<CardComponent, CardConfiguration, CardComponentState, ComponentCallback<CardComponentState>>,
SessionPaymentComponentProvider<CardComponent, CardConfiguration, CardComponentState, SessionComponentCallback<CardComponentState>>,
SessionStoredPaymentComponentProvider<CardComponent, CardConfiguration, CardComponentState, SessionComponentCallback<CardComponentState>> {
    @Nullable
    private final AnalyticsRepository analyticsRepository;
    @NotNull
    private final CardComponentParamsMapper componentParamsMapper;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public CardComponentProvider(@Nullable ComponentParams overrideComponentParams, @Nullable SessionParams overrideSessionParams, @Nullable AnalyticsRepository analyticsRepository) {
        this.analyticsRepository = analyticsRepository;
        this.componentParamsMapper = new CardComponentParamsMapper(new InstallmentsParamsMapper(), overrideComponentParams, overrideSessionParams);
    }

    public /* synthetic */ CardComponentProvider(ComponentParams componentParams, SessionParams sessionParams, AnalyticsRepository analyticsRepository, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            componentParams = null;
        }
        if ((n & 2) != 0) {
            sessionParams = null;
        }
        if ((n & 4) != 0) {
            analyticsRepository = null;
        }
        this(componentParams, sessionParams, analyticsRepository);
    }

    @NotNull
    public CardComponent get(@NotNull SavedStateRegistryOwner savedStateRegistryOwner, @NotNull ViewModelStoreOwner viewModelStoreOwner, @NotNull LifecycleOwner lifecycleOwner, @NotNull PaymentMethod paymentMethod, @NotNull CardConfiguration configuration, @NotNull Application application, @NotNull ComponentCallback<CardComponentState> componentCallback, @Nullable OrderRequest order, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)savedStateRegistryOwner, (String)"savedStateRegistryOwner");
        Intrinsics.checkNotNullParameter((Object)viewModelStoreOwner, (String)"viewModelStoreOwner");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter(componentCallback, (String)"componentCallback");
        this.assertSupported(paymentMethod);
        AbstractSavedStateViewModelFactory factory2 = ViewModelExtKt.viewModelFactory((SavedStateRegistryOwner)savedStateRegistryOwner, null, (Function1)((Function1)new Function1<SavedStateHandle, CardComponent>(this, configuration, paymentMethod, application, order){
            final /* synthetic */ CardComponentProvider this$0;
            final /* synthetic */ CardConfiguration $configuration;
            final /* synthetic */ PaymentMethod $paymentMethod;
            final /* synthetic */ Application $application;
            final /* synthetic */ OrderRequest $order;
            {
                this.this$0 = $receiver;
                this.$configuration = $configuration;
                this.$paymentMethod = $paymentMethod;
                this.$application = $application;
                this.$order = $order;
                super(1);
            }

            @NotNull
            public final CardComponent invoke(@NotNull SavedStateHandle savedStateHandle) {
                Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
                CardComponentParams componentParams = CardComponentProvider.access$getComponentParamsMapper$p(this.this$0).mapToParamsDefault(this.$configuration, this.$paymentMethod, null);
                HttpClient httpClient = HttpClientFactory.INSTANCE.getHttpClient(componentParams.getEnvironment());
                BaseGenericEncryptor genericEncryptor = GenericEncryptorFactory.INSTANCE.provide();
                BaseCardEncryptor cardEncryptor = CardEncryptorFactory.INSTANCE.provide();
                BinLookupService binLookupService = new BinLookupService(httpClient);
                DefaultDetectCardTypeRepository detectCardTypeRepository = new DefaultDetectCardTypeRepository(cardEncryptor, binLookupService);
                PublicKeyService publicKeyService = new PublicKeyService(httpClient);
                DefaultPublicKeyRepository publicKeyRepository = new DefaultPublicKeyRepository(publicKeyService);
                AddressService addressService = new AddressService(httpClient);
                DefaultAddressRepository addressRepository = new DefaultAddressRepository(addressService);
                CardValidationMapper cardValidationMapper = new CardValidationMapper();
                AnalyticsRepository analyticsRepository = CardComponentProvider.access$getAnalyticsRepository$p(this.this$0);
                if (analyticsRepository == null) {
                    analyticsRepository = (AnalyticsRepository)new DefaultAnalyticsRepository(new AnalyticsRepositoryData(this.$application, (ComponentParams)componentParams, this.$paymentMethod, null, 8, null), new AnalyticsService(HttpClientFactory.INSTANCE.getAnalyticsHttpClient(componentParams.getEnvironment())), new AnalyticsMapper());
                }
                AnalyticsRepository analyticsRepository2 = analyticsRepository;
                DefaultCardDelegate cardDelegate = new DefaultCardDelegate(new PaymentObserverRepository(null, 1, null), (PublicKeyRepository)publicKeyRepository, componentParams, this.$paymentMethod, this.$order, analyticsRepository2, (AddressRepository)addressRepository, detectCardTypeRepository, cardValidationMapper, cardEncryptor, genericEncryptor, (SubmitHandler<CardComponentState>)new SubmitHandler(savedStateHandle));
                GenericActionDelegate genericActionDelegate = new GenericActionComponentProvider((ComponentParams)componentParams).getDelegate(this.$configuration.getGenericActionConfiguration$card_release(), savedStateHandle, this.$application);
                return new CardComponent(cardDelegate, genericActionDelegate, new DefaultActionHandlingComponent(genericActionDelegate, (PaymentComponentDelegate)cardDelegate), (ComponentEventHandler<CardComponentState>)((ComponentEventHandler)new DefaultComponentEventHandler()));
            }
        }));
        ViewModel viewModel = ViewModelExtKt.get((ViewModelProvider)new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)factory2), (String)key, CardComponent.class);
        CardComponent component = (CardComponent)viewModel;
        boolean bl = false;
        component.observe(lifecycleOwner, (Function1<? super PaymentComponentEvent<CardComponentState>, Unit>)((Function1)new Function1<PaymentComponentEvent<CardComponentState>, Unit>(component, componentCallback){
            final /* synthetic */ CardComponent $component;
            final /* synthetic */ ComponentCallback<CardComponentState> $componentCallback;
            {
                this.$component = $component;
                this.$componentCallback = $componentCallback;
                super(1);
            }

            public final void invoke(@NotNull PaymentComponentEvent<CardComponentState> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$component.getComponentEventHandler$card_release().onPaymentComponentEvent(it, (BaseComponentCallback)this.$componentCallback);
            }
        }));
        return (CardComponent)viewModel;
    }

    @NotNull
    public CardComponent get(@NotNull SavedStateRegistryOwner savedStateRegistryOwner, @NotNull ViewModelStoreOwner viewModelStoreOwner, @NotNull LifecycleOwner lifecycleOwner, @NotNull CheckoutSession checkoutSession, @NotNull PaymentMethod paymentMethod, @NotNull CardConfiguration configuration, @NotNull Application application, @NotNull SessionComponentCallback<CardComponentState> componentCallback, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)savedStateRegistryOwner, (String)"savedStateRegistryOwner");
        Intrinsics.checkNotNullParameter((Object)viewModelStoreOwner, (String)"viewModelStoreOwner");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)checkoutSession, (String)"checkoutSession");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter(componentCallback, (String)"componentCallback");
        this.assertSupported(paymentMethod);
        AbstractSavedStateViewModelFactory factory2 = ViewModelExtKt.viewModelFactory((SavedStateRegistryOwner)savedStateRegistryOwner, null, (Function1)((Function1)new Function1<SavedStateHandle, CardComponent>(this, configuration, paymentMethod, checkoutSession, application){
            final /* synthetic */ CardComponentProvider this$0;
            final /* synthetic */ CardConfiguration $configuration;
            final /* synthetic */ PaymentMethod $paymentMethod;
            final /* synthetic */ CheckoutSession $checkoutSession;
            final /* synthetic */ Application $application;
            {
                this.this$0 = $receiver;
                this.$configuration = $configuration;
                this.$paymentMethod = $paymentMethod;
                this.$checkoutSession = $checkoutSession;
                this.$application = $application;
                super(1);
            }

            @NotNull
            public final CardComponent invoke(@NotNull SavedStateHandle savedStateHandle) {
                Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
                CardComponentParams componentParams = CardComponentProvider.access$getComponentParamsMapper$p(this.this$0).mapToParamsDefault(this.$configuration, this.$paymentMethod, SessionParamsFactory.INSTANCE.create(this.$checkoutSession));
                HttpClient httpClient = HttpClientFactory.INSTANCE.getHttpClient(componentParams.getEnvironment());
                BaseGenericEncryptor genericEncryptor = GenericEncryptorFactory.INSTANCE.provide();
                BaseCardEncryptor cardEncryptor = CardEncryptorFactory.INSTANCE.provide();
                BinLookupService binLookupService = new BinLookupService(httpClient);
                DefaultDetectCardTypeRepository detectCardTypeRepository = new DefaultDetectCardTypeRepository(cardEncryptor, binLookupService);
                PublicKeyService publicKeyService = new PublicKeyService(httpClient);
                DefaultPublicKeyRepository publicKeyRepository = new DefaultPublicKeyRepository(publicKeyService);
                AddressService addressService = new AddressService(httpClient);
                DefaultAddressRepository addressRepository = new DefaultAddressRepository(addressService);
                CardValidationMapper cardValidationMapper = new CardValidationMapper();
                AnalyticsRepository analyticsRepository = CardComponentProvider.access$getAnalyticsRepository$p(this.this$0);
                if (analyticsRepository == null) {
                    analyticsRepository = (AnalyticsRepository)new DefaultAnalyticsRepository(new AnalyticsRepositoryData(this.$application, (ComponentParams)componentParams, this.$paymentMethod, this.$checkoutSession.getSessionSetupResponse().getId()), new AnalyticsService(HttpClientFactory.INSTANCE.getAnalyticsHttpClient(componentParams.getEnvironment())), new AnalyticsMapper());
                }
                AnalyticsRepository analyticsRepository2 = analyticsRepository;
                DefaultCardDelegate cardDelegate = new DefaultCardDelegate(new PaymentObserverRepository(null, 1, null), (PublicKeyRepository)publicKeyRepository, componentParams, this.$paymentMethod, this.$checkoutSession.getOrder(), analyticsRepository2, (AddressRepository)addressRepository, detectCardTypeRepository, cardValidationMapper, cardEncryptor, genericEncryptor, (SubmitHandler<CardComponentState>)new SubmitHandler(savedStateHandle));
                GenericActionDelegate genericActionDelegate = new GenericActionComponentProvider((ComponentParams)componentParams).getDelegate(this.$configuration.getGenericActionConfiguration$card_release(), savedStateHandle, this.$application);
                SessionSavedStateHandleContainer sessionSavedStateHandleContainer = new SessionSavedStateHandleContainer(savedStateHandle, this.$checkoutSession);
                Boolean bl = sessionSavedStateHandleContainer.isFlowTakenOver();
                SessionInteractor sessionInteractor = new SessionInteractor(new SessionRepository(new SessionService(httpClient), componentParams.getClientKey()), sessionSavedStateHandleContainer.getSessionModel(), bl != null ? bl : false);
                SessionComponentEventHandler sessionComponentEventHandler = new SessionComponentEventHandler(sessionInteractor, sessionSavedStateHandleContainer);
                return new CardComponent(cardDelegate, genericActionDelegate, new DefaultActionHandlingComponent(genericActionDelegate, (PaymentComponentDelegate)cardDelegate), (ComponentEventHandler<CardComponentState>)((ComponentEventHandler)sessionComponentEventHandler));
            }
        }));
        ViewModel viewModel = ViewModelExtKt.get((ViewModelProvider)new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)factory2), (String)key, CardComponent.class);
        CardComponent component = (CardComponent)viewModel;
        boolean bl = false;
        component.observe(lifecycleOwner, (Function1<? super PaymentComponentEvent<CardComponentState>, Unit>)((Function1)new Function1<PaymentComponentEvent<CardComponentState>, Unit>(component, componentCallback){
            final /* synthetic */ CardComponent $component;
            final /* synthetic */ SessionComponentCallback<CardComponentState> $componentCallback;
            {
                this.$component = $component;
                this.$componentCallback = $componentCallback;
                super(1);
            }

            public final void invoke(@NotNull PaymentComponentEvent<CardComponentState> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$component.getComponentEventHandler$card_release().onPaymentComponentEvent(it, (BaseComponentCallback)this.$componentCallback);
            }
        }));
        return (CardComponent)viewModel;
    }

    @NotNull
    public CardComponent get(@NotNull SavedStateRegistryOwner savedStateRegistryOwner, @NotNull ViewModelStoreOwner viewModelStoreOwner, @NotNull LifecycleOwner lifecycleOwner, @NotNull StoredPaymentMethod storedPaymentMethod, @NotNull CardConfiguration configuration, @NotNull Application application, @NotNull ComponentCallback<CardComponentState> componentCallback, @Nullable OrderRequest order, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)savedStateRegistryOwner, (String)"savedStateRegistryOwner");
        Intrinsics.checkNotNullParameter((Object)viewModelStoreOwner, (String)"viewModelStoreOwner");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)storedPaymentMethod, (String)"storedPaymentMethod");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter(componentCallback, (String)"componentCallback");
        this.assertSupported(storedPaymentMethod);
        AbstractSavedStateViewModelFactory factory2 = ViewModelExtKt.viewModelFactory((SavedStateRegistryOwner)savedStateRegistryOwner, null, (Function1)((Function1)new Function1<SavedStateHandle, CardComponent>(this, configuration, application, storedPaymentMethod, order){
            final /* synthetic */ CardComponentProvider this$0;
            final /* synthetic */ CardConfiguration $configuration;
            final /* synthetic */ Application $application;
            final /* synthetic */ StoredPaymentMethod $storedPaymentMethod;
            final /* synthetic */ OrderRequest $order;
            {
                this.this$0 = $receiver;
                this.$configuration = $configuration;
                this.$application = $application;
                this.$storedPaymentMethod = $storedPaymentMethod;
                this.$order = $order;
                super(1);
            }

            @NotNull
            public final CardComponent invoke(@NotNull SavedStateHandle savedStateHandle) {
                Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
                CardComponentParams componentParams = CardComponentProvider.access$getComponentParamsMapper$p(this.this$0).mapToParamsStored(this.$configuration, null);
                HttpClient httpClient = HttpClientFactory.INSTANCE.getHttpClient(componentParams.getEnvironment());
                PublicKeyService publicKeyService = new PublicKeyService(httpClient);
                DefaultPublicKeyRepository publicKeyRepository = new DefaultPublicKeyRepository(publicKeyService);
                BaseCardEncryptor cardEncryptor = CardEncryptorFactory.INSTANCE.provide();
                AnalyticsRepository analyticsRepository = CardComponentProvider.access$getAnalyticsRepository$p(this.this$0);
                if (analyticsRepository == null) {
                    analyticsRepository = (AnalyticsRepository)new DefaultAnalyticsRepository(new AnalyticsRepositoryData(this.$application, (ComponentParams)componentParams, this.$storedPaymentMethod, null, 8, null), new AnalyticsService(HttpClientFactory.INSTANCE.getAnalyticsHttpClient(componentParams.getEnvironment())), new AnalyticsMapper());
                }
                AnalyticsRepository analyticsRepository2 = analyticsRepository;
                StoredCardDelegate cardDelegate = new StoredCardDelegate(new PaymentObserverRepository(null, 1, null), this.$storedPaymentMethod, this.$order, componentParams, analyticsRepository2, cardEncryptor, (PublicKeyRepository)publicKeyRepository, (SubmitHandler<CardComponentState>)new SubmitHandler(savedStateHandle));
                GenericActionDelegate genericActionDelegate = new GenericActionComponentProvider((ComponentParams)componentParams).getDelegate(this.$configuration.getGenericActionConfiguration$card_release(), savedStateHandle, this.$application);
                return new CardComponent(cardDelegate, genericActionDelegate, new DefaultActionHandlingComponent(genericActionDelegate, (PaymentComponentDelegate)cardDelegate), (ComponentEventHandler<CardComponentState>)((ComponentEventHandler)new DefaultComponentEventHandler()));
            }
        }));
        ViewModel viewModel = ViewModelExtKt.get((ViewModelProvider)new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)factory2), (String)key, CardComponent.class);
        CardComponent component = (CardComponent)viewModel;
        boolean bl = false;
        component.observe(lifecycleOwner, (Function1<? super PaymentComponentEvent<CardComponentState>, Unit>)((Function1)new Function1<PaymentComponentEvent<CardComponentState>, Unit>(component, componentCallback){
            final /* synthetic */ CardComponent $component;
            final /* synthetic */ ComponentCallback<CardComponentState> $componentCallback;
            {
                this.$component = $component;
                this.$componentCallback = $componentCallback;
                super(1);
            }

            public final void invoke(@NotNull PaymentComponentEvent<CardComponentState> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$component.getComponentEventHandler$card_release().onPaymentComponentEvent(it, (BaseComponentCallback)this.$componentCallback);
            }
        }));
        return (CardComponent)viewModel;
    }

    @NotNull
    public CardComponent get(@NotNull SavedStateRegistryOwner savedStateRegistryOwner, @NotNull ViewModelStoreOwner viewModelStoreOwner, @NotNull LifecycleOwner lifecycleOwner, @NotNull CheckoutSession checkoutSession, @NotNull StoredPaymentMethod storedPaymentMethod, @NotNull CardConfiguration configuration, @NotNull Application application, @NotNull SessionComponentCallback<CardComponentState> componentCallback, @Nullable String key) {
        Intrinsics.checkNotNullParameter((Object)savedStateRegistryOwner, (String)"savedStateRegistryOwner");
        Intrinsics.checkNotNullParameter((Object)viewModelStoreOwner, (String)"viewModelStoreOwner");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)checkoutSession, (String)"checkoutSession");
        Intrinsics.checkNotNullParameter((Object)storedPaymentMethod, (String)"storedPaymentMethod");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter(componentCallback, (String)"componentCallback");
        this.assertSupported(storedPaymentMethod);
        AbstractSavedStateViewModelFactory factory2 = ViewModelExtKt.viewModelFactory((SavedStateRegistryOwner)savedStateRegistryOwner, null, (Function1)((Function1)new Function1<SavedStateHandle, CardComponent>(this, configuration, checkoutSession, application, storedPaymentMethod){
            final /* synthetic */ CardComponentProvider this$0;
            final /* synthetic */ CardConfiguration $configuration;
            final /* synthetic */ CheckoutSession $checkoutSession;
            final /* synthetic */ Application $application;
            final /* synthetic */ StoredPaymentMethod $storedPaymentMethod;
            {
                this.this$0 = $receiver;
                this.$configuration = $configuration;
                this.$checkoutSession = $checkoutSession;
                this.$application = $application;
                this.$storedPaymentMethod = $storedPaymentMethod;
                super(1);
            }

            @NotNull
            public final CardComponent invoke(@NotNull SavedStateHandle savedStateHandle) {
                Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
                CardComponentParams componentParams = CardComponentProvider.access$getComponentParamsMapper$p(this.this$0).mapToParamsStored(this.$configuration, SessionParamsFactory.INSTANCE.create(this.$checkoutSession));
                HttpClient httpClient = HttpClientFactory.INSTANCE.getHttpClient(componentParams.getEnvironment());
                PublicKeyService publicKeyService = new PublicKeyService(httpClient);
                DefaultPublicKeyRepository publicKeyRepository = new DefaultPublicKeyRepository(publicKeyService);
                BaseCardEncryptor cardEncryptor = CardEncryptorFactory.INSTANCE.provide();
                AnalyticsRepository analyticsRepository = CardComponentProvider.access$getAnalyticsRepository$p(this.this$0);
                if (analyticsRepository == null) {
                    analyticsRepository = (AnalyticsRepository)new DefaultAnalyticsRepository(new AnalyticsRepositoryData(this.$application, (ComponentParams)componentParams, this.$storedPaymentMethod, this.$checkoutSession.getSessionSetupResponse().getId()), new AnalyticsService(HttpClientFactory.INSTANCE.getAnalyticsHttpClient(componentParams.getEnvironment())), new AnalyticsMapper());
                }
                AnalyticsRepository analyticsRepository2 = analyticsRepository;
                StoredCardDelegate cardDelegate = new StoredCardDelegate(new PaymentObserverRepository(null, 1, null), this.$storedPaymentMethod, this.$checkoutSession.getOrder(), componentParams, analyticsRepository2, cardEncryptor, (PublicKeyRepository)publicKeyRepository, (SubmitHandler<CardComponentState>)new SubmitHandler(savedStateHandle));
                GenericActionDelegate genericActionDelegate = new GenericActionComponentProvider((ComponentParams)componentParams).getDelegate(this.$configuration.getGenericActionConfiguration$card_release(), savedStateHandle, this.$application);
                SessionSavedStateHandleContainer sessionSavedStateHandleContainer = new SessionSavedStateHandleContainer(savedStateHandle, this.$checkoutSession);
                Boolean bl = sessionSavedStateHandleContainer.isFlowTakenOver();
                SessionInteractor sessionInteractor = new SessionInteractor(new SessionRepository(new SessionService(httpClient), componentParams.getClientKey()), sessionSavedStateHandleContainer.getSessionModel(), bl != null ? bl : false);
                SessionComponentEventHandler sessionComponentEventHandler = new SessionComponentEventHandler(sessionInteractor, sessionSavedStateHandleContainer);
                return new CardComponent(cardDelegate, genericActionDelegate, new DefaultActionHandlingComponent(genericActionDelegate, (PaymentComponentDelegate)cardDelegate), (ComponentEventHandler<CardComponentState>)((ComponentEventHandler)sessionComponentEventHandler));
            }
        }));
        ViewModel viewModel = ViewModelExtKt.get((ViewModelProvider)new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)factory2), (String)key, CardComponent.class);
        CardComponent component = (CardComponent)viewModel;
        boolean bl = false;
        component.observe(lifecycleOwner, (Function1<? super PaymentComponentEvent<CardComponentState>, Unit>)((Function1)new Function1<PaymentComponentEvent<CardComponentState>, Unit>(component, componentCallback){
            final /* synthetic */ CardComponent $component;
            final /* synthetic */ SessionComponentCallback<CardComponentState> $componentCallback;
            {
                this.$component = $component;
                this.$componentCallback = $componentCallback;
                super(1);
            }

            public final void invoke(@NotNull PaymentComponentEvent<CardComponentState> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$component.getComponentEventHandler$card_release().onPaymentComponentEvent(it, (BaseComponentCallback)this.$componentCallback);
            }
        }));
        return (CardComponent)viewModel;
    }

    private final void assertSupported(PaymentMethod paymentMethod) {
        if (!this.isPaymentMethodSupported(paymentMethod)) {
            throw new ComponentException("Unsupported payment method " + paymentMethod.getType(), null, 2, null);
        }
    }

    private final void assertSupported(StoredPaymentMethod storedPaymentMethod) {
        if (!this.isPaymentMethodSupported(storedPaymentMethod)) {
            throw new ComponentException("Unsupported payment method " + storedPaymentMethod.getType(), null, 2, null);
        }
    }

    public boolean isPaymentMethodSupported(@NotNull PaymentMethod paymentMethod) {
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        return CollectionsKt.contains((Iterable)CardComponent.PAYMENT_METHOD_TYPES, (Object)paymentMethod.getType());
    }

    public boolean isPaymentMethodSupported(@NotNull StoredPaymentMethod storedPaymentMethod) {
        Intrinsics.checkNotNullParameter((Object)storedPaymentMethod, (String)"storedPaymentMethod");
        return CollectionsKt.contains((Iterable)CardComponent.PAYMENT_METHOD_TYPES, (Object)storedPaymentMethod.getType());
    }

    @NotNull
    public CardComponent get(@NotNull ComponentActivity activity, @NotNull PaymentMethod paymentMethod, @NotNull CardConfiguration configuration, @NotNull ComponentCallback<CardComponentState> callback, @Nullable OrderRequest order, @Nullable String key) {
        return (CardComponent)PaymentComponentProvider.DefaultImpls.get((PaymentComponentProvider)this, (ComponentActivity)activity, (PaymentMethod)paymentMethod, (Configuration)configuration, callback, (OrderRequest)order, (String)key);
    }

    @NotNull
    public CardComponent get(@NotNull Fragment fragment, @NotNull PaymentMethod paymentMethod, @NotNull CardConfiguration configuration, @NotNull ComponentCallback<CardComponentState> callback, @Nullable OrderRequest order, @Nullable String key) {
        return (CardComponent)PaymentComponentProvider.DefaultImpls.get((PaymentComponentProvider)this, (Fragment)fragment, (PaymentMethod)paymentMethod, (Configuration)configuration, callback, (OrderRequest)order, (String)key);
    }

    @NotNull
    public CardComponent get(@NotNull ComponentActivity activity, @NotNull StoredPaymentMethod storedPaymentMethod, @NotNull CardConfiguration configuration, @NotNull ComponentCallback<CardComponentState> callback, @Nullable OrderRequest order, @Nullable String key) {
        return (CardComponent)StoredPaymentComponentProvider.DefaultImpls.get((StoredPaymentComponentProvider)this, (ComponentActivity)activity, (StoredPaymentMethod)storedPaymentMethod, (Configuration)configuration, callback, (OrderRequest)order, (String)key);
    }

    @NotNull
    public CardComponent get(@NotNull Fragment fragment, @NotNull StoredPaymentMethod storedPaymentMethod, @NotNull CardConfiguration configuration, @NotNull ComponentCallback<CardComponentState> callback, @Nullable OrderRequest order, @Nullable String key) {
        return (CardComponent)StoredPaymentComponentProvider.DefaultImpls.get((StoredPaymentComponentProvider)this, (Fragment)fragment, (StoredPaymentMethod)storedPaymentMethod, (Configuration)configuration, callback, (OrderRequest)order, (String)key);
    }

    @NotNull
    public CardComponent get(@NotNull ComponentActivity activity, @NotNull CheckoutSession checkoutSession, @NotNull PaymentMethod paymentMethod, @NotNull CardConfiguration configuration, @NotNull SessionComponentCallback<CardComponentState> componentCallback, @Nullable String key) {
        return (CardComponent)SessionPaymentComponentProvider.DefaultImpls.get((SessionPaymentComponentProvider)this, (ComponentActivity)activity, (CheckoutSession)checkoutSession, (PaymentMethod)paymentMethod, (Configuration)configuration, componentCallback, (String)key);
    }

    @NotNull
    public CardComponent get(@NotNull Fragment fragment, @NotNull CheckoutSession checkoutSession, @NotNull PaymentMethod paymentMethod, @NotNull CardConfiguration configuration, @NotNull SessionComponentCallback<CardComponentState> componentCallback, @Nullable String key) {
        return (CardComponent)SessionPaymentComponentProvider.DefaultImpls.get((SessionPaymentComponentProvider)this, (Fragment)fragment, (CheckoutSession)checkoutSession, (PaymentMethod)paymentMethod, (Configuration)configuration, componentCallback, (String)key);
    }

    @NotNull
    public CardComponent get(@NotNull ComponentActivity activity, @NotNull CheckoutSession checkoutSession, @NotNull StoredPaymentMethod storedPaymentMethod, @NotNull CardConfiguration configuration, @NotNull SessionComponentCallback<CardComponentState> componentCallback, @Nullable String key) {
        return (CardComponent)SessionStoredPaymentComponentProvider.DefaultImpls.get((SessionStoredPaymentComponentProvider)this, (ComponentActivity)activity, (CheckoutSession)checkoutSession, (StoredPaymentMethod)storedPaymentMethod, (Configuration)configuration, componentCallback, (String)key);
    }

    @NotNull
    public CardComponent get(@NotNull Fragment fragment, @NotNull CheckoutSession checkoutSession, @NotNull StoredPaymentMethod storedPaymentMethod, @NotNull CardConfiguration configuration, @NotNull SessionComponentCallback<CardComponentState> componentCallback, @Nullable String key) {
        return (CardComponent)SessionStoredPaymentComponentProvider.DefaultImpls.get((SessionStoredPaymentComponentProvider)this, (Fragment)fragment, (CheckoutSession)checkoutSession, (StoredPaymentMethod)storedPaymentMethod, (Configuration)configuration, componentCallback, (String)key);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public CardComponentProvider() {
        this(null, null, null, 7, null);
    }

    public static final /* synthetic */ CardComponentParamsMapper access$getComponentParamsMapper$p(CardComponentProvider $this) {
        return $this.componentParamsMapper;
    }

    public static final /* synthetic */ AnalyticsRepository access$getAnalyticsRepository$p(CardComponentProvider $this) {
        return $this.analyticsRepository;
    }
}

