/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card.internal.data.api;

import androidx.annotation.RestrictTo;
import com.adyen.checkout.card.CardBrand;
import com.adyen.checkout.card.CardType;
import com.adyen.checkout.card.internal.data.api.BinLookupService;
import com.adyen.checkout.card.internal.data.api.DefaultDetectCardTypeRepository;
import com.adyen.checkout.card.internal.data.api.DetectCardTypeRepository;
import com.adyen.checkout.card.internal.data.model.BinLookupRequest;
import com.adyen.checkout.card.internal.data.model.BinLookupResponse;
import com.adyen.checkout.card.internal.data.model.BinLookupResult;
import com.adyen.checkout.card.internal.data.model.Brand;
import com.adyen.checkout.card.internal.data.model.DetectedCardType;
import com.adyen.checkout.components.core.internal.util.ChannelExtensionsKt;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.core.internal.util.Sha256;
import com.adyen.checkout.cse.internal.BaseCardEncryptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0015\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\tH\u0002JB\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\t2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0016JF\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\t2\u0006\u0010\u001b\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0082@\u00a2\u0006\u0002\u0010 JB\u0010!\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\t2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0010\u0010#\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u001e\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00172\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\tH\u0002J@\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\t2\u0006\u0010\u001b\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0082@\u00a2\u0006\u0002\u0010 J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010)\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020\rH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006-"}, d2={"Lcom/adyen/checkout/card/internal/data/api/DefaultDetectCardTypeRepository;", "Lcom/adyen/checkout/card/internal/data/api/DetectCardTypeRepository;", "cardEncryptor", "Lcom/adyen/checkout/cse/internal/BaseCardEncryptor;", "binLookupService", "Lcom/adyen/checkout/card/internal/data/api/BinLookupService;", "(Lcom/adyen/checkout/cse/internal/BaseCardEncryptor;Lcom/adyen/checkout/card/internal/data/api/BinLookupService;)V", "_detectedCardTypesFlow", "Lkotlinx/coroutines/channels/Channel;", "", "Lcom/adyen/checkout/card/internal/data/model/DetectedCardType;", "cachedBinLookup", "Ljava/util/HashMap;", "", "Lcom/adyen/checkout/card/internal/data/model/BinLookupResult;", "Lkotlin/collections/HashMap;", "detectedCardTypesFlow", "Lkotlinx/coroutines/flow/Flow;", "getDetectedCardTypesFlow", "()Lkotlinx/coroutines/flow/Flow;", "detectCardLocally", "cardNumber", "supportedCardBrands", "Lcom/adyen/checkout/card/CardBrand;", "detectCardType", "", "publicKey", "clientKey", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "type", "fetch", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fetchFromNetwork", "getFromCache", "hashBin", "localDetectedCard", "cardBrand", "makeBinLookup", "Lcom/adyen/checkout/card/internal/data/model/BinLookupResponse;", "mapResponse", "binLookupResponse", "shouldFetchReliableTypes", "", "Companion", "card_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nDefaultDetectCardTypeRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDetectCardTypeRepository.kt\ncom/adyen/checkout/card/internal/data/api/DefaultDetectCardTypeRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ResultExt.kt\ncom/adyen/checkout/core/internal/util/ResultExtKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,217:1\n1549#2:218\n1620#2,3:219\n1549#2:224\n1620#2,3:225\n1603#2,9:233\n1855#2:242\n1856#2:244\n1612#2:245\n17#3,2:222\n19#3,4:228\n1#4:232\n1#4:243\n*S KotlinDebug\n*F\n+ 1 DefaultDetectCardTypeRepository.kt\ncom/adyen/checkout/card/internal/data/api/DefaultDetectCardTypeRepository\n*L\n112#1:218\n112#1:219,3\n173#1:224\n173#1:225,3\n190#1:233,9\n190#1:242\n190#1:244\n190#1:245\n171#1:222,2\n171#1:228,4\n190#1:243\n*E\n"})
public final class DefaultDetectCardTypeRepository
implements DetectCardTypeRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseCardEncryptor cardEncryptor;
    @NotNull
    private final BinLookupService binLookupService;
    @NotNull
    private final Channel<List<DetectedCardType>> _detectedCardTypesFlow;
    @NotNull
    private final Flow<List<DetectedCardType>> detectedCardTypesFlow;
    @NotNull
    private final HashMap<String, BinLookupResult> cachedBinLookup;
    @NotNull
    private static final String TAG = LogUtil.getTag();
    @NotNull
    private static final Set<CardBrand> NO_CVC_BRANDS;
    private static final int REQUIRED_BIN_SIZE = 11;

    public DefaultDetectCardTypeRepository(@NotNull BaseCardEncryptor cardEncryptor, @NotNull BinLookupService binLookupService) {
        Intrinsics.checkNotNullParameter((Object)cardEncryptor, (String)"cardEncryptor");
        Intrinsics.checkNotNullParameter((Object)binLookupService, (String)"binLookupService");
        this.cardEncryptor = cardEncryptor;
        this.binLookupService = binLookupService;
        this._detectedCardTypesFlow = ChannelExtensionsKt.bufferedChannel();
        this.detectedCardTypesFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this._detectedCardTypesFlow));
        this.cachedBinLookup = new HashMap();
    }

    @Override
    @NotNull
    public Flow<List<DetectedCardType>> getDetectedCardTypesFlow() {
        return this.detectedCardTypesFlow;
    }

    @Override
    public void detectCardType(@NotNull String cardNumber, @Nullable String publicKey, @NotNull List<CardBrand> supportedCardBrands, @NotNull String clientKey, @NotNull CoroutineScope coroutineScope, @Nullable String type) {
        Intrinsics.checkNotNullParameter((Object)cardNumber, (String)"cardNumber");
        Intrinsics.checkNotNullParameter(supportedCardBrands, (String)"supportedCardBrands");
        Intrinsics.checkNotNullParameter((Object)clientKey, (String)"clientKey");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Logger.d((String)TAG, (String)"detectCardType");
        if (this.shouldFetchReliableTypes(cardNumber)) {
            BinLookupResult cachedResult = this.getFromCache(cardNumber);
            if (cachedResult instanceof BinLookupResult.Available) {
                Logger.d((String)TAG, (String)"Retrieving from cache.");
                this._detectedCardTypesFlow.trySend-JP2dKIU(((BinLookupResult.Available)cachedResult).getDetectedCardTypes());
                return;
            }
            if (cachedResult instanceof BinLookupResult.Loading) {
                Logger.d((String)TAG, (String)"BinLookup request is in progress.");
            } else if (cachedResult instanceof BinLookupResult.Unavailable) {
                Logger.d((String)TAG, (String)"Fetching from network.");
                this.fetchFromNetwork(cardNumber, publicKey, supportedCardBrands, clientKey, coroutineScope, type);
            }
        }
        this._detectedCardTypesFlow.trySend-JP2dKIU(this.detectCardLocally(cardNumber, supportedCardBrands));
    }

    private final void fetchFromNetwork(String cardNumber, String publicKey, List<CardBrand> supportedCardBrands, String clientKey, CoroutineScope coroutineScope, String type) {
        if (publicKey != null) {
            Logger.d((String)TAG, (String)"Launching Bin Lookup");
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, cardNumber, publicKey, supportedCardBrands, clientKey, type, null){
                int label;
                final /* synthetic */ DefaultDetectCardTypeRepository this$0;
                final /* synthetic */ String $cardNumber;
                final /* synthetic */ String $publicKey;
                final /* synthetic */ List<CardBrand> $supportedCardBrands;
                final /* synthetic */ String $clientKey;
                final /* synthetic */ String $type;
                {
                    this.this$0 = $receiver;
                    this.$cardNumber = $cardNumber;
                    this.$publicKey = $publicKey;
                    this.$supportedCardBrands = $supportedCardBrands;
                    this.$clientKey = $clientKey;
                    this.$type = $type;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            Logger.d((String)DefaultDetectCardTypeRepository.access$getTAG$cp(), (String)"Emitting new detectedCardTypes");
                            this.label = 1;
                            v0 = DefaultDetectCardTypeRepository.access$fetch(this.this$0, this.$cardNumber, this.$publicKey, this.$supportedCardBrands, this.$clientKey, this.$type, (Continuation)this);
                            if (v0 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl14
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl14:
                            // 2 sources

                            if ((var2_3 = (List)v0) == null) break;
                            var3_4 = var2_3;
                            var4_5 = this.this$0;
                            it = var3_4;
                            $i$a$-let-DefaultDetectCardTypeRepository$fetchFromNetwork$1$1 = false;
                            this.label = 2;
                            v1 = DefaultDetectCardTypeRepository.access$get_detectedCardTypesFlow$p(var4_5).send((Object)it, (Continuation)this);
                            if (v1 == var7_2) {
                                return var7_2;
                            }
                            break;
                        }
                        case 2: {
                            $i$a$-let-DefaultDetectCardTypeRepository$fetchFromNetwork$1$1 = false;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            break;
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<DetectedCardType> detectCardLocally(String cardNumber, List<CardBrand> supportedCardBrands) {
        void $this$mapTo$iv$iv;
        Logger.d((String)TAG, (String)"detectCardLocally");
        if (((CharSequence)cardNumber).length() == 0) {
            return CollectionsKt.emptyList();
        }
        List<CardBrand> estimateCardTypes = CardBrand.Companion.estimate(cardNumber);
        Iterable $this$map$iv = estimateCardTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CardBrand cardBrand = (CardBrand)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.localDetectedCard((CardBrand)it, supportedCardBrands));
        }
        return (List)destination$iv$iv;
    }

    private final DetectedCardType localDetectedCard(CardBrand cardBrand, List<CardBrand> supportedCardBrands) {
        return new DetectedCardType(cardBrand, false, true, NO_CVC_BRANDS.contains(cardBrand) ? Brand.FieldPolicy.HIDDEN : Brand.FieldPolicy.REQUIRED, Brand.FieldPolicy.REQUIRED, supportedCardBrands.contains(cardBrand), null, null, false, 256, null);
    }

    private final boolean shouldFetchReliableTypes(String cardNumber) {
        return cardNumber.length() >= 11;
    }

    private final BinLookupResult getFromCache(String cardNumber) {
        BinLookupResult binLookupResult = this.cachedBinLookup.get(this.hashBin(cardNumber));
        if (binLookupResult == null) {
            binLookupResult = BinLookupResult.Unavailable.INSTANCE;
        }
        return binLookupResult;
    }

    private final String hashBin(String cardNumber) {
        return Sha256.INSTANCE.hashString(StringsKt.take((String)cardNumber, (int)11));
    }

    /*
     * Unable to fully structure code
     */
    private final Object fetch(String var1_1, String var2_2, List<CardBrand> var3_3, String var4_4, String var5_5, Continuation<? super List<DetectedCardType>> var6_6) {
        if (!(var6_6 instanceof fetch.1)) ** GOTO lbl-1000
        var11_7 = var6_6;
        if ((var11_7.label & -2147483648) != 0) {
            var11_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var6_6){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultDetectCardTypeRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DefaultDetectCardTypeRepository.access$fetch(this.this$0, null, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                key = this.hashBin((String)cardNumber);
                ((Map)this.cachedBinLookup).put(key, BinLookupResult.Loading.INSTANCE);
                $continuation.L$0 = this;
                $continuation.L$1 = key;
                $continuation.label = 1;
                v0 = this.makeBinLookup((String)cardNumber, (String)publicKey, (List<CardBrand>)supportedCardBrands, (String)clientKey, (String)type, (Continuation<? super BinLookupResponse>)$continuation);
                if (v0 == var12_9) {
                    return var12_9;
                }
                ** GOTO lbl27
            }
            case 1: {
                key = (String)$continuation.L$1;
                this = (DefaultDetectCardTypeRepository)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                if ((binLookupResponse = (BinLookupResponse)v0) == null) {
                    this.cachedBinLookup.remove(key);
                    v1 = null;
                } else {
                    detectedCardTypes = this.mapResponse(binLookupResponse);
                    ((Map)this.cachedBinLookup).put(key, new BinLookupResult.Available(detectedCardTypes));
                    v1 = detectedCardTypes;
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object makeBinLookup(String var1_1, String var2_2, List<CardBrand> var3_3, String var4_4, String var5_5, Continuation<? super BinLookupResponse> var6_6) {
        if (!(var6_6 instanceof makeBinLookup.1)) ** GOTO lbl-1000
        var26_7 = var6_6;
        if ((var26_7.label & -2147483648) != 0) {
            var26_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var6_6){
                /* synthetic */ Object result;
                final /* synthetic */ DefaultDetectCardTypeRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DefaultDetectCardTypeRepository.access$makeBinLookup(this.this$0, null, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var27_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$runSuspendCatching$iv = this;
                $i$f$runSuspendCatching = false;
                $this$makeBinLookup_u24lambda_u242 = $this$runSuspendCatching$iv;
                $i$a$-runSuspendCatching-DefaultDetectCardTypeRepository$makeBinLookup$2 = false;
                encryptedBin = $this$makeBinLookup_u24lambda_u242.cardEncryptor.encryptBin((String)cardNumber, (String)publicKey);
                $this$map$iv = (Iterable)supportedCardBrands;
                $i$f$map = false;
                var14_18 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var19_23 = (CardBrand)item$iv$iv;
                    var20_24 = destination$iv$iv;
                    $i$a$-map-DefaultDetectCardTypeRepository$makeBinLookup$2$cardBrands$1 = false;
                    var20_24.add(it.getTxVariant());
                }
                cardBrands = (List)destination$iv$iv;
                request = new BinLookupRequest(encryptedBin, UUID.randomUUID().toString(), cardBrands, (String)type);
                $continuation.label = 1;
                v0 = $this$makeBinLookup_u24lambda_u242.binLookupService.makeBinLookup(request, (String)clientKey, (Continuation<? super BinLookupResponse>)$continuation);
                ** if (v0 != var27_9) goto lbl38
lbl37:
                // 1 sources

                return var27_9;
lbl38:
                // 1 sources

                ** GOTO lbl46
            }
            case 1: {
                $i$f$runSuspendCatching = false;
                $i$a$-runSuspendCatching-DefaultDetectCardTypeRepository$makeBinLookup$2 = false;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl46:
                    // 2 sources

                    var23_27 = Result.constructor-impl((Object)((BinLookupResponse)v0));
                }
                catch (CancellationException e$iv) {
                    throw e$iv;
                }
                catch (Throwable e$iv) {
                    var23_27 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
                }
                var7_10 = var23_27;
                v1 = Result.exceptionOrNull-impl((Object)var7_10);
                if (v1 != null) {
                    e = var8_12 = v1;
                    $i$a$-onFailure-DefaultDetectCardTypeRepository$makeBinLookup$3 = false;
                    Logger.e((String)DefaultDetectCardTypeRepository.TAG, (String)"checkCardType - Failed to do bin lookup", (Throwable)e);
                }
                return Result.isFailure-impl((Object)var7_10) != false ? null : var7_10;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final List<DetectedCardType> mapResponse(BinLookupResponse binLookupResponse) {
        void $this$mapNotNullTo$iv$iv;
        Logger.d((String)TAG, (String)"handleBinLookupResponse");
        Logger.v((String)TAG, (String)("Brands: " + binLookupResponse.getBrands()));
        List list = binLookupResponse.getBrands();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DetectedCardType detectedCardType;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Brand brandResponse = (Brand)((Object)element$iv$iv);
            boolean bl2 = false;
            if (brandResponse.getBrand() == null) {
                detectedCardType = null;
            } else {
                CardBrand cardBrand = new CardBrand(brandResponse.getBrand());
                boolean bl3 = Intrinsics.areEqual((Object)brandResponse.getEnableLuhnCheck(), (Object)true);
                String string2 = brandResponse.getCvcPolicy();
                if (string2 == null) {
                    string2 = Brand.FieldPolicy.REQUIRED.getValue();
                }
                Brand.FieldPolicy fieldPolicy = Brand.FieldPolicy.Companion.parse(string2);
                String string3 = brandResponse.getExpiryDatePolicy();
                if (string3 == null) {
                    string3 = Brand.FieldPolicy.REQUIRED.getValue();
                }
                detectedCardType = new DetectedCardType(cardBrand, true, bl3, fieldPolicy, Brand.FieldPolicy.Companion.parse(string3), !Intrinsics.areEqual((Object)brandResponse.getSupported(), (Object)false), brandResponse.getPanLength(), brandResponse.getPaymentMethodVariant(), false, 256, null);
            }
            if (detectedCardType == null) continue;
            DetectedCardType it$iv$iv = detectedCardType;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ Object access$fetch(DefaultDetectCardTypeRepository $this, String cardNumber, String publicKey, List supportedCardBrands, String clientKey, String type, Continuation $completion) {
        return $this.fetch(cardNumber, publicKey, supportedCardBrands, clientKey, type, (Continuation<? super List<DetectedCardType>>)$completion);
    }

    public static final /* synthetic */ Channel access$get_detectedCardTypesFlow$p(DefaultDetectCardTypeRepository $this) {
        return $this._detectedCardTypesFlow;
    }

    public static final /* synthetic */ Object access$makeBinLookup(DefaultDetectCardTypeRepository $this, String cardNumber, String publicKey, List supportedCardBrands, String clientKey, String type, Continuation $completion) {
        return $this.makeBinLookup(cardNumber, publicKey, supportedCardBrands, clientKey, type, (Continuation<? super BinLookupResponse>)$completion);
    }

    static {
        Object[] objectArray = new CardBrand[]{new CardBrand(CardType.BCMC)};
        NO_CVC_BRANDS = SetsKt.hashSetOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/adyen/checkout/card/internal/data/api/DefaultDetectCardTypeRepository$Companion;", "", "()V", "NO_CVC_BRANDS", "", "Lcom/adyen/checkout/card/CardBrand;", "REQUIRED_BIN_SIZE", "", "TAG", "", "card_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

