/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.card;

import android.os.Parcel;
import android.os.Parcelable;
import com.adyen.checkout.card.InstallmentOptions;
import com.adyen.checkout.card.internal.util.InstallmentUtils;
import com.adyen.checkout.core.exception.CheckoutException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B+\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J/\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0013\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0019\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/adyen/checkout/card/InstallmentConfiguration;", "Landroid/os/Parcelable;", "defaultOptions", "Lcom/adyen/checkout/card/InstallmentOptions$DefaultInstallmentOptions;", "cardBasedOptions", "", "Lcom/adyen/checkout/card/InstallmentOptions$CardBasedInstallmentOptions;", "showInstallmentAmount", "", "(Lcom/adyen/checkout/card/InstallmentOptions$DefaultInstallmentOptions;Ljava/util/List;Z)V", "getCardBasedOptions", "()Ljava/util/List;", "getDefaultOptions", "()Lcom/adyen/checkout/card/InstallmentOptions$DefaultInstallmentOptions;", "getShowInstallmentAmount", "()Z", "component1", "component2", "component3", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "card_release"})
@Parcelize
public final class InstallmentConfiguration
implements Parcelable {
    @Nullable
    private final InstallmentOptions.DefaultInstallmentOptions defaultOptions;
    @NotNull
    private final List<InstallmentOptions.CardBasedInstallmentOptions> cardBasedOptions;
    private final boolean showInstallmentAmount;
    @NotNull
    public static final Parcelable.Creator<InstallmentConfiguration> CREATOR;

    public InstallmentConfiguration(@Nullable InstallmentOptions.DefaultInstallmentOptions defaultOptions, @NotNull List<InstallmentOptions.CardBasedInstallmentOptions> cardBasedOptions, boolean showInstallmentAmount) {
        Intrinsics.checkNotNullParameter(cardBasedOptions, (String)"cardBasedOptions");
        this.defaultOptions = defaultOptions;
        this.cardBasedOptions = cardBasedOptions;
        this.showInstallmentAmount = showInstallmentAmount;
        if (!InstallmentUtils.INSTANCE.isCardBasedOptionsValid(this.cardBasedOptions)) {
            throw new CheckoutException("Installment Configuration has multiple rules for same card type.", null, 2, null);
        }
        if (!InstallmentUtils.INSTANCE.areInstallmentValuesValid(this)) {
            throw new CheckoutException("Installment Configuration contains invalid values for options. Values must be greater than 1.", null, 2, null);
        }
    }

    public /* synthetic */ InstallmentConfiguration(InstallmentOptions.DefaultInstallmentOptions defaultInstallmentOptions, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            defaultInstallmentOptions = null;
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        this(defaultInstallmentOptions, list, bl);
    }

    @Nullable
    public final InstallmentOptions.DefaultInstallmentOptions getDefaultOptions() {
        return this.defaultOptions;
    }

    @NotNull
    public final List<InstallmentOptions.CardBasedInstallmentOptions> getCardBasedOptions() {
        return this.cardBasedOptions;
    }

    public final boolean getShowInstallmentAmount() {
        return this.showInstallmentAmount;
    }

    @Nullable
    public final InstallmentOptions.DefaultInstallmentOptions component1() {
        return this.defaultOptions;
    }

    @NotNull
    public final List<InstallmentOptions.CardBasedInstallmentOptions> component2() {
        return this.cardBasedOptions;
    }

    public final boolean component3() {
        return this.showInstallmentAmount;
    }

    @NotNull
    public final InstallmentConfiguration copy(@Nullable InstallmentOptions.DefaultInstallmentOptions defaultOptions, @NotNull List<InstallmentOptions.CardBasedInstallmentOptions> cardBasedOptions, boolean showInstallmentAmount) {
        Intrinsics.checkNotNullParameter(cardBasedOptions, (String)"cardBasedOptions");
        return new InstallmentConfiguration(defaultOptions, cardBasedOptions, showInstallmentAmount);
    }

    public static /* synthetic */ InstallmentConfiguration copy$default(InstallmentConfiguration installmentConfiguration, InstallmentOptions.DefaultInstallmentOptions defaultInstallmentOptions, List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            defaultInstallmentOptions = installmentConfiguration.defaultOptions;
        }
        if ((n & 2) != 0) {
            list = installmentConfiguration.cardBasedOptions;
        }
        if ((n & 4) != 0) {
            bl = installmentConfiguration.showInstallmentAmount;
        }
        return installmentConfiguration.copy(defaultInstallmentOptions, list, bl);
    }

    @NotNull
    public String toString() {
        return "InstallmentConfiguration(defaultOptions=" + this.defaultOptions + ", cardBasedOptions=" + this.cardBasedOptions + ", showInstallmentAmount=" + this.showInstallmentAmount + ")";
    }

    public int hashCode() {
        int result = this.defaultOptions == null ? 0 : this.defaultOptions.hashCode();
        result = result * 31 + ((Object)this.cardBasedOptions).hashCode();
        result = result * 31 + Boolean.hashCode(this.showInstallmentAmount);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InstallmentConfiguration)) {
            return false;
        }
        InstallmentConfiguration installmentConfiguration = (InstallmentConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.defaultOptions, (Object)installmentConfiguration.defaultOptions)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.cardBasedOptions, installmentConfiguration.cardBasedOptions)) {
            return false;
        }
        return this.showInstallmentAmount == installmentConfiguration.showInstallmentAmount;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Object object = this.defaultOptions;
        if (object == null) {
            out.writeInt(0);
        } else {
            out.writeInt(1);
            ((InstallmentOptions.DefaultInstallmentOptions)object).writeToParcel(out, flags);
        }
        object = this.cardBasedOptions;
        out.writeInt(object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            ((InstallmentOptions.CardBasedInstallmentOptions)iterator.next()).writeToParcel(out, flags);
        }
        out.writeInt(this.showInstallmentAmount ? 1 : 0);
    }

    public InstallmentConfiguration() {
        this(null, null, false, 7, null);
    }

    static {
        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class Creator
        implements Parcelable.Creator<InstallmentConfiguration> {
            @NotNull
            public final InstallmentConfiguration[] newArray(int size) {
                return new InstallmentConfiguration[size];
            }

            @NotNull
            public final InstallmentConfiguration createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                int n = parcel.readInt();
                ArrayList<Object> arrayList = new ArrayList<Object>(n);
                InstallmentOptions.DefaultInstallmentOptions defaultInstallmentOptions = (InstallmentOptions.DefaultInstallmentOptions)(parcel.readInt() == 0 ? null : InstallmentOptions.DefaultInstallmentOptions.CREATOR.createFromParcel(parcel));
                for (int i = 0; i != n; ++i) {
                    arrayList.add(InstallmentOptions.CardBasedInstallmentOptions.CREATOR.createFromParcel(parcel));
                }
                boolean bl = parcel.readInt() != 0;
                List list = arrayList;
                InstallmentOptions.DefaultInstallmentOptions defaultInstallmentOptions2 = defaultInstallmentOptions;
                return new InstallmentConfiguration(defaultInstallmentOptions2, list, bl);
            }
        }
        CREATOR = new Creator();
    }
}

