/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.blik.internal.ui.model;

import com.adyen.checkout.blik.R;
import com.adyen.checkout.components.core.internal.ui.model.FieldState;
import com.adyen.checkout.components.core.internal.ui.model.OutputData;
import com.adyen.checkout.components.core.internal.ui.model.Validation;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/adyen/checkout/blik/internal/ui/model/BlikOutputData;", "Lcom/adyen/checkout/components/core/internal/ui/model/OutputData;", "blikCode", "", "(Ljava/lang/String;)V", "blikCodeField", "Lcom/adyen/checkout/components/core/internal/ui/model/FieldState;", "getBlikCodeField", "()Lcom/adyen/checkout/components/core/internal/ui/model/FieldState;", "isValid", "", "()Z", "getBlikCodeValidation", "Lcom/adyen/checkout/components/core/internal/ui/model/Validation;", "Companion", "blik_release"})
public final class BlikOutputData
implements OutputData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FieldState<String> blikCodeField;
    @NotNull
    private static final String TAG = LogUtil.getTag();
    private static final int BLIK_CODE_LENGTH = 6;

    public BlikOutputData(@NotNull String blikCode) {
        Intrinsics.checkNotNullParameter((Object)blikCode, (String)"blikCode");
        this.blikCodeField = new FieldState((Object)blikCode, this.getBlikCodeValidation(blikCode));
    }

    @NotNull
    public final FieldState<String> getBlikCodeField() {
        return this.blikCodeField;
    }

    public boolean isValid() {
        return this.blikCodeField.getValidation().isValid();
    }

    private final Validation getBlikCodeValidation(String blikCode) {
        try {
            if (((CharSequence)blikCode).length() > 0) {
                Integer.parseInt(blikCode);
            }
        }
        catch (NumberFormatException e) {
            Logger.e((String)TAG, (String)"Failed to parse blik code to Integer", (Throwable)e);
            return (Validation)new Validation.Invalid(R.string.checkout_blik_code_not_valid, false, 2, null);
        }
        return blikCode.length() == 6 ? (Validation)Validation.Valid.INSTANCE : (Validation)new Validation.Invalid(R.string.checkout_blik_code_not_valid, false, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/adyen/checkout/blik/internal/ui/model/BlikOutputData$Companion;", "", "()V", "BLIK_CODE_LENGTH", "", "TAG", "", "blik_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

