/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.blik.internal.ui;

import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.LifecycleOwner;
import com.adyen.checkout.blik.BlikComponentState;
import com.adyen.checkout.blik.internal.ui.BlikComponentViewType;
import com.adyen.checkout.blik.internal.ui.BlikDelegate;
import com.adyen.checkout.blik.internal.ui.model.BlikInputData;
import com.adyen.checkout.blik.internal.ui.model.BlikOutputData;
import com.adyen.checkout.components.core.OrderRequest;
import com.adyen.checkout.components.core.PaymentComponentData;
import com.adyen.checkout.components.core.PaymentComponentState;
import com.adyen.checkout.components.core.PaymentMethod;
import com.adyen.checkout.components.core.internal.PaymentComponentEvent;
import com.adyen.checkout.components.core.internal.PaymentObserverRepository;
import com.adyen.checkout.components.core.internal.data.api.AnalyticsRepository;
import com.adyen.checkout.components.core.internal.ui.model.ButtonComponentParams;
import com.adyen.checkout.components.core.paymentmethod.BlikPaymentMethod;
import com.adyen.checkout.components.core.paymentmethod.PaymentMethodDetails;
import com.adyen.checkout.core.internal.util.LogUtil;
import com.adyen.checkout.core.internal.util.Logger;
import com.adyen.checkout.ui.core.internal.ui.ButtonComponentViewType;
import com.adyen.checkout.ui.core.internal.ui.ComponentViewType;
import com.adyen.checkout.ui.core.internal.ui.PaymentComponentUIEvent;
import com.adyen.checkout.ui.core.internal.ui.PaymentComponentUIState;
import com.adyen.checkout.ui.core.internal.ui.SubmitHandler;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 K2\u00020\u0001:\u0001KB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010-\u001a\u00020\u000e2\b\b\u0002\u0010\u001e\u001a\u00020\u0013H\u0002J\b\u0010.\u001a\u00020\u0013H\u0002J\b\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016J2\u00107\u001a\u0002022\u0006\u00108\u001a\u0002092\u0006\u00103\u001a\u0002042\u0018\u0010:\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0<\u0012\u0004\u0012\u0002020;H\u0016J\b\u0010=\u001a\u000202H\u0016J\b\u0010>\u001a\u000202H\u0002J\b\u0010?\u001a\u000202H\u0016J\u0010\u0010@\u001a\u0002022\u0006\u0010\u001e\u001a\u00020\u0013H\u0002J\b\u0010A\u001a\u000202H\u0016J\u0010\u0010B\u001a\u0002022\u0006\u0010C\u001a\u000206H\u0016J\u0010\u0010D\u001a\u0002022\u0006\u00103\u001a\u000204H\u0002J\b\u0010E\u001a\u000206H\u0016J\u0015\u0010F\u001a\u0002022\u0006\u0010\u001e\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\bGJ!\u0010H\u001a\u0002022\u0017\u0010I\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002020;\u00a2\u0006\u0002\bJH\u0016R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001bR\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u001bR\u001c\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u001b\u00a8\u0006L"}, d2={"Lcom/adyen/checkout/blik/internal/ui/DefaultBlikDelegate;", "Lcom/adyen/checkout/blik/internal/ui/BlikDelegate;", "observerRepository", "Lcom/adyen/checkout/components/core/internal/PaymentObserverRepository;", "componentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/ButtonComponentParams;", "paymentMethod", "Lcom/adyen/checkout/components/core/PaymentMethod;", "order", "Lcom/adyen/checkout/components/core/OrderRequest;", "analyticsRepository", "Lcom/adyen/checkout/components/core/internal/data/api/AnalyticsRepository;", "submitHandler", "Lcom/adyen/checkout/ui/core/internal/ui/SubmitHandler;", "Lcom/adyen/checkout/blik/BlikComponentState;", "(Lcom/adyen/checkout/components/core/internal/PaymentObserverRepository;Lcom/adyen/checkout/components/core/internal/ui/model/ButtonComponentParams;Lcom/adyen/checkout/components/core/PaymentMethod;Lcom/adyen/checkout/components/core/OrderRequest;Lcom/adyen/checkout/components/core/internal/data/api/AnalyticsRepository;Lcom/adyen/checkout/ui/core/internal/ui/SubmitHandler;)V", "_componentStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "_outputDataFlow", "Lcom/adyen/checkout/blik/internal/ui/model/BlikOutputData;", "_viewFlow", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentViewType;", "getComponentParams", "()Lcom/adyen/checkout/components/core/internal/ui/model/ButtonComponentParams;", "componentStateFlow", "Lkotlinx/coroutines/flow/Flow;", "getComponentStateFlow", "()Lkotlinx/coroutines/flow/Flow;", "inputData", "Lcom/adyen/checkout/blik/internal/ui/model/BlikInputData;", "outputData", "getOutputData", "()Lcom/adyen/checkout/blik/internal/ui/model/BlikOutputData;", "outputDataFlow", "getOutputDataFlow", "submitFlow", "getSubmitFlow", "uiEventFlow", "Lcom/adyen/checkout/ui/core/internal/ui/PaymentComponentUIEvent;", "getUiEventFlow", "uiStateFlow", "Lcom/adyen/checkout/ui/core/internal/ui/PaymentComponentUIState;", "getUiStateFlow", "viewFlow", "getViewFlow", "createComponentState", "createOutputData", "getPaymentMethodType", "", "initialize", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "isConfirmationRequired", "", "observe", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "callback", "Lkotlin/Function1;", "Lcom/adyen/checkout/components/core/internal/PaymentComponentEvent;", "onCleared", "onInputDataChanged", "onSubmit", "outputDataChanged", "removeObserver", "setInteractionBlocked", "isInteractionBlocked", "setupAnalytics", "shouldShowSubmitButton", "updateComponentState", "updateComponentState$blik_release", "updateInputData", "update", "Lkotlin/ExtensionFunctionType;", "Companion", "blik_release"})
public final class DefaultBlikDelegate
implements BlikDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PaymentObserverRepository observerRepository;
    @NotNull
    private final ButtonComponentParams componentParams;
    @NotNull
    private final PaymentMethod paymentMethod;
    @Nullable
    private final OrderRequest order;
    @NotNull
    private final AnalyticsRepository analyticsRepository;
    @NotNull
    private final SubmitHandler<BlikComponentState> submitHandler;
    @NotNull
    private final BlikInputData inputData;
    @NotNull
    private final MutableStateFlow<BlikOutputData> _outputDataFlow;
    @NotNull
    private final Flow<BlikOutputData> outputDataFlow;
    @NotNull
    private final MutableStateFlow<BlikComponentState> _componentStateFlow;
    @NotNull
    private final Flow<BlikComponentState> componentStateFlow;
    @NotNull
    private final MutableStateFlow<ComponentViewType> _viewFlow;
    @NotNull
    private final Flow<ComponentViewType> viewFlow;
    @NotNull
    private final Flow<BlikComponentState> submitFlow;
    @NotNull
    private final Flow<PaymentComponentUIState> uiStateFlow;
    @NotNull
    private final Flow<PaymentComponentUIEvent> uiEventFlow;
    @NotNull
    private static final String TAG = LogUtil.getTag();

    public DefaultBlikDelegate(@NotNull PaymentObserverRepository observerRepository, @NotNull ButtonComponentParams componentParams, @NotNull PaymentMethod paymentMethod, @Nullable OrderRequest order, @NotNull AnalyticsRepository analyticsRepository, @NotNull SubmitHandler<BlikComponentState> submitHandler) {
        Intrinsics.checkNotNullParameter((Object)observerRepository, (String)"observerRepository");
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Intrinsics.checkNotNullParameter((Object)analyticsRepository, (String)"analyticsRepository");
        Intrinsics.checkNotNullParameter(submitHandler, (String)"submitHandler");
        this.observerRepository = observerRepository;
        this.componentParams = componentParams;
        this.paymentMethod = paymentMethod;
        this.order = order;
        this.analyticsRepository = analyticsRepository;
        this.submitHandler = submitHandler;
        this.inputData = new BlikInputData(null, 1, null);
        this._outputDataFlow = StateFlowKt.MutableStateFlow((Object)this.createOutputData());
        this.outputDataFlow = (Flow)this._outputDataFlow;
        this._componentStateFlow = StateFlowKt.MutableStateFlow((Object)DefaultBlikDelegate.createComponentState$default(this, null, 1, null));
        this.componentStateFlow = (Flow)this._componentStateFlow;
        this._viewFlow = StateFlowKt.MutableStateFlow((Object)BlikComponentViewType.INSTANCE);
        this.viewFlow = (Flow)this._viewFlow;
        this.submitFlow = this.submitHandler.getSubmitFlow();
        this.uiStateFlow = this.submitHandler.getUiStateFlow();
        this.uiEventFlow = this.submitHandler.getUiEventFlow();
        this.updateComponentState$blik_release(this.getOutputData());
    }

    @NotNull
    public ButtonComponentParams getComponentParams() {
        return this.componentParams;
    }

    @Override
    @NotNull
    public Flow<BlikOutputData> getOutputDataFlow() {
        return this.outputDataFlow;
    }

    @Override
    @NotNull
    public BlikOutputData getOutputData() {
        return (BlikOutputData)this._outputDataFlow.getValue();
    }

    @Override
    @NotNull
    public Flow<BlikComponentState> getComponentStateFlow() {
        return this.componentStateFlow;
    }

    @NotNull
    public Flow<ComponentViewType> getViewFlow() {
        return this.viewFlow;
    }

    @NotNull
    public Flow<BlikComponentState> getSubmitFlow() {
        return this.submitFlow;
    }

    @NotNull
    public Flow<PaymentComponentUIState> getUiStateFlow() {
        return this.uiStateFlow;
    }

    @NotNull
    public Flow<PaymentComponentUIEvent> getUiEventFlow() {
        return this.uiEventFlow;
    }

    public void initialize(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.submitHandler.initialize(coroutineScope, this.getComponentStateFlow());
        this.setupAnalytics(coroutineScope);
    }

    private final void setupAnalytics(CoroutineScope coroutineScope) {
        Logger.v((String)TAG, (String)"setupAnalytics");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultBlikDelegate this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DefaultBlikDelegate.access$getAnalyticsRepository$p(this.this$0).setupAnalytics((Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void observe(@NotNull LifecycleOwner lifecycleOwner, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super PaymentComponentEvent<BlikComponentState>, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.observerRepository.addObservers(this.getComponentStateFlow(), null, this.getSubmitFlow(), lifecycleOwner, coroutineScope, callback);
    }

    public void removeObserver() {
        this.observerRepository.removeObservers();
    }

    @NotNull
    public String getPaymentMethodType() {
        String string2 = this.paymentMethod.getType();
        if (string2 == null) {
            string2 = "unknown";
        }
        return string2;
    }

    @Override
    public void updateInputData(@NotNull Function1<? super BlikInputData, Unit> update) {
        Intrinsics.checkNotNullParameter(update, (String)"update");
        update.invoke((Object)this.inputData);
        this.onInputDataChanged();
    }

    private final void onInputDataChanged() {
        Logger.v((String)TAG, (String)"onInputDataChanged");
        BlikOutputData outputData = this.createOutputData();
        this.outputDataChanged(outputData);
        this.updateComponentState$blik_release(outputData);
    }

    private final BlikOutputData createOutputData() {
        return new BlikOutputData(this.inputData.getBlikCode());
    }

    private final void outputDataChanged(BlikOutputData outputData) {
        this._outputDataFlow.tryEmit((Object)outputData);
    }

    @VisibleForTesting
    public final void updateComponentState$blik_release(@NotNull BlikOutputData outputData) {
        Intrinsics.checkNotNullParameter((Object)outputData, (String)"outputData");
        BlikComponentState componentState = this.createComponentState(outputData);
        this._componentStateFlow.tryEmit((Object)componentState);
    }

    private final BlikComponentState createComponentState(BlikOutputData outputData) {
        BlikPaymentMethod paymentMethod = new BlikPaymentMethod("blik", this.analyticsRepository.getCheckoutAttemptId(), (String)outputData.getBlikCodeField().getValue(), null, 8, null);
        PaymentComponentData paymentComponentData = new PaymentComponentData((PaymentMethodDetails)paymentMethod, this.order, this.getComponentParams().getAmount(), null, null, null, null, null, null, null, null, null, null, 8184, null);
        return new BlikComponentState((PaymentComponentData<BlikPaymentMethod>)paymentComponentData, outputData.isValid(), true);
    }

    static /* synthetic */ BlikComponentState createComponentState$default(DefaultBlikDelegate defaultBlikDelegate, BlikOutputData blikOutputData, int n, Object object) {
        if ((n & 1) != 0) {
            blikOutputData = defaultBlikDelegate.getOutputData();
        }
        return defaultBlikDelegate.createComponentState(blikOutputData);
    }

    public void onSubmit() {
        BlikComponentState state = (BlikComponentState)this._componentStateFlow.getValue();
        this.submitHandler.onSubmit((PaymentComponentState)state);
    }

    public boolean isConfirmationRequired() {
        return this._viewFlow.getValue() instanceof ButtonComponentViewType;
    }

    public boolean shouldShowSubmitButton() {
        return this.isConfirmationRequired() && this.getComponentParams().isSubmitButtonVisible();
    }

    @Override
    public void setInteractionBlocked(boolean isInteractionBlocked) {
        this.submitHandler.setInteractionBlocked(isInteractionBlocked);
    }

    public void onCleared() {
        this.removeObserver();
    }

    public static final /* synthetic */ AnalyticsRepository access$getAnalyticsRepository$p(DefaultBlikDelegate $this) {
        return $this.analyticsRepository;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/adyen/checkout/blik/internal/ui/DefaultBlikDelegate$Companion;", "", "()V", "TAG", "", "blik_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

