/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.adyen3ds2.internal.data.model;

import com.adyen.checkout.adyen3ds2.internal.data.model.ChallengeResult;
import com.adyen.checkout.core.exception.ComponentException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006J\"\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\r"}, d2={"Lcom/adyen/checkout/adyen3ds2/internal/data/model/Adyen3DS2Serializer;", "", "()V", "createChallengeDetails", "Lorg/json/JSONObject;", "transactionStatus", "", "errorDetails", "createFingerprintDetails", "encodedFingerprint", "createThreeDsResultDetails", "authorisationToken", "Companion", "3ds2_release"})
public final class Adyen3DS2Serializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String FINGERPRINT_DETAILS_KEY = "threeds2.fingerprint";
    @NotNull
    private static final String CHALLENGE_DETAILS_KEY = "threeds2.challengeResult";
    @NotNull
    private static final String THREEDS_RESULT_KEY = "threeDSResult";

    @NotNull
    public final JSONObject createFingerprintDetails(@NotNull String encodedFingerprint) throws ComponentException {
        Intrinsics.checkNotNullParameter((Object)encodedFingerprint, (String)"encodedFingerprint");
        JSONObject fingerprintDetails = new JSONObject();
        try {
            fingerprintDetails.put(FINGERPRINT_DETAILS_KEY, (Object)encodedFingerprint);
        }
        catch (JSONException e) {
            throw new ComponentException("Failed to create fingerprint details", (Throwable)e);
        }
        return fingerprintDetails;
    }

    @NotNull
    public final JSONObject createChallengeDetails(@NotNull String transactionStatus, @Nullable String errorDetails) throws ComponentException {
        Intrinsics.checkNotNullParameter((Object)transactionStatus, (String)"transactionStatus");
        JSONObject challengeDetails = new JSONObject();
        try {
            ChallengeResult challengeResult = ChallengeResult.Companion.from$default(ChallengeResult.Companion, transactionStatus, errorDetails, null, 4, null);
            challengeDetails.put(CHALLENGE_DETAILS_KEY, (Object)challengeResult.getPayload());
        }
        catch (JSONException e) {
            throw new ComponentException("Failed to create challenge details", (Throwable)e);
        }
        return challengeDetails;
    }

    public static /* synthetic */ JSONObject createChallengeDetails$default(Adyen3DS2Serializer adyen3DS2Serializer, String string, String string2, int n, Object object) throws ComponentException {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return adyen3DS2Serializer.createChallengeDetails(string, string2);
    }

    @NotNull
    public final JSONObject createThreeDsResultDetails(@NotNull String transactionStatus, @NotNull String authorisationToken, @Nullable String errorDetails) throws ComponentException {
        Intrinsics.checkNotNullParameter((Object)transactionStatus, (String)"transactionStatus");
        Intrinsics.checkNotNullParameter((Object)authorisationToken, (String)"authorisationToken");
        JSONObject threeDsDetails = new JSONObject();
        try {
            ChallengeResult challengeResult = ChallengeResult.Companion.from(transactionStatus, errorDetails, authorisationToken);
            threeDsDetails.put(THREEDS_RESULT_KEY, (Object)challengeResult.getPayload());
        }
        catch (JSONException e) {
            throw new ComponentException("Failed to create ThreeDS Result details", (Throwable)e);
        }
        return threeDsDetails;
    }

    public static /* synthetic */ JSONObject createThreeDsResultDetails$default(Adyen3DS2Serializer adyen3DS2Serializer, String string, String string2, String string3, int n, Object object) throws ComponentException {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return adyen3DS2Serializer.createThreeDsResultDetails(string, string2, string3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/adyen/checkout/adyen3ds2/internal/data/model/Adyen3DS2Serializer$Companion;", "", "()V", "CHALLENGE_DETAILS_KEY", "", "FINGERPRINT_DETAILS_KEY", "THREEDS_RESULT_KEY", "3ds2_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

