/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.Util.DateUtil;
import com.adyen.model.Amount;
import com.adyen.model.FraudResult;
import com.adyen.model.ThreeDS2Result;
import com.adyen.model.checkout.CheckoutPaymentsAction;
import com.adyen.model.checkout.InputDetail;
import com.adyen.model.checkout.Redirect;
import com.adyen.model.checkout.ServiceError;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PaymentsResponse {
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    @SerializedName(value="details")
    private List<InputDetail> details = null;
    @SerializedName(value="fraudResult")
    private FraudResult fraudResult = null;
    @SerializedName(value="paymentData")
    private String paymentData = null;
    @SerializedName(value="pspReference")
    private String pspReference = null;
    @SerializedName(value="redirect")
    private Redirect redirect = null;
    @SerializedName(value="refusalReason")
    private String refusalReason = null;
    @SerializedName(value="refusalReasonCode")
    private String refusalReasonCode = null;
    @SerializedName(value="resultCode")
    private ResultCodeEnum resultCode = null;
    @SerializedName(value="serviceError")
    private ServiceError serviceError;
    @SerializedName(value="authResponse")
    private ResultCodeEnum authResponse;
    @SerializedName(value="merchantReference")
    private String merchantReference;
    @SerializedName(value="outputDetails")
    private Map<String, String> outputDetails;
    @SerializedName(value="authentication")
    private Map<String, String> authentication;
    @SerializedName(value="threeDS2Result")
    private ThreeDS2Result threeDS2Result;
    @SerializedName(value="action")
    private CheckoutPaymentsAction action;
    @SerializedName(value="amount")
    private Amount amount = null;

    public PaymentsResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public PaymentsResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public String getAdditionalDataByKey(String key) {
        if (this.additionalData == null) {
            return null;
        }
        return this.additionalData.get(key);
    }

    public PaymentsResponse details(List<InputDetail> details) {
        this.details = details;
        return this;
    }

    public PaymentsResponse addDetailsItem(InputDetail detailsItem) {
        if (this.details == null) {
            this.details = new ArrayList<InputDetail>();
        }
        this.details.add(detailsItem);
        return this;
    }

    public String getOutputDetailDataByKey(String key) {
        if (this.outputDetails == null) {
            return null;
        }
        return this.outputDetails.get(key);
    }

    public List<InputDetail> getDetails() {
        return this.details;
    }

    public void setDetails(List<InputDetail> details) {
        this.details = details;
    }

    public PaymentsResponse fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        return this;
    }

    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
    }

    public PaymentsResponse paymentData(String paymentData) {
        this.paymentData = paymentData;
        return this;
    }

    public String getPaymentData() {
        return this.paymentData;
    }

    public void setPaymentData(String paymentData) {
        this.paymentData = paymentData;
    }

    public PaymentsResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public PaymentsResponse redirect(Redirect redirect) {
        this.redirect = redirect;
        return this;
    }

    public Redirect getRedirect() {
        return this.redirect;
    }

    public void setRedirect(Redirect redirect) {
        this.redirect = redirect;
    }

    public PaymentsResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return this;
    }

    public String getRefusalReason() {
        return this.refusalReason;
    }

    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public PaymentsResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    public String getRefusalReasonCode() {
        return this.refusalReasonCode;
    }

    public void setRefusalReasonCode(String refusalReasonCode) {
        this.refusalReasonCode = refusalReasonCode;
    }

    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public ServiceError getServiceError() {
        return this.serviceError;
    }

    public void setServiceError(ServiceError serviceError) {
        this.serviceError = serviceError;
    }

    public ResultCodeEnum getAuthResponse() {
        return this.authResponse;
    }

    public void setAuthResponse(ResultCodeEnum authResponse) {
        this.authResponse = authResponse;
    }

    public String getMerchantReference() {
        return this.merchantReference;
    }

    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public Map<String, String> getOutputDetails() {
        return this.outputDetails;
    }

    public void setOutputDetails(Map<String, String> outputDetails) {
        this.outputDetails = outputDetails;
    }

    public ThreeDS2Result getThreeDS2Result() {
        return this.threeDS2Result;
    }

    public void setThreeDS2Result(ThreeDS2Result threeDS2Result) {
        this.threeDS2Result = threeDS2Result;
    }

    public PaymentsResponse threeDS2Result(ThreeDS2Result threeDS2Result) {
        this.threeDS2Result = threeDS2Result;
        return this;
    }

    public CheckoutPaymentsAction getAction() {
        return this.action;
    }

    public void setAction(CheckoutPaymentsAction action) {
        this.action = action;
    }

    public PaymentsResponse action(CheckoutPaymentsAction action) {
        this.action = action;
        return this;
    }

    public PaymentsResponse amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentsResponse paymentsResponse = (PaymentsResponse)o;
        return Objects.equals(this.additionalData, paymentsResponse.additionalData) && Objects.equals(this.details, paymentsResponse.details) && Objects.equals(this.fraudResult, paymentsResponse.fraudResult) && Objects.equals(this.paymentData, paymentsResponse.paymentData) && Objects.equals(this.pspReference, paymentsResponse.pspReference) && Objects.equals(this.redirect, paymentsResponse.redirect) && Objects.equals(this.refusalReason, paymentsResponse.refusalReason) && Objects.equals(this.refusalReasonCode, paymentsResponse.refusalReasonCode) && Objects.equals((Object)this.resultCode, (Object)paymentsResponse.resultCode) && Objects.equals(this.serviceError, paymentsResponse.serviceError) && Objects.equals((Object)this.authResponse, (Object)paymentsResponse.authResponse) && Objects.equals(this.merchantReference, paymentsResponse.merchantReference) && Objects.equals(this.outputDetails, paymentsResponse.outputDetails) && Objects.equals(this.authentication, paymentsResponse.authentication) && Objects.equals(this.threeDS2Result, paymentsResponse.threeDS2Result) && Objects.equals(this.action, paymentsResponse.action) && Objects.equals(this.amount, paymentsResponse.amount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.details, this.fraudResult, this.paymentData, this.pspReference, this.redirect, this.refusalReason, this.resultCode, this.serviceError, this.authResponse, this.merchantReference, this.outputDetails, this.authentication, this.threeDS2Result, this.action, this.amount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentsResponse {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    paymentData: ").append(this.toIndentedString(this.paymentData)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    redirect: ").append(this.toIndentedString(this.redirect)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    refusalReasonCode: ").append(this.toIndentedString(this.refusalReasonCode)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("    serviceError: ").append(this.toIndentedString(this.serviceError)).append("\n");
        sb.append("    authResponse: ").append(this.toIndentedString((Object)this.authResponse)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    outputDetails: ").append(this.toIndentedString(this.outputDetails)).append("\n");
        sb.append("    authentication: ").append(this.toIndentedString(this.authentication)).append("\n");
        sb.append("    threeDS2Result: ").append(this.toIndentedString(this.threeDS2Result)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String getCardBin() {
        return this.getAdditionalDataByKey("cardBin");
    }

    public String getCardHolderName() {
        return this.getAdditionalDataByKey("cardHolderName");
    }

    public String getCardSummary() {
        return this.getAdditionalDataByKey("cardSummary");
    }

    public String getPaymentMethod() {
        return this.getAdditionalDataByKey("paymentMethod");
    }

    public String getAvsResult() {
        return this.getAdditionalDataByKey("avsResult");
    }

    public boolean get3DOffered() {
        return String.valueOf("true").equals(this.getAdditionalDataByKey("threeDOffered"));
    }

    public boolean get3DAuthenticated() {
        return String.valueOf("true").equals(this.getAdditionalDataByKey("threeDAuthenticated"));
    }

    public String getBoletoBarCodeReference() {
        return this.getOutputDetailDataByKey("boletobancario.barCodeReference");
    }

    public String getBoletoData() {
        return this.getOutputDetailDataByKey("boletobancario.data");
    }

    public String getAuthCode() {
        return this.getAdditionalDataByKey("authCode");
    }

    public Map<String, String> getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(Map<String, String> authentication) {
        this.authentication = authentication;
    }

    public Date getBoletoDueDate() {
        String date = this.getOutputDetailDataByKey("boletobancario.dueDate");
        return DateUtil.parseYmdDate(date);
    }

    public Date getBoletoExpirationDate() {
        String date = this.getOutputDetailDataByKey("boletobancario.expirationDate");
        return DateUtil.parseYmdDate(date);
    }

    public String getBoletoUrl() {
        return this.getOutputDetailDataByKey("boletobancario.url");
    }

    public Date getExpiryDate() {
        String expiryDate = this.getAdditionalDataByKey("expiryDate");
        return DateUtil.parseMYDate(expiryDate);
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResultCodeEnum {
        AUTHENTICATIONFINISHED("AuthenticationFinished"),
        AUTHENTICATIONNOTREQUIRED("AuthenticationNotRequired"),
        AUTHORISED("Authorised"),
        CANCELLED("Cancelled"),
        CHALLENGESHOPPER("ChallengeShopper"),
        ERROR("Error"),
        IDENTIFYSHOPPER("IdentifyShopper"),
        PENDING("Pending"),
        RECEIVED("Received"),
        REDIRECTSHOPPER("RedirectShopper"),
        REFUSED("Refused"),
        PARTIALLYAUTHORISED("PartiallyAuthorised"),
        PRESENTTOSHOPPER("PresentToShopper"),
        UNKNOWN("Unknown");

        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        public static ResultCodeEnum fromValue(String text) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static class Adapter
        extends TypeAdapter<ResultCodeEnum> {
            public void write(JsonWriter jsonWriter, ResultCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ResultCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResultCodeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

