/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.CreateTransferLimitRequest;
import com.adyen.model.balanceplatform.LimitStatus;
import com.adyen.model.balanceplatform.Scope;
import com.adyen.model.balanceplatform.TransferLimit;
import com.adyen.model.balanceplatform.TransferLimitListResponse;
import com.adyen.model.balanceplatform.TransferType;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class TransferLimitsBalancePlatformLevelApi
extends Service {
    public static final String API_VERSION = "2";
    protected String baseURL;

    public TransferLimitsBalancePlatformLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    public TransferLimitsBalancePlatformLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public TransferLimit createTransferLimit(String id, CreateTransferLimitRequest createTransferLimitRequest) throws ApiException, IOException {
        return this.createTransferLimit(id, createTransferLimitRequest, null);
    }

    public TransferLimit createTransferLimit(String id, CreateTransferLimitRequest createTransferLimitRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = createTransferLimitRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/balancePlatforms/{id}/transferLimits", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
        return TransferLimit.fromJson(jsonResult);
    }

    public void deletePendingTransferLimit(String id, String transferLimitId) throws ApiException, IOException {
        this.deletePendingTransferLimit(id, transferLimitId, null);
    }

    public void deletePendingTransferLimit(String id, String transferLimitId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        if (transferLimitId == null) {
            throw new IllegalArgumentException("Please provide the transferLimitId path parameter");
        }
        pathParams.put("transferLimitId", transferLimitId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balancePlatforms/{id}/transferLimits/{transferLimitId}", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    public TransferLimit getSpecificTransferLimit(String id, String transferLimitId) throws ApiException, IOException {
        return this.getSpecificTransferLimit(id, transferLimitId, null);
    }

    public TransferLimit getSpecificTransferLimit(String id, String transferLimitId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        if (transferLimitId == null) {
            throw new IllegalArgumentException("Please provide the transferLimitId path parameter");
        }
        pathParams.put("transferLimitId", transferLimitId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balancePlatforms/{id}/transferLimits/{transferLimitId}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return TransferLimit.fromJson(jsonResult);
    }

    public TransferLimitListResponse getTransferLimits(String id) throws ApiException, IOException {
        return this.getTransferLimits(id, null, null, null, null);
    }

    public TransferLimitListResponse getTransferLimits(String id, Scope scope, TransferType transferType, LimitStatus status, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (scope != null) {
            queryParams.put("scope", scope.toString());
        }
        if (transferType != null) {
            queryParams.put("transferType", transferType.toString());
        }
        if (status != null) {
            queryParams.put("status", status.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/balancePlatforms/{id}/transferLimits", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return TransferLimitListResponse.fromJson(jsonResult);
    }
}

