/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.BankAccountInfo;
import com.adyen.model.legalentitymanagement.CapabilityProblem;
import com.adyen.model.legalentitymanagement.DocumentReference;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.SupportingEntityCapability;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"bankAccount", "capabilities", "documentDetails", "id", "legalEntityId", "problems", "type"})
public class TransferInstrument {
    public static final String JSON_PROPERTY_BANK_ACCOUNT = "bankAccount";
    private BankAccountInfo bankAccount;
    private boolean isSetBankAccount = false;
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private Map<String, SupportingEntityCapability> capabilities;
    private boolean isSetCapabilities = false;
    public static final String JSON_PROPERTY_DOCUMENT_DETAILS = "documentDetails";
    private List<DocumentReference> documentDetails;
    private boolean isSetDocumentDetails = false;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    private boolean isSetId = false;
    public static final String JSON_PROPERTY_LEGAL_ENTITY_ID = "legalEntityId";
    private String legalEntityId;
    private boolean isSetLegalEntityId = false;
    public static final String JSON_PROPERTY_PROBLEMS = "problems";
    private List<CapabilityProblem> problems;
    private boolean isSetProblems = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    private boolean isSetType = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public TransferInstrument() {
    }

    @JsonCreator
    public TransferInstrument(@JsonProperty(value="id") String id) {
        this();
        this.id = id;
    }

    public TransferInstrument bankAccount(BankAccountInfo bankAccount) {
        this.bankAccount = bankAccount;
        this.isSetBankAccount = true;
        return this;
    }

    @JsonProperty(value="bankAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BankAccountInfo getBankAccount() {
        return this.bankAccount;
    }

    @JsonProperty(value="bankAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccount(BankAccountInfo bankAccount) {
        this.bankAccount = bankAccount;
        this.isSetBankAccount = true;
    }

    public TransferInstrument capabilities(Map<String, SupportingEntityCapability> capabilities) {
        this.capabilities = capabilities;
        this.isSetCapabilities = true;
        return this;
    }

    public TransferInstrument putCapabilitiesItem(String key, SupportingEntityCapability capabilitiesItem) {
        if (this.capabilities == null) {
            this.capabilities = new HashMap<String, SupportingEntityCapability>();
        }
        this.capabilities.put(key, capabilitiesItem);
        return this;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, SupportingEntityCapability> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapabilities(Map<String, SupportingEntityCapability> capabilities) {
        this.capabilities = capabilities;
        this.isSetCapabilities = true;
    }

    public TransferInstrument documentDetails(List<DocumentReference> documentDetails) {
        this.documentDetails = documentDetails;
        this.isSetDocumentDetails = true;
        return this;
    }

    public TransferInstrument addDocumentDetailsItem(DocumentReference documentDetailsItem) {
        if (this.documentDetails == null) {
            this.documentDetails = new ArrayList<DocumentReference>();
        }
        this.documentDetails.add(documentDetailsItem);
        return this;
    }

    @JsonProperty(value="documentDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DocumentReference> getDocumentDetails() {
        return this.documentDetails;
    }

    @JsonProperty(value="documentDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentDetails(List<DocumentReference> documentDetails) {
        this.documentDetails = documentDetails;
        this.isSetDocumentDetails = true;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public TransferInstrument legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        this.isSetLegalEntityId = true;
        return this;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        this.isSetLegalEntityId = true;
    }

    public TransferInstrument problems(List<CapabilityProblem> problems) {
        this.problems = problems;
        this.isSetProblems = true;
        return this;
    }

    public TransferInstrument addProblemsItem(CapabilityProblem problemsItem) {
        if (this.problems == null) {
            this.problems = new ArrayList<CapabilityProblem>();
        }
        this.problems.add(problemsItem);
        return this;
    }

    @JsonProperty(value="problems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CapabilityProblem> getProblems() {
        return this.problems;
    }

    @JsonProperty(value="problems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProblems(List<CapabilityProblem> problems) {
        this.problems = problems;
        this.isSetProblems = true;
    }

    public TransferInstrument type(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
    }

    public TransferInstrument includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferInstrument transferInstrument = (TransferInstrument)o;
        return Objects.equals(this.bankAccount, transferInstrument.bankAccount) && Objects.equals(this.isSetBankAccount, transferInstrument.isSetBankAccount) && Objects.equals(this.capabilities, transferInstrument.capabilities) && Objects.equals(this.isSetCapabilities, transferInstrument.isSetCapabilities) && Objects.equals(this.documentDetails, transferInstrument.documentDetails) && Objects.equals(this.isSetDocumentDetails, transferInstrument.isSetDocumentDetails) && Objects.equals(this.id, transferInstrument.id) && Objects.equals(this.isSetId, transferInstrument.isSetId) && Objects.equals(this.legalEntityId, transferInstrument.legalEntityId) && Objects.equals(this.isSetLegalEntityId, transferInstrument.isSetLegalEntityId) && Objects.equals(this.problems, transferInstrument.problems) && Objects.equals(this.isSetProblems, transferInstrument.isSetProblems) && Objects.equals((Object)this.type, (Object)transferInstrument.type) && Objects.equals(this.isSetType, transferInstrument.isSetType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bankAccount, this.isSetBankAccount, this.capabilities, this.isSetCapabilities, this.documentDetails, this.isSetDocumentDetails, this.id, this.isSetId, this.legalEntityId, this.isSetLegalEntityId, this.problems, this.isSetProblems, this.type, this.isSetType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferInstrument {\n");
        sb.append("    bankAccount: ").append(this.toIndentedString(this.bankAccount)).append("\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    documentDetails: ").append(this.toIndentedString(this.documentDetails)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    problems: ").append(this.toIndentedString(this.problems)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetBankAccount) {
            this.addIfNull(nulls, JSON_PROPERTY_BANK_ACCOUNT, this.bankAccount);
        }
        if (this.isSetCapabilities) {
            this.addIfNull(nulls, JSON_PROPERTY_CAPABILITIES, this.capabilities);
        }
        if (this.isSetDocumentDetails) {
            this.addIfNull(nulls, JSON_PROPERTY_DOCUMENT_DETAILS, this.documentDetails);
        }
        if (this.isSetId) {
            this.addIfNull(nulls, JSON_PROPERTY_ID, this.id);
        }
        if (this.isSetLegalEntityId) {
            this.addIfNull(nulls, JSON_PROPERTY_LEGAL_ENTITY_ID, this.legalEntityId);
        }
        if (this.isSetProblems) {
            this.addIfNull(nulls, JSON_PROPERTY_PROBLEMS, this.problems);
        }
        if (this.isSetType) {
            this.addIfNull(nulls, JSON_PROPERTY_TYPE, (Object)this.type);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static TransferInstrument fromJson(String jsonString) throws JsonProcessingException {
        return (TransferInstrument)JSON.getMapper().readValue(jsonString, TransferInstrument.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        BANKACCOUNT(String.valueOf("bankAccount")),
        RECURRINGDETAIL(String.valueOf("recurringDetail"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }
}

