/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.SourceOfFunds;
import com.adyen.model.legalentitymanagement.WebData;
import com.adyen.model.legalentitymanagement.WebDataExemption;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"industryCode", "legalEntityId", "salesChannels", "service", "sourceOfFunds", "webData", "webDataExemption"})
public class BusinessLineInfo {
    public static final String JSON_PROPERTY_INDUSTRY_CODE = "industryCode";
    private String industryCode;
    private boolean isSetIndustryCode = false;
    public static final String JSON_PROPERTY_LEGAL_ENTITY_ID = "legalEntityId";
    private String legalEntityId;
    private boolean isSetLegalEntityId = false;
    public static final String JSON_PROPERTY_SALES_CHANNELS = "salesChannels";
    private List<String> salesChannels;
    private boolean isSetSalesChannels = false;
    public static final String JSON_PROPERTY_SERVICE = "service";
    private ServiceEnum service;
    private boolean isSetService = false;
    public static final String JSON_PROPERTY_SOURCE_OF_FUNDS = "sourceOfFunds";
    private SourceOfFunds sourceOfFunds;
    private boolean isSetSourceOfFunds = false;
    public static final String JSON_PROPERTY_WEB_DATA = "webData";
    private List<WebData> webData;
    private boolean isSetWebData = false;
    public static final String JSON_PROPERTY_WEB_DATA_EXEMPTION = "webDataExemption";
    private WebDataExemption webDataExemption;
    private boolean isSetWebDataExemption = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public BusinessLineInfo industryCode(String industryCode) {
        this.industryCode = industryCode;
        this.isSetIndustryCode = true;
        return this;
    }

    @JsonProperty(value="industryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIndustryCode() {
        return this.industryCode;
    }

    @JsonProperty(value="industryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndustryCode(String industryCode) {
        this.industryCode = industryCode;
        this.isSetIndustryCode = true;
    }

    public BusinessLineInfo legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        this.isSetLegalEntityId = true;
        return this;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    @JsonProperty(value="legalEntityId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        this.isSetLegalEntityId = true;
    }

    public BusinessLineInfo salesChannels(List<String> salesChannels) {
        this.salesChannels = salesChannels;
        this.isSetSalesChannels = true;
        return this;
    }

    public BusinessLineInfo addSalesChannelsItem(String salesChannelsItem) {
        if (this.salesChannels == null) {
            this.salesChannels = new ArrayList<String>();
        }
        this.salesChannels.add(salesChannelsItem);
        return this;
    }

    @JsonProperty(value="salesChannels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSalesChannels() {
        return this.salesChannels;
    }

    @JsonProperty(value="salesChannels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSalesChannels(List<String> salesChannels) {
        this.salesChannels = salesChannels;
        this.isSetSalesChannels = true;
    }

    public BusinessLineInfo service(ServiceEnum service) {
        this.service = service;
        this.isSetService = true;
        return this;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ServiceEnum getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setService(ServiceEnum service) {
        this.service = service;
        this.isSetService = true;
    }

    public BusinessLineInfo sourceOfFunds(SourceOfFunds sourceOfFunds) {
        this.sourceOfFunds = sourceOfFunds;
        this.isSetSourceOfFunds = true;
        return this;
    }

    @JsonProperty(value="sourceOfFunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceOfFunds getSourceOfFunds() {
        return this.sourceOfFunds;
    }

    @JsonProperty(value="sourceOfFunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceOfFunds(SourceOfFunds sourceOfFunds) {
        this.sourceOfFunds = sourceOfFunds;
        this.isSetSourceOfFunds = true;
    }

    public BusinessLineInfo webData(List<WebData> webData) {
        this.webData = webData;
        this.isSetWebData = true;
        return this;
    }

    public BusinessLineInfo addWebDataItem(WebData webDataItem) {
        if (this.webData == null) {
            this.webData = new ArrayList<WebData>();
        }
        this.webData.add(webDataItem);
        return this;
    }

    @JsonProperty(value="webData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WebData> getWebData() {
        return this.webData;
    }

    @JsonProperty(value="webData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebData(List<WebData> webData) {
        this.webData = webData;
        this.isSetWebData = true;
    }

    public BusinessLineInfo webDataExemption(WebDataExemption webDataExemption) {
        this.webDataExemption = webDataExemption;
        this.isSetWebDataExemption = true;
        return this;
    }

    @JsonProperty(value="webDataExemption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WebDataExemption getWebDataExemption() {
        return this.webDataExemption;
    }

    @JsonProperty(value="webDataExemption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebDataExemption(WebDataExemption webDataExemption) {
        this.webDataExemption = webDataExemption;
        this.isSetWebDataExemption = true;
    }

    public BusinessLineInfo includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessLineInfo businessLineInfo = (BusinessLineInfo)o;
        return Objects.equals(this.industryCode, businessLineInfo.industryCode) && Objects.equals(this.isSetIndustryCode, businessLineInfo.isSetIndustryCode) && Objects.equals(this.legalEntityId, businessLineInfo.legalEntityId) && Objects.equals(this.isSetLegalEntityId, businessLineInfo.isSetLegalEntityId) && Objects.equals(this.salesChannels, businessLineInfo.salesChannels) && Objects.equals(this.isSetSalesChannels, businessLineInfo.isSetSalesChannels) && Objects.equals((Object)this.service, (Object)businessLineInfo.service) && Objects.equals(this.isSetService, businessLineInfo.isSetService) && Objects.equals(this.sourceOfFunds, businessLineInfo.sourceOfFunds) && Objects.equals(this.isSetSourceOfFunds, businessLineInfo.isSetSourceOfFunds) && Objects.equals(this.webData, businessLineInfo.webData) && Objects.equals(this.isSetWebData, businessLineInfo.isSetWebData) && Objects.equals(this.webDataExemption, businessLineInfo.webDataExemption) && Objects.equals(this.isSetWebDataExemption, businessLineInfo.isSetWebDataExemption);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.industryCode, this.isSetIndustryCode, this.legalEntityId, this.isSetLegalEntityId, this.salesChannels, this.isSetSalesChannels, this.service, this.isSetService, this.sourceOfFunds, this.isSetSourceOfFunds, this.webData, this.isSetWebData, this.webDataExemption, this.isSetWebDataExemption});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessLineInfo {\n");
        sb.append("    industryCode: ").append(this.toIndentedString(this.industryCode)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    salesChannels: ").append(this.toIndentedString(this.salesChannels)).append("\n");
        sb.append("    service: ").append(this.toIndentedString((Object)this.service)).append("\n");
        sb.append("    sourceOfFunds: ").append(this.toIndentedString(this.sourceOfFunds)).append("\n");
        sb.append("    webData: ").append(this.toIndentedString(this.webData)).append("\n");
        sb.append("    webDataExemption: ").append(this.toIndentedString(this.webDataExemption)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetIndustryCode) {
            this.addIfNull(nulls, JSON_PROPERTY_INDUSTRY_CODE, this.industryCode);
        }
        if (this.isSetLegalEntityId) {
            this.addIfNull(nulls, JSON_PROPERTY_LEGAL_ENTITY_ID, this.legalEntityId);
        }
        if (this.isSetSalesChannels) {
            this.addIfNull(nulls, JSON_PROPERTY_SALES_CHANNELS, this.salesChannels);
        }
        if (this.isSetService) {
            this.addIfNull(nulls, JSON_PROPERTY_SERVICE, (Object)this.service);
        }
        if (this.isSetSourceOfFunds) {
            this.addIfNull(nulls, JSON_PROPERTY_SOURCE_OF_FUNDS, this.sourceOfFunds);
        }
        if (this.isSetWebData) {
            this.addIfNull(nulls, JSON_PROPERTY_WEB_DATA, this.webData);
        }
        if (this.isSetWebDataExemption) {
            this.addIfNull(nulls, JSON_PROPERTY_WEB_DATA_EXEMPTION, this.webDataExemption);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static BusinessLineInfo fromJson(String jsonString) throws JsonProcessingException {
        return (BusinessLineInfo)JSON.getMapper().readValue(jsonString, BusinessLineInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ServiceEnum {
        PAYMENTPROCESSING(String.valueOf("paymentProcessing")),
        ISSUING(String.valueOf("issuing")),
        BANKING(String.valueOf("banking"));

        private static final Logger LOG;
        private String value;

        private ServiceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ServiceEnum fromValue(String value) {
            for (ServiceEnum b : ServiceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ServiceEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ServiceEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ServiceEnum.class.getName());
        }
    }
}

