/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.EnhancedSchemeData;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Split;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"amount", "applicationInfo", "enhancedSchemeData", "industryUsage", "lineItems", "merchantAccount", "reference", "splits"})
public class PaymentAmountUpdateRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
    private ApplicationInfo applicationInfo;
    private boolean isSetApplicationInfo = false;
    public static final String JSON_PROPERTY_ENHANCED_SCHEME_DATA = "enhancedSchemeData";
    private EnhancedSchemeData enhancedSchemeData;
    private boolean isSetEnhancedSchemeData = false;
    public static final String JSON_PROPERTY_INDUSTRY_USAGE = "industryUsage";
    private IndustryUsageEnum industryUsage;
    private boolean isSetIndustryUsage = false;
    public static final String JSON_PROPERTY_LINE_ITEMS = "lineItems";
    private List<LineItem> lineItems;
    private boolean isSetLineItems = false;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    private boolean isSetMerchantAccount = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    public static final String JSON_PROPERTY_SPLITS = "splits";
    private List<Split> splits;
    private boolean isSetSplits = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public PaymentAmountUpdateRequest amount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public PaymentAmountUpdateRequest applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        this.isSetApplicationInfo = true;
        return this;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        this.isSetApplicationInfo = true;
    }

    public PaymentAmountUpdateRequest enhancedSchemeData(EnhancedSchemeData enhancedSchemeData) {
        this.enhancedSchemeData = enhancedSchemeData;
        this.isSetEnhancedSchemeData = true;
        return this;
    }

    @JsonProperty(value="enhancedSchemeData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EnhancedSchemeData getEnhancedSchemeData() {
        return this.enhancedSchemeData;
    }

    @JsonProperty(value="enhancedSchemeData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnhancedSchemeData(EnhancedSchemeData enhancedSchemeData) {
        this.enhancedSchemeData = enhancedSchemeData;
        this.isSetEnhancedSchemeData = true;
    }

    public PaymentAmountUpdateRequest industryUsage(IndustryUsageEnum industryUsage) {
        this.industryUsage = industryUsage;
        this.isSetIndustryUsage = true;
        return this;
    }

    @JsonProperty(value="industryUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IndustryUsageEnum getIndustryUsage() {
        return this.industryUsage;
    }

    @JsonProperty(value="industryUsage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndustryUsage(IndustryUsageEnum industryUsage) {
        this.industryUsage = industryUsage;
        this.isSetIndustryUsage = true;
    }

    public PaymentAmountUpdateRequest lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        this.isSetLineItems = true;
        return this;
    }

    public PaymentAmountUpdateRequest addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        this.isSetLineItems = true;
    }

    public PaymentAmountUpdateRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
    }

    public PaymentAmountUpdateRequest reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public PaymentAmountUpdateRequest splits(List<Split> splits) {
        this.splits = splits;
        this.isSetSplits = true;
        return this;
    }

    public PaymentAmountUpdateRequest addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Split> getSplits() {
        return this.splits;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplits(List<Split> splits) {
        this.splits = splits;
        this.isSetSplits = true;
    }

    public PaymentAmountUpdateRequest includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentAmountUpdateRequest paymentAmountUpdateRequest = (PaymentAmountUpdateRequest)o;
        return Objects.equals(this.amount, paymentAmountUpdateRequest.amount) && Objects.equals(this.isSetAmount, paymentAmountUpdateRequest.isSetAmount) && Objects.equals(this.applicationInfo, paymentAmountUpdateRequest.applicationInfo) && Objects.equals(this.isSetApplicationInfo, paymentAmountUpdateRequest.isSetApplicationInfo) && Objects.equals(this.enhancedSchemeData, paymentAmountUpdateRequest.enhancedSchemeData) && Objects.equals(this.isSetEnhancedSchemeData, paymentAmountUpdateRequest.isSetEnhancedSchemeData) && Objects.equals((Object)this.industryUsage, (Object)paymentAmountUpdateRequest.industryUsage) && Objects.equals(this.isSetIndustryUsage, paymentAmountUpdateRequest.isSetIndustryUsage) && Objects.equals(this.lineItems, paymentAmountUpdateRequest.lineItems) && Objects.equals(this.isSetLineItems, paymentAmountUpdateRequest.isSetLineItems) && Objects.equals(this.merchantAccount, paymentAmountUpdateRequest.merchantAccount) && Objects.equals(this.isSetMerchantAccount, paymentAmountUpdateRequest.isSetMerchantAccount) && Objects.equals(this.reference, paymentAmountUpdateRequest.reference) && Objects.equals(this.isSetReference, paymentAmountUpdateRequest.isSetReference) && Objects.equals(this.splits, paymentAmountUpdateRequest.splits) && Objects.equals(this.isSetSplits, paymentAmountUpdateRequest.isSetSplits);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.isSetAmount, this.applicationInfo, this.isSetApplicationInfo, this.enhancedSchemeData, this.isSetEnhancedSchemeData, this.industryUsage, this.isSetIndustryUsage, this.lineItems, this.isSetLineItems, this.merchantAccount, this.isSetMerchantAccount, this.reference, this.isSetReference, this.splits, this.isSetSplits});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentAmountUpdateRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    enhancedSchemeData: ").append(this.toIndentedString(this.enhancedSchemeData)).append("\n");
        sb.append("    industryUsage: ").append(this.toIndentedString((Object)this.industryUsage)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetApplicationInfo) {
            this.addIfNull(nulls, JSON_PROPERTY_APPLICATION_INFO, this.applicationInfo);
        }
        if (this.isSetEnhancedSchemeData) {
            this.addIfNull(nulls, JSON_PROPERTY_ENHANCED_SCHEME_DATA, this.enhancedSchemeData);
        }
        if (this.isSetIndustryUsage) {
            this.addIfNull(nulls, JSON_PROPERTY_INDUSTRY_USAGE, (Object)this.industryUsage);
        }
        if (this.isSetLineItems) {
            this.addIfNull(nulls, JSON_PROPERTY_LINE_ITEMS, this.lineItems);
        }
        if (this.isSetMerchantAccount) {
            this.addIfNull(nulls, JSON_PROPERTY_MERCHANT_ACCOUNT, this.merchantAccount);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        if (this.isSetSplits) {
            this.addIfNull(nulls, JSON_PROPERTY_SPLITS, this.splits);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static PaymentAmountUpdateRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentAmountUpdateRequest)JSON.getMapper().readValue(jsonString, PaymentAmountUpdateRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum IndustryUsageEnum {
        DELAYEDCHARGE(String.valueOf("delayedCharge")),
        INSTALLMENT(String.valueOf("installment")),
        NOSHOW(String.valueOf("noShow"));

        private static final Logger LOG;
        private String value;

        private IndustryUsageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IndustryUsageEnum fromValue(String value) {
            for (IndustryUsageEnum b : IndustryUsageEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("IndustryUsageEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])IndustryUsageEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(IndustryUsageEnum.class.getName());
        }
    }
}

