/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.TransferRouteRequirementsInner;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"category", "country", "currency", "priority", "requirements"})
public class TransferRoute {
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private CategoryEnum category;
    private boolean isSetCategory = false;
    public static final String JSON_PROPERTY_COUNTRY = "country";
    private String country;
    private boolean isSetCountry = false;
    public static final String JSON_PROPERTY_CURRENCY = "currency";
    private String currency;
    private boolean isSetCurrency = false;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private PriorityEnum priority;
    private boolean isSetPriority = false;
    public static final String JSON_PROPERTY_REQUIREMENTS = "requirements";
    private List<TransferRouteRequirementsInner> requirements;
    private boolean isSetRequirements = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public TransferRoute category(CategoryEnum category) {
        this.category = category;
        this.isSetCategory = true;
        return this;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(CategoryEnum category) {
        this.category = category;
        this.isSetCategory = true;
    }

    public TransferRoute country(String country) {
        this.country = country;
        this.isSetCountry = true;
        return this;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountry(String country) {
        this.country = country;
        this.isSetCountry = true;
    }

    public TransferRoute currency(String currency) {
        this.currency = currency;
        this.isSetCurrency = true;
        return this;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrency(String currency) {
        this.currency = currency;
        this.isSetCurrency = true;
    }

    public TransferRoute priority(PriorityEnum priority) {
        this.priority = priority;
        this.isSetPriority = true;
        return this;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PriorityEnum getPriority() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPriority(PriorityEnum priority) {
        this.priority = priority;
        this.isSetPriority = true;
    }

    public TransferRoute requirements(List<TransferRouteRequirementsInner> requirements) {
        this.requirements = requirements;
        this.isSetRequirements = true;
        return this;
    }

    public TransferRoute addRequirementsItem(TransferRouteRequirementsInner requirementsItem) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<TransferRouteRequirementsInner>();
        }
        this.requirements.add(requirementsItem);
        return this;
    }

    @JsonProperty(value="requirements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransferRouteRequirementsInner> getRequirements() {
        return this.requirements;
    }

    @JsonProperty(value="requirements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequirements(List<TransferRouteRequirementsInner> requirements) {
        this.requirements = requirements;
        this.isSetRequirements = true;
    }

    public TransferRoute includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRoute transferRoute = (TransferRoute)o;
        return Objects.equals((Object)this.category, (Object)transferRoute.category) && Objects.equals(this.isSetCategory, transferRoute.isSetCategory) && Objects.equals(this.country, transferRoute.country) && Objects.equals(this.isSetCountry, transferRoute.isSetCountry) && Objects.equals(this.currency, transferRoute.currency) && Objects.equals(this.isSetCurrency, transferRoute.isSetCurrency) && Objects.equals((Object)this.priority, (Object)transferRoute.priority) && Objects.equals(this.isSetPriority, transferRoute.isSetPriority) && Objects.equals(this.requirements, transferRoute.requirements) && Objects.equals(this.isSetRequirements, transferRoute.isSetRequirements);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.isSetCategory, this.country, this.isSetCountry, this.currency, this.isSetCurrency, this.priority, this.isSetPriority, this.requirements, this.isSetRequirements});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferRoute {\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    requirements: ").append(this.toIndentedString(this.requirements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetCategory) {
            this.addIfNull(nulls, JSON_PROPERTY_CATEGORY, (Object)this.category);
        }
        if (this.isSetCountry) {
            this.addIfNull(nulls, JSON_PROPERTY_COUNTRY, this.country);
        }
        if (this.isSetCurrency) {
            this.addIfNull(nulls, JSON_PROPERTY_CURRENCY, this.currency);
        }
        if (this.isSetPriority) {
            this.addIfNull(nulls, JSON_PROPERTY_PRIORITY, (Object)this.priority);
        }
        if (this.isSetRequirements) {
            this.addIfNull(nulls, JSON_PROPERTY_REQUIREMENTS, this.requirements);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static TransferRoute fromJson(String jsonString) throws JsonProcessingException {
        return (TransferRoute)JSON.getMapper().readValue(jsonString, TransferRoute.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PriorityEnum {
        CROSSBORDER(String.valueOf("crossBorder")),
        FAST(String.valueOf("fast")),
        INSTANT(String.valueOf("instant")),
        INTERNAL(String.valueOf("internal")),
        REGULAR(String.valueOf("regular")),
        WIRE(String.valueOf("wire"));

        private static final Logger LOG;
        private String value;

        private PriorityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PriorityEnum fromValue(String value) {
            for (PriorityEnum b : PriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("PriorityEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])PriorityEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(PriorityEnum.class.getName());
        }
    }

    public static enum CategoryEnum {
        BANK(String.valueOf("bank")),
        CARD(String.valueOf("card")),
        GRANTS(String.valueOf("grants")),
        INTEREST(String.valueOf("interest")),
        INTERNAL(String.valueOf("internal")),
        ISSUEDCARD(String.valueOf("issuedCard")),
        MIGRATION(String.valueOf("migration")),
        PLATFORMPAYMENT(String.valueOf("platformPayment")),
        TOPUP(String.valueOf("topUp")),
        UPGRADE(String.valueOf("upgrade"));

        private static final Logger LOG;
        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("CategoryEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])CategoryEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(CategoryEnum.class.getName());
        }
    }
}

