/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.Address;
import com.adyen.model.payout.BankAccount;
import com.adyen.model.payout.Card;
import com.adyen.model.payout.JSON;
import com.adyen.model.payout.Name;
import com.adyen.model.payout.Recurring;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"additionalData", "bank", "billingAddress", "card", "dateOfBirth", "entityType", "fraudOffset", "merchantAccount", "nationality", "recurring", "selectedBrand", "shopperEmail", "shopperName", "shopperReference", "socialSecurityNumber", "telephoneNumber"})
public class StoreDetailRequest {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    public static final String JSON_PROPERTY_BANK = "bank";
    private BankAccount bank;
    public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
    private Address billingAddress;
    public static final String JSON_PROPERTY_CARD = "card";
    private Card card;
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
    private LocalDate dateOfBirth;
    public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
    private EntityTypeEnum entityType;
    public static final String JSON_PROPERTY_FRAUD_OFFSET = "fraudOffset";
    private Integer fraudOffset;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_NATIONALITY = "nationality";
    private String nationality;
    public static final String JSON_PROPERTY_RECURRING = "recurring";
    private Recurring recurring;
    public static final String JSON_PROPERTY_SELECTED_BRAND = "selectedBrand";
    private String selectedBrand;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
    private Name shopperName;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
    private String socialSecurityNumber;
    public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
    private String telephoneNumber;

    public StoreDetailRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public StoreDetailRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public StoreDetailRequest bank(BankAccount bank) {
        this.bank = bank;
        return this;
    }

    @JsonProperty(value="bank")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BankAccount getBank() {
        return this.bank;
    }

    @JsonProperty(value="bank")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBank(BankAccount bank) {
        this.bank = bank;
    }

    public StoreDetailRequest billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public StoreDetailRequest card(Card card) {
        this.card = card;
        return this;
    }

    @JsonProperty(value="card")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Card getCard() {
        return this.card;
    }

    @JsonProperty(value="card")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCard(Card card) {
        this.card = card;
    }

    public StoreDetailRequest dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public StoreDetailRequest entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        return this;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public StoreDetailRequest fraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        return this;
    }

    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFraudOffset() {
        return this.fraudOffset;
    }

    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
    }

    public StoreDetailRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public StoreDetailRequest nationality(String nationality) {
        this.nationality = nationality;
        return this;
    }

    @JsonProperty(value="nationality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNationality() {
        return this.nationality;
    }

    @JsonProperty(value="nationality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public StoreDetailRequest recurring(Recurring recurring) {
        this.recurring = recurring;
        return this;
    }

    @JsonProperty(value="recurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Recurring getRecurring() {
        return this.recurring;
    }

    @JsonProperty(value="recurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    public StoreDetailRequest selectedBrand(String selectedBrand) {
        this.selectedBrand = selectedBrand;
        return this;
    }

    @JsonProperty(value="selectedBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSelectedBrand() {
        return this.selectedBrand;
    }

    @JsonProperty(value="selectedBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelectedBrand(String selectedBrand) {
        this.selectedBrand = selectedBrand;
    }

    public StoreDetailRequest shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public StoreDetailRequest shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getShopperName() {
        return this.shopperName;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public StoreDetailRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public StoreDetailRequest socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return this;
    }

    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public StoreDetailRequest telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreDetailRequest storeDetailRequest = (StoreDetailRequest)o;
        return Objects.equals(this.additionalData, storeDetailRequest.additionalData) && Objects.equals(this.bank, storeDetailRequest.bank) && Objects.equals(this.billingAddress, storeDetailRequest.billingAddress) && Objects.equals(this.card, storeDetailRequest.card) && Objects.equals(this.dateOfBirth, storeDetailRequest.dateOfBirth) && Objects.equals((Object)this.entityType, (Object)storeDetailRequest.entityType) && Objects.equals(this.fraudOffset, storeDetailRequest.fraudOffset) && Objects.equals(this.merchantAccount, storeDetailRequest.merchantAccount) && Objects.equals(this.nationality, storeDetailRequest.nationality) && Objects.equals(this.recurring, storeDetailRequest.recurring) && Objects.equals(this.selectedBrand, storeDetailRequest.selectedBrand) && Objects.equals(this.shopperEmail, storeDetailRequest.shopperEmail) && Objects.equals(this.shopperName, storeDetailRequest.shopperName) && Objects.equals(this.shopperReference, storeDetailRequest.shopperReference) && Objects.equals(this.socialSecurityNumber, storeDetailRequest.socialSecurityNumber) && Objects.equals(this.telephoneNumber, storeDetailRequest.telephoneNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.bank, this.billingAddress, this.card, this.dateOfBirth, this.entityType, this.fraudOffset, this.merchantAccount, this.nationality, this.recurring, this.selectedBrand, this.shopperEmail, this.shopperName, this.shopperReference, this.socialSecurityNumber, this.telephoneNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoreDetailRequest {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    bank: ").append(this.toIndentedString(this.bank)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    fraudOffset: ").append(this.toIndentedString(this.fraudOffset)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    nationality: ").append(this.toIndentedString(this.nationality)).append("\n");
        sb.append("    recurring: ").append(this.toIndentedString(this.recurring)).append("\n");
        sb.append("    selectedBrand: ").append(this.toIndentedString(this.selectedBrand)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    socialSecurityNumber: ").append(this.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static StoreDetailRequest fromJson(String jsonString) throws JsonProcessingException {
        return (StoreDetailRequest)JSON.getMapper().readValue(jsonString, StoreDetailRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum EntityTypeEnum {
        NATURALPERSON(String.valueOf("NaturalPerson")),
        COMPANY(String.valueOf("Company"));

        private static final Logger LOG;
        private String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EntityTypeEnum fromValue(String value) {
            for (EntityTypeEnum b : EntityTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("EntityTypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])EntityTypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(EntityTypeEnum.class.getName());
        }
    }
}

