/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.balanceplatform;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.balanceplatform.AuthorisedCardUsers;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class AuthorizedCardUsersApi
extends Service {
    public static final String API_VERSION = "2";
    protected String baseURL;

    public AuthorizedCardUsersApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/bcl/v2");
    }

    public AuthorizedCardUsersApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public void createAuthorisedCardUsers(String paymentInstrumentId, AuthorisedCardUsers authorisedCardUsers) throws ApiException, IOException {
        this.createAuthorisedCardUsers(paymentInstrumentId, authorisedCardUsers, null);
    }

    public void createAuthorisedCardUsers(String paymentInstrumentId, AuthorisedCardUsers authorisedCardUsers, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (paymentInstrumentId == null) {
            throw new IllegalArgumentException("Please provide the paymentInstrumentId path parameter");
        }
        pathParams.put("paymentInstrumentId", paymentInstrumentId);
        String requestBody = authorisedCardUsers.toJson();
        Resource resource = new Resource(this, this.baseURL + "/paymentInstruments/{paymentInstrumentId}/authorisedCardUsers", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
    }

    public void deleteAuthorisedCardUsers(String paymentInstrumentId) throws ApiException, IOException {
        this.deleteAuthorisedCardUsers(paymentInstrumentId, null);
    }

    public void deleteAuthorisedCardUsers(String paymentInstrumentId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (paymentInstrumentId == null) {
            throw new IllegalArgumentException("Please provide the paymentInstrumentId path parameter");
        }
        pathParams.put("paymentInstrumentId", paymentInstrumentId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/paymentInstruments/{paymentInstrumentId}/authorisedCardUsers", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.DELETE, pathParams);
    }

    public AuthorisedCardUsers getAllAuthorisedCardUsers(String paymentInstrumentId) throws ApiException, IOException {
        return this.getAllAuthorisedCardUsers(paymentInstrumentId, null);
    }

    public AuthorisedCardUsers getAllAuthorisedCardUsers(String paymentInstrumentId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (paymentInstrumentId == null) {
            throw new IllegalArgumentException("Please provide the paymentInstrumentId path parameter");
        }
        pathParams.put("paymentInstrumentId", paymentInstrumentId);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/paymentInstruments/{paymentInstrumentId}/authorisedCardUsers", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return AuthorisedCardUsers.fromJson(jsonResult);
    }

    public void updateAuthorisedCardUsers(String paymentInstrumentId, AuthorisedCardUsers authorisedCardUsers) throws ApiException, IOException {
        this.updateAuthorisedCardUsers(paymentInstrumentId, authorisedCardUsers, null);
    }

    public void updateAuthorisedCardUsers(String paymentInstrumentId, AuthorisedCardUsers authorisedCardUsers, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (paymentInstrumentId == null) {
            throw new IllegalArgumentException("Please provide the paymentInstrumentId path parameter");
        }
        pathParams.put("paymentInstrumentId", paymentInstrumentId);
        String requestBody = authorisedCardUsers.toJson();
        Resource resource = new Resource(this, this.baseURL + "/paymentInstruments/{paymentInstrumentId}/authorisedCardUsers", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.PATCH, pathParams);
    }
}

