/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.storedvalue;

import com.adyen.model.storedvalue.Amount;
import com.adyen.model.storedvalue.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"amount", "loadType", "merchantAccount", "paymentMethod", "recurringDetailReference", "reference", "shopperInteraction", "shopperReference", "store"})
public class StoredValueLoadRequest {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_LOAD_TYPE = "loadType";
    private LoadTypeEnum loadType;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private Map<String, String> paymentMethod;
    public static final String JSON_PROPERTY_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    private String recurringDetailReference;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
    private ShopperInteractionEnum shopperInteraction;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;

    public StoredValueLoadRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public StoredValueLoadRequest loadType(LoadTypeEnum loadType) {
        this.loadType = loadType;
        return this;
    }

    @JsonProperty(value="loadType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LoadTypeEnum getLoadType() {
        return this.loadType;
    }

    @JsonProperty(value="loadType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLoadType(LoadTypeEnum loadType) {
        this.loadType = loadType;
    }

    public StoredValueLoadRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public StoredValueLoadRequest paymentMethod(Map<String, String> paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    public StoredValueLoadRequest putPaymentMethodItem(String key, String paymentMethodItem) {
        if (this.paymentMethod == null) {
            this.paymentMethod = new HashMap<String, String>();
        }
        this.paymentMethod.put(key, paymentMethodItem);
        return this;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(Map<String, String> paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public StoredValueLoadRequest recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    @JsonProperty(value="recurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public StoredValueLoadRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public StoredValueLoadRequest shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public StoredValueLoadRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public StoredValueLoadRequest store(String store) {
        this.store = store;
        return this;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredValueLoadRequest storedValueLoadRequest = (StoredValueLoadRequest)o;
        return Objects.equals(this.amount, storedValueLoadRequest.amount) && Objects.equals((Object)this.loadType, (Object)storedValueLoadRequest.loadType) && Objects.equals(this.merchantAccount, storedValueLoadRequest.merchantAccount) && Objects.equals(this.paymentMethod, storedValueLoadRequest.paymentMethod) && Objects.equals(this.recurringDetailReference, storedValueLoadRequest.recurringDetailReference) && Objects.equals(this.reference, storedValueLoadRequest.reference) && Objects.equals((Object)this.shopperInteraction, (Object)storedValueLoadRequest.shopperInteraction) && Objects.equals(this.shopperReference, storedValueLoadRequest.shopperReference) && Objects.equals(this.store, storedValueLoadRequest.store);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.loadType, this.merchantAccount, this.paymentMethod, this.recurringDetailReference, this.reference, this.shopperInteraction, this.shopperReference, this.store});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StoredValueLoadRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    loadType: ").append(this.toIndentedString((Object)this.loadType)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static StoredValueLoadRequest fromJson(String jsonString) throws JsonProcessingException {
        return (StoredValueLoadRequest)JSON.getMapper().readValue(jsonString, StoredValueLoadRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ShopperInteractionEnum {
        ECOMMERCE(String.valueOf("Ecommerce")),
        CONTAUTH(String.valueOf("ContAuth")),
        MOTO(String.valueOf("Moto")),
        POS(String.valueOf("POS"));

        private static final Logger LOG;
        private String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ShopperInteractionEnum fromValue(String value) {
            for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ShopperInteractionEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ShopperInteractionEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ShopperInteractionEnum.class.getName());
        }
    }

    public static enum LoadTypeEnum {
        MERCHANDISERETURN(String.valueOf("merchandiseReturn")),
        LOAD(String.valueOf("load"));

        private static final Logger LOG;
        private String value;

        private LoadTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LoadTypeEnum fromValue(String value) {
            for (LoadTypeEnum b : LoadTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("LoadTypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])LoadTypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(LoadTypeEnum.class.getName());
        }
    }
}

