/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.acswebhooks;

import com.adyen.model.acswebhooks.AuthenticationNotificationRequest;
import com.adyen.model.acswebhooks.JSON;
import com.adyen.model.acswebhooks.RelayedAuthenticationRequest;
import java.util.Optional;
import java.util.logging.Logger;

public class AcsWebhooksHandler {
    private static final Logger LOG = Logger.getLogger(AcsWebhooksHandler.class.getName());
    private final String payload;

    public AcsWebhooksHandler(String payload) {
        this.payload = payload;
    }

    public Optional<AuthenticationNotificationRequest> getAuthenticationNotificationRequest() {
        return this.getOptionalField(AuthenticationNotificationRequest.class);
    }

    public Optional<RelayedAuthenticationRequest> getRelayedAuthenticationRequest() {
        return this.getOptionalField(RelayedAuthenticationRequest.class);
    }

    private <T> Optional<T> getOptionalField(Class<T> clazz) {
        try {
            Object val = JSON.getMapper().readValue(this.payload, clazz);
            return Optional.ofNullable(val);
        }
        catch (Exception e) {
            LOG.warning("Object not found or unexpected error trying to access:  " + clazz.getName());
            LOG.warning("Deserialization error: " + e.getMessage());
            return Optional.empty();
        }
    }
}

