/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.managementwebhooks;

import com.adyen.model.managementwebhooks.JSON;
import com.adyen.model.managementwebhooks.MerchantCreatedNotificationRequest;
import com.adyen.model.managementwebhooks.MerchantUpdatedNotificationRequest;
import com.adyen.model.managementwebhooks.PaymentMethodCreatedNotificationRequest;
import com.adyen.model.managementwebhooks.PaymentMethodRequestRemovedNotificationRequest;
import com.adyen.model.managementwebhooks.PaymentMethodScheduledForRemovalNotificationRequest;
import com.adyen.model.managementwebhooks.TerminalBoardingNotificationRequest;
import com.adyen.model.managementwebhooks.TerminalSettingsNotificationRequest;
import java.util.Optional;
import java.util.logging.Logger;

public class ManagementWebhooksHandler {
    private static final Logger LOG = Logger.getLogger(ManagementWebhooksHandler.class.getName());
    private final String payload;

    public ManagementWebhooksHandler(String payload) {
        this.payload = payload;
    }

    public Optional<MerchantCreatedNotificationRequest> getMerchantCreatedNotificationRequest() {
        return this.getOptionalField(MerchantCreatedNotificationRequest.class);
    }

    public Optional<MerchantUpdatedNotificationRequest> getMerchantUpdatedNotificationRequest() {
        return this.getOptionalField(MerchantUpdatedNotificationRequest.class);
    }

    public Optional<PaymentMethodCreatedNotificationRequest> getPaymentMethodCreatedNotificationRequest() {
        return this.getOptionalField(PaymentMethodCreatedNotificationRequest.class);
    }

    public Optional<PaymentMethodRequestRemovedNotificationRequest> getPaymentMethodRequestRemovedNotificationRequest() {
        return this.getOptionalField(PaymentMethodRequestRemovedNotificationRequest.class);
    }

    public Optional<PaymentMethodScheduledForRemovalNotificationRequest> getPaymentMethodScheduledForRemovalNotificationRequest() {
        return this.getOptionalField(PaymentMethodScheduledForRemovalNotificationRequest.class);
    }

    public Optional<TerminalBoardingNotificationRequest> getTerminalBoardingNotificationRequest() {
        return this.getOptionalField(TerminalBoardingNotificationRequest.class);
    }

    public Optional<TerminalSettingsNotificationRequest> getTerminalSettingsNotificationRequest() {
        return this.getOptionalField(TerminalSettingsNotificationRequest.class);
    }

    private <T> Optional<T> getOptionalField(Class<T> clazz) {
        try {
            Object val = JSON.getMapper().readValue(this.payload, clazz);
            return Optional.ofNullable(val);
        }
        catch (Exception e) {
            LOG.warning("Object not found or unexpected error trying to access:  " + clazz.getName());
            LOG.warning("Deserialization error: " + e.getMessage());
            return Optional.empty();
        }
    }
}

