/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.BankAccountDetail;
import com.adyen.model.marketpaywebhooks.BusinessDetails;
import com.adyen.model.marketpaywebhooks.IndividualDetails;
import com.adyen.model.marketpaywebhooks.JSON;
import com.adyen.model.marketpaywebhooks.LegalArrangementDetail;
import com.adyen.model.marketpaywebhooks.PayoutMethod;
import com.adyen.model.marketpaywebhooks.StoreDetail;
import com.adyen.model.marketpaywebhooks.ViasAddress;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"address", "bankAccountDetails", "bankAggregatorDataReference", "businessDetails", "email", "fullPhoneNumber", "individualDetails", "lastReviewDate", "legalArrangements", "merchantCategoryCode", "metadata", "payoutMethods", "principalBusinessAddress", "storeDetails", "webAddress"})
public class AccountHolderDetails {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private ViasAddress address;
    public static final String JSON_PROPERTY_BANK_ACCOUNT_DETAILS = "bankAccountDetails";
    private List<BankAccountDetail> bankAccountDetails = null;
    public static final String JSON_PROPERTY_BANK_AGGREGATOR_DATA_REFERENCE = "bankAggregatorDataReference";
    private String bankAggregatorDataReference;
    public static final String JSON_PROPERTY_BUSINESS_DETAILS = "businessDetails";
    private BusinessDetails businessDetails;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_FULL_PHONE_NUMBER = "fullPhoneNumber";
    private String fullPhoneNumber;
    public static final String JSON_PROPERTY_INDIVIDUAL_DETAILS = "individualDetails";
    private IndividualDetails individualDetails;
    public static final String JSON_PROPERTY_LAST_REVIEW_DATE = "lastReviewDate";
    private String lastReviewDate;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENTS = "legalArrangements";
    private List<LegalArrangementDetail> legalArrangements = null;
    public static final String JSON_PROPERTY_MERCHANT_CATEGORY_CODE = "merchantCategoryCode";
    private String merchantCategoryCode;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = null;
    public static final String JSON_PROPERTY_PAYOUT_METHODS = "payoutMethods";
    private List<PayoutMethod> payoutMethods = null;
    public static final String JSON_PROPERTY_PRINCIPAL_BUSINESS_ADDRESS = "principalBusinessAddress";
    private ViasAddress principalBusinessAddress;
    public static final String JSON_PROPERTY_STORE_DETAILS = "storeDetails";
    private List<StoreDetail> storeDetails = null;
    public static final String JSON_PROPERTY_WEB_ADDRESS = "webAddress";
    private String webAddress;

    public AccountHolderDetails address(ViasAddress address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViasAddress getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(ViasAddress address) {
        this.address = address;
    }

    public AccountHolderDetails bankAccountDetails(List<BankAccountDetail> bankAccountDetails) {
        this.bankAccountDetails = bankAccountDetails;
        return this;
    }

    public AccountHolderDetails addBankAccountDetailsItem(BankAccountDetail bankAccountDetailsItem) {
        if (this.bankAccountDetails == null) {
            this.bankAccountDetails = new ArrayList<BankAccountDetail>();
        }
        this.bankAccountDetails.add(bankAccountDetailsItem);
        return this;
    }

    @ApiModelProperty(value="Array of bank accounts associated with the account holder. For details about the required `bankAccountDetail` fields, see [Required information](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/required-information).")
    @JsonProperty(value="bankAccountDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BankAccountDetail> getBankAccountDetails() {
        return this.bankAccountDetails;
    }

    @JsonProperty(value="bankAccountDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccountDetails(List<BankAccountDetail> bankAccountDetails) {
        this.bankAccountDetails = bankAccountDetails;
    }

    public AccountHolderDetails bankAggregatorDataReference(String bankAggregatorDataReference) {
        this.bankAggregatorDataReference = bankAggregatorDataReference;
        return this;
    }

    @ApiModelProperty(value="The opaque reference value returned by the Adyen API during bank account login.")
    @JsonProperty(value="bankAggregatorDataReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankAggregatorDataReference() {
        return this.bankAggregatorDataReference;
    }

    @JsonProperty(value="bankAggregatorDataReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAggregatorDataReference(String bankAggregatorDataReference) {
        this.bankAggregatorDataReference = bankAggregatorDataReference;
    }

    public AccountHolderDetails businessDetails(BusinessDetails businessDetails) {
        this.businessDetails = businessDetails;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="businessDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BusinessDetails getBusinessDetails() {
        return this.businessDetails;
    }

    @JsonProperty(value="businessDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBusinessDetails(BusinessDetails businessDetails) {
        this.businessDetails = businessDetails;
    }

    public AccountHolderDetails email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The email address of the account holder.")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public AccountHolderDetails fullPhoneNumber(String fullPhoneNumber) {
        this.fullPhoneNumber = fullPhoneNumber;
        return this;
    }

    @ApiModelProperty(value="The phone number of the account holder provided as a single string. It will be handled as a landline phone. **Examples:** \"0031 6 11 22 33 44\", \"+316/1122-3344\", \"(0031) 611223344\"")
    @JsonProperty(value="fullPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullPhoneNumber() {
        return this.fullPhoneNumber;
    }

    @JsonProperty(value="fullPhoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullPhoneNumber(String fullPhoneNumber) {
        this.fullPhoneNumber = fullPhoneNumber;
    }

    public AccountHolderDetails individualDetails(IndividualDetails individualDetails) {
        this.individualDetails = individualDetails;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="individualDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IndividualDetails getIndividualDetails() {
        return this.individualDetails;
    }

    @JsonProperty(value="individualDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndividualDetails(IndividualDetails individualDetails) {
        this.individualDetails = individualDetails;
    }

    public AccountHolderDetails lastReviewDate(String lastReviewDate) {
        this.lastReviewDate = lastReviewDate;
        return this;
    }

    @ApiModelProperty(value="Date when you last reviewed the account holder's information, in ISO-8601 YYYY-MM-DD format. For example, **2020-01-31**.")
    @JsonProperty(value="lastReviewDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastReviewDate() {
        return this.lastReviewDate;
    }

    @JsonProperty(value="lastReviewDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastReviewDate(String lastReviewDate) {
        this.lastReviewDate = lastReviewDate;
    }

    public AccountHolderDetails legalArrangements(List<LegalArrangementDetail> legalArrangements) {
        this.legalArrangements = legalArrangements;
        return this;
    }

    public AccountHolderDetails addLegalArrangementsItem(LegalArrangementDetail legalArrangementsItem) {
        if (this.legalArrangements == null) {
            this.legalArrangements = new ArrayList<LegalArrangementDetail>();
        }
        this.legalArrangements.add(legalArrangementsItem);
        return this;
    }

    @ApiModelProperty(value="An array containing information about the account holder's [legal arrangements](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/legal-arrangements).")
    @JsonProperty(value="legalArrangements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LegalArrangementDetail> getLegalArrangements() {
        return this.legalArrangements;
    }

    @JsonProperty(value="legalArrangements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangements(List<LegalArrangementDetail> legalArrangements) {
        this.legalArrangements = legalArrangements;
    }

    public AccountHolderDetails merchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
        return this;
    }

    @ApiModelProperty(value="The Merchant Category Code of the account holder. > If not specified in the request, this will be derived from the platform account (which is configured by Adyen).")
    @JsonProperty(value="merchantCategoryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantCategoryCode() {
        return this.merchantCategoryCode;
    }

    @JsonProperty(value="merchantCategoryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
    }

    public AccountHolderDetails metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public AccountHolderDetails putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="A set of key and value pairs for general use by the account holder or merchant. The keys do not have specific names and may be used for storing miscellaneous data as desired. > The values being stored have a maximum length of eighty (80) characters and will be truncated if necessary. > Note that during an update of metadata, the omission of existing key-value pairs will result in the deletion of those key-value pairs.")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public AccountHolderDetails payoutMethods(List<PayoutMethod> payoutMethods) {
        this.payoutMethods = payoutMethods;
        return this;
    }

    public AccountHolderDetails addPayoutMethodsItem(PayoutMethod payoutMethodsItem) {
        if (this.payoutMethods == null) {
            this.payoutMethods = new ArrayList<PayoutMethod>();
        }
        this.payoutMethods.add(payoutMethodsItem);
        return this;
    }

    @ApiModelProperty(value="Array of tokenized card details associated with the account holder. For details about how you can use the tokens to pay out, refer to [Pay out to cards](https://docs.adyen.com/marketplaces-and-platforms/classic/payout-to-cards).")
    @JsonProperty(value="payoutMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PayoutMethod> getPayoutMethods() {
        return this.payoutMethods;
    }

    @JsonProperty(value="payoutMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutMethods(List<PayoutMethod> payoutMethods) {
        this.payoutMethods = payoutMethods;
    }

    public AccountHolderDetails principalBusinessAddress(ViasAddress principalBusinessAddress) {
        this.principalBusinessAddress = principalBusinessAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="principalBusinessAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViasAddress getPrincipalBusinessAddress() {
        return this.principalBusinessAddress;
    }

    @JsonProperty(value="principalBusinessAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrincipalBusinessAddress(ViasAddress principalBusinessAddress) {
        this.principalBusinessAddress = principalBusinessAddress;
    }

    public AccountHolderDetails storeDetails(List<StoreDetail> storeDetails) {
        this.storeDetails = storeDetails;
        return this;
    }

    public AccountHolderDetails addStoreDetailsItem(StoreDetail storeDetailsItem) {
        if (this.storeDetails == null) {
            this.storeDetails = new ArrayList<StoreDetail>();
        }
        this.storeDetails.add(storeDetailsItem);
        return this;
    }

    @ApiModelProperty(value="Array of stores associated with the account holder. Required when onboarding account holders that have an Adyen [point of sale](https://docs.adyen.com/marketplaces-and-platforms/classic/platforms-for-pos).")
    @JsonProperty(value="storeDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<StoreDetail> getStoreDetails() {
        return this.storeDetails;
    }

    @JsonProperty(value="storeDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStoreDetails(List<StoreDetail> storeDetails) {
        this.storeDetails = storeDetails;
    }

    public AccountHolderDetails webAddress(String webAddress) {
        this.webAddress = webAddress;
        return this;
    }

    @ApiModelProperty(value="The URL of the website of the account holder.")
    @JsonProperty(value="webAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWebAddress() {
        return this.webAddress;
    }

    @JsonProperty(value="webAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWebAddress(String webAddress) {
        this.webAddress = webAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderDetails accountHolderDetails = (AccountHolderDetails)o;
        return Objects.equals(this.address, accountHolderDetails.address) && Objects.equals(this.bankAccountDetails, accountHolderDetails.bankAccountDetails) && Objects.equals(this.bankAggregatorDataReference, accountHolderDetails.bankAggregatorDataReference) && Objects.equals(this.businessDetails, accountHolderDetails.businessDetails) && Objects.equals(this.email, accountHolderDetails.email) && Objects.equals(this.fullPhoneNumber, accountHolderDetails.fullPhoneNumber) && Objects.equals(this.individualDetails, accountHolderDetails.individualDetails) && Objects.equals(this.lastReviewDate, accountHolderDetails.lastReviewDate) && Objects.equals(this.legalArrangements, accountHolderDetails.legalArrangements) && Objects.equals(this.merchantCategoryCode, accountHolderDetails.merchantCategoryCode) && Objects.equals(this.metadata, accountHolderDetails.metadata) && Objects.equals(this.payoutMethods, accountHolderDetails.payoutMethods) && Objects.equals(this.principalBusinessAddress, accountHolderDetails.principalBusinessAddress) && Objects.equals(this.storeDetails, accountHolderDetails.storeDetails) && Objects.equals(this.webAddress, accountHolderDetails.webAddress);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.bankAccountDetails, this.bankAggregatorDataReference, this.businessDetails, this.email, this.fullPhoneNumber, this.individualDetails, this.lastReviewDate, this.legalArrangements, this.merchantCategoryCode, this.metadata, this.payoutMethods, this.principalBusinessAddress, this.storeDetails, this.webAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderDetails {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    bankAccountDetails: ").append(this.toIndentedString(this.bankAccountDetails)).append("\n");
        sb.append("    bankAggregatorDataReference: ").append(this.toIndentedString(this.bankAggregatorDataReference)).append("\n");
        sb.append("    businessDetails: ").append(this.toIndentedString(this.businessDetails)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    fullPhoneNumber: ").append(this.toIndentedString(this.fullPhoneNumber)).append("\n");
        sb.append("    individualDetails: ").append(this.toIndentedString(this.individualDetails)).append("\n");
        sb.append("    lastReviewDate: ").append(this.toIndentedString(this.lastReviewDate)).append("\n");
        sb.append("    legalArrangements: ").append(this.toIndentedString(this.legalArrangements)).append("\n");
        sb.append("    merchantCategoryCode: ").append(this.toIndentedString(this.merchantCategoryCode)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    payoutMethods: ").append(this.toIndentedString(this.payoutMethods)).append("\n");
        sb.append("    principalBusinessAddress: ").append(this.toIndentedString(this.principalBusinessAddress)).append("\n");
        sb.append("    storeDetails: ").append(this.toIndentedString(this.storeDetails)).append("\n");
        sb.append("    webAddress: ").append(this.toIndentedString(this.webAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountHolderDetails fromJson(String jsonString) throws JsonProcessingException {
        return (AccountHolderDetails)JSON.getMapper().readValue(jsonString, AccountHolderDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

