/*
 * Decompiled with CFR 0.152.
 */
package com.adyen;

import com.adyen.Config;
import com.adyen.enums.Environment;
import com.adyen.enums.Region;
import com.adyen.httpclient.AdyenHttpClient;
import com.adyen.httpclient.ClientInterface;
import javax.net.ssl.SSLContext;

public class Client {
    private ClientInterface httpClient;
    private Config config;
    public static final String LIB_NAME = "adyen-java-api-library";
    public static final String LIB_VERSION = "37.0.0";
    public static final String TERMINAL_API_ENDPOINT_TEST = "https://terminal-api-test.adyen.com";
    public static final String TERMINAL_API_ENDPOINT_LIVE = "https://terminal-api-live.adyen.com";
    public static final String TERMINAL_API_ENDPOINT_US = "https://terminal-api-live-us.adyen.com";
    public static final String TERMINAL_API_ENDPOINT_AU = "https://terminal-api-live-au.adyen.com";
    public static final String TERMINAL_API_ENDPOINT_APSE = "https://terminal-api-live-apse.adyen.com";

    public Client() {
        this.config = new Config();
    }

    public Client(Config config) {
        this.config = config;
        this.setEnvironment(config.environment, config.liveEndpointUrlPrefix);
    }

    public Client(String username, String password, Environment environment, String applicationName) {
        this(username, password, environment, null, applicationName);
    }

    public Client(SSLContext sslContext, String apiKey) {
        this(apiKey, Environment.LIVE);
        this.config.setSSLContext(sslContext);
    }

    public Client(String username, String password, Environment environment, String liveEndpointUrlPrefix, String applicationName) {
        this.config = new Config();
        this.config.setUsername(username);
        this.config.setPassword(password);
        this.setEnvironment(environment, liveEndpointUrlPrefix);
        this.config.setApplicationName(applicationName);
    }

    @Deprecated
    public Client(String username, String password, Environment environment, int connectionTimeoutMillis) {
        this(username, password, environment, null);
        this.config.setConnectionTimeoutMillis(connectionTimeoutMillis);
    }

    @Deprecated
    public Client(String username, String password, Environment environment, int connectionTimeoutMillis, String liveEndpointUrlPrefix) {
        this(username, password, environment, liveEndpointUrlPrefix, null);
        this.config.setConnectionTimeoutMillis(connectionTimeoutMillis);
    }

    public Client(String apiKey, Environment environment) {
        this(apiKey, environment, null);
    }

    public Client(String apiKey, Environment environment, String liveEndpointUrlPrefix) {
        this.config = new Config();
        this.config.setApiKey(apiKey);
        this.setEnvironment(environment, liveEndpointUrlPrefix);
    }

    @Deprecated
    public Client(String apiKey, Environment environment, int connectionTimeoutMillis) {
        this(apiKey, environment);
        this.config.setConnectionTimeoutMillis(connectionTimeoutMillis);
    }

    @Deprecated
    public Client(String apiKey, Environment environment, int connectionTimeoutMillis, String liveEndpointUrlPrefix) {
        this(apiKey, environment, liveEndpointUrlPrefix);
        this.config.setConnectionTimeoutMillis(connectionTimeoutMillis);
    }

    @Deprecated
    public void setEnvironment(Environment environment) {
        this.setEnvironment(environment, null);
    }

    public void setEnvironment(Environment environment, String liveEndpointUrlPrefix) {
        this.config.setEnvironment(environment);
        this.config.setLiveEndpointUrlPrefix(liveEndpointUrlPrefix);
        String endpoint = this.retrieveCloudEndpoint(this.config.getTerminalApiRegion(), environment);
        this.config.setTerminalApiCloudEndpoint(endpoint);
    }

    public String retrieveCloudEndpoint(Region region, Environment environment) {
        if (environment.equals((Object)Environment.TEST)) {
            return TERMINAL_API_ENDPOINT_TEST;
        }
        if (environment.equals((Object)Environment.LIVE)) {
            if (region == null) {
                return Region.TERMINAL_API_ENDPOINTS_MAPPING.get((Object)Region.EU);
            }
            if (!Region.TERMINAL_API_ENDPOINTS_MAPPING.containsKey((Object)region)) {
                throw new IllegalArgumentException("TerminalAPI endpoint for " + String.valueOf((Object)region) + " is not supported yet");
            }
            return Region.TERMINAL_API_ENDPOINTS_MAPPING.getOrDefault((Object)region, TERMINAL_API_ENDPOINT_LIVE);
        }
        return TERMINAL_API_ENDPOINT_TEST;
    }

    public String toString() {
        return "Client [webServiceUser=" + this.config.username + ", environment=" + String.valueOf((Object)this.config.environment) + "]";
    }

    public ClientInterface getHttpClient() {
        return this.httpClient == null ? new AdyenHttpClient() : this.httpClient;
    }

    public void setHttpClient(ClientInterface httpClient) {
        this.httpClient = httpClient;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setApplicationName(String applicationName) {
        this.config.setApplicationName(applicationName);
    }

    public void setTimeouts(int connectionTimeoutMillis, int readTimeoutMillis) {
        this.config.setConnectionTimeoutMillis(connectionTimeoutMillis);
        this.config.setReadTimeoutMillis(readTimeoutMillis);
    }
}

