/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Address;
import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.CheckoutSessionThreeDS2RequestData;
import com.adyen.model.checkout.FundOrigin;
import com.adyen.model.checkout.FundRecipient;
import com.adyen.model.checkout.InstallmentOption;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.PlatformChargebackLogic;
import com.adyen.model.checkout.RiskData;
import com.adyen.model.checkout.Split;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"allowedPaymentMethods", "amount", "applicationInfo", "billingAddress", "blockedPaymentMethods", "captureDelayHours", "countryCode", "dateOfBirth", "deliverAt", "deliveryAddress", "description", "expiresAt", "fundOrigin", "fundRecipient", "id", "installmentOptions", "lineItems", "manualCapture", "mcc", "merchantAccount", "merchantOrderReference", "metadata", "platformChargebackLogic", "recurringProcessingModel", "reference", "requiredShopperFields", "returnUrl", "reusable", "riskData", "shopperEmail", "shopperLocale", "shopperName", "shopperReference", "shopperStatement", "showRemovePaymentMethodButton", "socialSecurityNumber", "splitCardFundingSources", "splits", "status", "store", "storePaymentMethodMode", "telephoneNumber", "themeId", "threeDS2RequestData", "updatedAt", "url"})
public class PaymentLinkResponse {
    public static final String JSON_PROPERTY_ALLOWED_PAYMENT_METHODS = "allowedPaymentMethods";
    private List<String> allowedPaymentMethods = new ArrayList<String>();
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
    private ApplicationInfo applicationInfo;
    public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
    private Address billingAddress;
    public static final String JSON_PROPERTY_BLOCKED_PAYMENT_METHODS = "blockedPaymentMethods";
    private List<String> blockedPaymentMethods = new ArrayList<String>();
    public static final String JSON_PROPERTY_CAPTURE_DELAY_HOURS = "captureDelayHours";
    private Integer captureDelayHours;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
    private LocalDate dateOfBirth;
    public static final String JSON_PROPERTY_DELIVER_AT = "deliverAt";
    private OffsetDateTime deliverAt;
    public static final String JSON_PROPERTY_DELIVERY_ADDRESS = "deliveryAddress";
    private Address deliveryAddress;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_FUND_ORIGIN = "fundOrigin";
    private FundOrigin fundOrigin;
    public static final String JSON_PROPERTY_FUND_RECIPIENT = "fundRecipient";
    private FundRecipient fundRecipient;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_INSTALLMENT_OPTIONS = "installmentOptions";
    private Map<String, InstallmentOption> installmentOptions = new HashMap<String, InstallmentOption>();
    public static final String JSON_PROPERTY_LINE_ITEMS = "lineItems";
    private List<LineItem> lineItems = new ArrayList<LineItem>();
    public static final String JSON_PROPERTY_MANUAL_CAPTURE = "manualCapture";
    private Boolean manualCapture;
    public static final String JSON_PROPERTY_MCC = "mcc";
    private String mcc;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_MERCHANT_ORDER_REFERENCE = "merchantOrderReference";
    private String merchantOrderReference;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = new HashMap<String, String>();
    public static final String JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
    private PlatformChargebackLogic platformChargebackLogic;
    public static final String JSON_PROPERTY_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
    private RecurringProcessingModelEnum recurringProcessingModel;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_REQUIRED_SHOPPER_FIELDS = "requiredShopperFields";
    private List<RequiredShopperFieldsEnum> requiredShopperFields = new ArrayList<RequiredShopperFieldsEnum>();
    public static final String JSON_PROPERTY_RETURN_URL = "returnUrl";
    private String returnUrl;
    public static final String JSON_PROPERTY_REUSABLE = "reusable";
    private Boolean reusable;
    public static final String JSON_PROPERTY_RISK_DATA = "riskData";
    private RiskData riskData;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
    private String shopperLocale;
    public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
    private Name shopperName;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_SHOPPER_STATEMENT = "shopperStatement";
    private String shopperStatement;
    public static final String JSON_PROPERTY_SHOW_REMOVE_PAYMENT_METHOD_BUTTON = "showRemovePaymentMethodButton";
    private Boolean showRemovePaymentMethodButton = true;
    public static final String JSON_PROPERTY_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
    private String socialSecurityNumber;
    public static final String JSON_PROPERTY_SPLIT_CARD_FUNDING_SOURCES = "splitCardFundingSources";
    private Boolean splitCardFundingSources = false;
    public static final String JSON_PROPERTY_SPLITS = "splits";
    private List<Split> splits = new ArrayList<Split>();
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;
    public static final String JSON_PROPERTY_STORE_PAYMENT_METHOD_MODE = "storePaymentMethodMode";
    private StorePaymentMethodModeEnum storePaymentMethodMode;
    public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
    private String telephoneNumber;
    public static final String JSON_PROPERTY_THEME_ID = "themeId";
    private String themeId;
    public static final String JSON_PROPERTY_THREE_D_S2_REQUEST_DATA = "threeDS2RequestData";
    private CheckoutSessionThreeDS2RequestData threeDS2RequestData;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public PaymentLinkResponse() {
    }

    @JsonCreator
    public PaymentLinkResponse(@JsonProperty(value="id") String id, @JsonProperty(value="url") String url) {
        this();
        this.id = id;
        this.url = url;
    }

    public PaymentLinkResponse allowedPaymentMethods(List<String> allowedPaymentMethods) {
        this.allowedPaymentMethods = allowedPaymentMethods;
        return this;
    }

    public PaymentLinkResponse addAllowedPaymentMethodsItem(String allowedPaymentMethodsItem) {
        if (this.allowedPaymentMethods == null) {
            this.allowedPaymentMethods = new ArrayList<String>();
        }
        this.allowedPaymentMethods.add(allowedPaymentMethodsItem);
        return this;
    }

    @JsonProperty(value="allowedPaymentMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getAllowedPaymentMethods() {
        return this.allowedPaymentMethods;
    }

    @JsonProperty(value="allowedPaymentMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedPaymentMethods(List<String> allowedPaymentMethods) {
        this.allowedPaymentMethods = allowedPaymentMethods;
    }

    public PaymentLinkResponse amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaymentLinkResponse applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public PaymentLinkResponse billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public PaymentLinkResponse blockedPaymentMethods(List<String> blockedPaymentMethods) {
        this.blockedPaymentMethods = blockedPaymentMethods;
        return this;
    }

    public PaymentLinkResponse addBlockedPaymentMethodsItem(String blockedPaymentMethodsItem) {
        if (this.blockedPaymentMethods == null) {
            this.blockedPaymentMethods = new ArrayList<String>();
        }
        this.blockedPaymentMethods.add(blockedPaymentMethodsItem);
        return this;
    }

    @JsonProperty(value="blockedPaymentMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getBlockedPaymentMethods() {
        return this.blockedPaymentMethods;
    }

    @JsonProperty(value="blockedPaymentMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBlockedPaymentMethods(List<String> blockedPaymentMethods) {
        this.blockedPaymentMethods = blockedPaymentMethods;
    }

    public PaymentLinkResponse captureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
        return this;
    }

    @JsonProperty(value="captureDelayHours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCaptureDelayHours() {
        return this.captureDelayHours;
    }

    @JsonProperty(value="captureDelayHours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
    }

    public PaymentLinkResponse countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public PaymentLinkResponse dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public PaymentLinkResponse deliverAt(OffsetDateTime deliverAt) {
        this.deliverAt = deliverAt;
        return this;
    }

    @JsonProperty(value="deliverAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDeliverAt() {
        return this.deliverAt;
    }

    @JsonProperty(value="deliverAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliverAt(OffsetDateTime deliverAt) {
        this.deliverAt = deliverAt;
    }

    public PaymentLinkResponse deliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @JsonProperty(value="deliveryAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getDeliveryAddress() {
        return this.deliveryAddress;
    }

    @JsonProperty(value="deliveryAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public PaymentLinkResponse description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public PaymentLinkResponse expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public PaymentLinkResponse fundOrigin(FundOrigin fundOrigin) {
        this.fundOrigin = fundOrigin;
        return this;
    }

    @JsonProperty(value="fundOrigin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FundOrigin getFundOrigin() {
        return this.fundOrigin;
    }

    @JsonProperty(value="fundOrigin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundOrigin(FundOrigin fundOrigin) {
        this.fundOrigin = fundOrigin;
    }

    public PaymentLinkResponse fundRecipient(FundRecipient fundRecipient) {
        this.fundRecipient = fundRecipient;
        return this;
    }

    @JsonProperty(value="fundRecipient")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FundRecipient getFundRecipient() {
        return this.fundRecipient;
    }

    @JsonProperty(value="fundRecipient")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundRecipient(FundRecipient fundRecipient) {
        this.fundRecipient = fundRecipient;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public PaymentLinkResponse installmentOptions(Map<String, InstallmentOption> installmentOptions) {
        this.installmentOptions = installmentOptions;
        return this;
    }

    public PaymentLinkResponse putInstallmentOptionsItem(String key, InstallmentOption installmentOptionsItem) {
        if (this.installmentOptions == null) {
            this.installmentOptions = new HashMap<String, InstallmentOption>();
        }
        this.installmentOptions.put(key, installmentOptionsItem);
        return this;
    }

    @JsonProperty(value="installmentOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, InstallmentOption> getInstallmentOptions() {
        return this.installmentOptions;
    }

    @JsonProperty(value="installmentOptions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstallmentOptions(Map<String, InstallmentOption> installmentOptions) {
        this.installmentOptions = installmentOptions;
    }

    public PaymentLinkResponse lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public PaymentLinkResponse addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    @JsonProperty(value="lineItems")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public PaymentLinkResponse manualCapture(Boolean manualCapture) {
        this.manualCapture = manualCapture;
        return this;
    }

    @JsonProperty(value="manualCapture")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getManualCapture() {
        return this.manualCapture;
    }

    @JsonProperty(value="manualCapture")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setManualCapture(Boolean manualCapture) {
        this.manualCapture = manualCapture;
    }

    public PaymentLinkResponse mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMcc() {
        return this.mcc;
    }

    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public PaymentLinkResponse merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public PaymentLinkResponse merchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
        return this;
    }

    @JsonProperty(value="merchantOrderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantOrderReference() {
        return this.merchantOrderReference;
    }

    @JsonProperty(value="merchantOrderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
    }

    public PaymentLinkResponse metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PaymentLinkResponse putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public PaymentLinkResponse platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
        return this;
    }

    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlatformChargebackLogic getPlatformChargebackLogic() {
        return this.platformChargebackLogic;
    }

    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
    }

    public PaymentLinkResponse recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        return this;
    }

    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RecurringProcessingModelEnum getRecurringProcessingModel() {
        return this.recurringProcessingModel;
    }

    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
    }

    public PaymentLinkResponse reference(String reference) {
        this.reference = reference;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentLinkResponse requiredShopperFields(List<RequiredShopperFieldsEnum> requiredShopperFields) {
        this.requiredShopperFields = requiredShopperFields;
        return this;
    }

    public PaymentLinkResponse addRequiredShopperFieldsItem(RequiredShopperFieldsEnum requiredShopperFieldsItem) {
        if (this.requiredShopperFields == null) {
            this.requiredShopperFields = new ArrayList<RequiredShopperFieldsEnum>();
        }
        this.requiredShopperFields.add(requiredShopperFieldsItem);
        return this;
    }

    @JsonProperty(value="requiredShopperFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RequiredShopperFieldsEnum> getRequiredShopperFields() {
        return this.requiredShopperFields;
    }

    @JsonProperty(value="requiredShopperFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequiredShopperFields(List<RequiredShopperFieldsEnum> requiredShopperFields) {
        this.requiredShopperFields = requiredShopperFields;
    }

    public PaymentLinkResponse returnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
        return this;
    }

    @JsonProperty(value="returnUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @JsonProperty(value="returnUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public PaymentLinkResponse reusable(Boolean reusable) {
        this.reusable = reusable;
        return this;
    }

    @JsonProperty(value="reusable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getReusable() {
        return this.reusable;
    }

    @JsonProperty(value="reusable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReusable(Boolean reusable) {
        this.reusable = reusable;
    }

    public PaymentLinkResponse riskData(RiskData riskData) {
        this.riskData = riskData;
        return this;
    }

    @JsonProperty(value="riskData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RiskData getRiskData() {
        return this.riskData;
    }

    @JsonProperty(value="riskData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRiskData(RiskData riskData) {
        this.riskData = riskData;
    }

    public PaymentLinkResponse shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public PaymentLinkResponse shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperLocale() {
        return this.shopperLocale;
    }

    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public PaymentLinkResponse shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getShopperName() {
        return this.shopperName;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public PaymentLinkResponse shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public PaymentLinkResponse shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        return this;
    }

    @JsonProperty(value="shopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperStatement() {
        return this.shopperStatement;
    }

    @JsonProperty(value="shopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public PaymentLinkResponse showRemovePaymentMethodButton(Boolean showRemovePaymentMethodButton) {
        this.showRemovePaymentMethodButton = showRemovePaymentMethodButton;
        return this;
    }

    @JsonProperty(value="showRemovePaymentMethodButton")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowRemovePaymentMethodButton() {
        return this.showRemovePaymentMethodButton;
    }

    @JsonProperty(value="showRemovePaymentMethodButton")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowRemovePaymentMethodButton(Boolean showRemovePaymentMethodButton) {
        this.showRemovePaymentMethodButton = showRemovePaymentMethodButton;
    }

    public PaymentLinkResponse socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return this;
    }

    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public PaymentLinkResponse splitCardFundingSources(Boolean splitCardFundingSources) {
        this.splitCardFundingSources = splitCardFundingSources;
        return this;
    }

    @JsonProperty(value="splitCardFundingSources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSplitCardFundingSources() {
        return this.splitCardFundingSources;
    }

    @JsonProperty(value="splitCardFundingSources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplitCardFundingSources(Boolean splitCardFundingSources) {
        this.splitCardFundingSources = splitCardFundingSources;
    }

    public PaymentLinkResponse splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public PaymentLinkResponse addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Split> getSplits() {
        return this.splits;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public PaymentLinkResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public PaymentLinkResponse store(String store) {
        this.store = store;
        return this;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public PaymentLinkResponse storePaymentMethodMode(StorePaymentMethodModeEnum storePaymentMethodMode) {
        this.storePaymentMethodMode = storePaymentMethodMode;
        return this;
    }

    @JsonProperty(value="storePaymentMethodMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StorePaymentMethodModeEnum getStorePaymentMethodMode() {
        return this.storePaymentMethodMode;
    }

    @JsonProperty(value="storePaymentMethodMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStorePaymentMethodMode(StorePaymentMethodModeEnum storePaymentMethodMode) {
        this.storePaymentMethodMode = storePaymentMethodMode;
    }

    public PaymentLinkResponse telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public PaymentLinkResponse themeId(String themeId) {
        this.themeId = themeId;
        return this;
    }

    @JsonProperty(value="themeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThemeId() {
        return this.themeId;
    }

    @JsonProperty(value="themeId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThemeId(String themeId) {
        this.themeId = themeId;
    }

    public PaymentLinkResponse threeDS2RequestData(CheckoutSessionThreeDS2RequestData threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
        return this;
    }

    @JsonProperty(value="threeDS2RequestData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CheckoutSessionThreeDS2RequestData getThreeDS2RequestData() {
        return this.threeDS2RequestData;
    }

    @JsonProperty(value="threeDS2RequestData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDS2RequestData(CheckoutSessionThreeDS2RequestData threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
    }

    public PaymentLinkResponse updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentLinkResponse paymentLinkResponse = (PaymentLinkResponse)o;
        return Objects.equals(this.allowedPaymentMethods, paymentLinkResponse.allowedPaymentMethods) && Objects.equals(this.amount, paymentLinkResponse.amount) && Objects.equals(this.applicationInfo, paymentLinkResponse.applicationInfo) && Objects.equals(this.billingAddress, paymentLinkResponse.billingAddress) && Objects.equals(this.blockedPaymentMethods, paymentLinkResponse.blockedPaymentMethods) && Objects.equals(this.captureDelayHours, paymentLinkResponse.captureDelayHours) && Objects.equals(this.countryCode, paymentLinkResponse.countryCode) && Objects.equals(this.dateOfBirth, paymentLinkResponse.dateOfBirth) && Objects.equals(this.deliverAt, paymentLinkResponse.deliverAt) && Objects.equals(this.deliveryAddress, paymentLinkResponse.deliveryAddress) && Objects.equals(this.description, paymentLinkResponse.description) && Objects.equals(this.expiresAt, paymentLinkResponse.expiresAt) && Objects.equals(this.fundOrigin, paymentLinkResponse.fundOrigin) && Objects.equals(this.fundRecipient, paymentLinkResponse.fundRecipient) && Objects.equals(this.id, paymentLinkResponse.id) && Objects.equals(this.installmentOptions, paymentLinkResponse.installmentOptions) && Objects.equals(this.lineItems, paymentLinkResponse.lineItems) && Objects.equals(this.manualCapture, paymentLinkResponse.manualCapture) && Objects.equals(this.mcc, paymentLinkResponse.mcc) && Objects.equals(this.merchantAccount, paymentLinkResponse.merchantAccount) && Objects.equals(this.merchantOrderReference, paymentLinkResponse.merchantOrderReference) && Objects.equals(this.metadata, paymentLinkResponse.metadata) && Objects.equals(this.platformChargebackLogic, paymentLinkResponse.platformChargebackLogic) && Objects.equals((Object)this.recurringProcessingModel, (Object)paymentLinkResponse.recurringProcessingModel) && Objects.equals(this.reference, paymentLinkResponse.reference) && Objects.equals(this.requiredShopperFields, paymentLinkResponse.requiredShopperFields) && Objects.equals(this.returnUrl, paymentLinkResponse.returnUrl) && Objects.equals(this.reusable, paymentLinkResponse.reusable) && Objects.equals(this.riskData, paymentLinkResponse.riskData) && Objects.equals(this.shopperEmail, paymentLinkResponse.shopperEmail) && Objects.equals(this.shopperLocale, paymentLinkResponse.shopperLocale) && Objects.equals(this.shopperName, paymentLinkResponse.shopperName) && Objects.equals(this.shopperReference, paymentLinkResponse.shopperReference) && Objects.equals(this.shopperStatement, paymentLinkResponse.shopperStatement) && Objects.equals(this.showRemovePaymentMethodButton, paymentLinkResponse.showRemovePaymentMethodButton) && Objects.equals(this.socialSecurityNumber, paymentLinkResponse.socialSecurityNumber) && Objects.equals(this.splitCardFundingSources, paymentLinkResponse.splitCardFundingSources) && Objects.equals(this.splits, paymentLinkResponse.splits) && Objects.equals((Object)this.status, (Object)paymentLinkResponse.status) && Objects.equals(this.store, paymentLinkResponse.store) && Objects.equals((Object)this.storePaymentMethodMode, (Object)paymentLinkResponse.storePaymentMethodMode) && Objects.equals(this.telephoneNumber, paymentLinkResponse.telephoneNumber) && Objects.equals(this.themeId, paymentLinkResponse.themeId) && Objects.equals(this.threeDS2RequestData, paymentLinkResponse.threeDS2RequestData) && Objects.equals(this.updatedAt, paymentLinkResponse.updatedAt) && Objects.equals(this.url, paymentLinkResponse.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowedPaymentMethods, this.amount, this.applicationInfo, this.billingAddress, this.blockedPaymentMethods, this.captureDelayHours, this.countryCode, this.dateOfBirth, this.deliverAt, this.deliveryAddress, this.description, this.expiresAt, this.fundOrigin, this.fundRecipient, this.id, this.installmentOptions, this.lineItems, this.manualCapture, this.mcc, this.merchantAccount, this.merchantOrderReference, this.metadata, this.platformChargebackLogic, this.recurringProcessingModel, this.reference, this.requiredShopperFields, this.returnUrl, this.reusable, this.riskData, this.shopperEmail, this.shopperLocale, this.shopperName, this.shopperReference, this.shopperStatement, this.showRemovePaymentMethodButton, this.socialSecurityNumber, this.splitCardFundingSources, this.splits, this.status, this.store, this.storePaymentMethodMode, this.telephoneNumber, this.themeId, this.threeDS2RequestData, this.updatedAt, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentLinkResponse {\n");
        sb.append("    allowedPaymentMethods: ").append(this.toIndentedString(this.allowedPaymentMethods)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    blockedPaymentMethods: ").append(this.toIndentedString(this.blockedPaymentMethods)).append("\n");
        sb.append("    captureDelayHours: ").append(this.toIndentedString(this.captureDelayHours)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    deliverAt: ").append(this.toIndentedString(this.deliverAt)).append("\n");
        sb.append("    deliveryAddress: ").append(this.toIndentedString(this.deliveryAddress)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    fundOrigin: ").append(this.toIndentedString(this.fundOrigin)).append("\n");
        sb.append("    fundRecipient: ").append(this.toIndentedString(this.fundRecipient)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    installmentOptions: ").append(this.toIndentedString(this.installmentOptions)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    manualCapture: ").append(this.toIndentedString(this.manualCapture)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantOrderReference: ").append(this.toIndentedString(this.merchantOrderReference)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    platformChargebackLogic: ").append(this.toIndentedString(this.platformChargebackLogic)).append("\n");
        sb.append("    recurringProcessingModel: ").append(this.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    requiredShopperFields: ").append(this.toIndentedString(this.requiredShopperFields)).append("\n");
        sb.append("    returnUrl: ").append(this.toIndentedString(this.returnUrl)).append("\n");
        sb.append("    reusable: ").append(this.toIndentedString(this.reusable)).append("\n");
        sb.append("    riskData: ").append(this.toIndentedString(this.riskData)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperLocale: ").append(this.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    shopperStatement: ").append(this.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    showRemovePaymentMethodButton: ").append(this.toIndentedString(this.showRemovePaymentMethodButton)).append("\n");
        sb.append("    socialSecurityNumber: ").append(this.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("    splitCardFundingSources: ").append(this.toIndentedString(this.splitCardFundingSources)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    storePaymentMethodMode: ").append(this.toIndentedString((Object)this.storePaymentMethodMode)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("    themeId: ").append(this.toIndentedString(this.themeId)).append("\n");
        sb.append("    threeDS2RequestData: ").append(this.toIndentedString(this.threeDS2RequestData)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentLinkResponse fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentLinkResponse)JSON.getMapper().readValue(jsonString, PaymentLinkResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StorePaymentMethodModeEnum {
        ASKFORCONSENT(String.valueOf("askForConsent")),
        DISABLED(String.valueOf("disabled")),
        ENABLED(String.valueOf("enabled"));

        private String value;

        private StorePaymentMethodModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StorePaymentMethodModeEnum fromValue(String value) {
            for (StorePaymentMethodModeEnum b : StorePaymentMethodModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("active")),
        COMPLETED(String.valueOf("completed")),
        EXPIRED(String.valueOf("expired")),
        PAID(String.valueOf("paid")),
        PAYMENTPENDING(String.valueOf("paymentPending"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RequiredShopperFieldsEnum {
        BILLINGADDRESS(String.valueOf("billingAddress")),
        DELIVERYADDRESS(String.valueOf("deliveryAddress")),
        SHOPPEREMAIL(String.valueOf("shopperEmail")),
        SHOPPERNAME(String.valueOf("shopperName")),
        TELEPHONENUMBER(String.valueOf("telephoneNumber"));

        private String value;

        private RequiredShopperFieldsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RequiredShopperFieldsEnum fromValue(String value) {
            for (RequiredShopperFieldsEnum b : RequiredShopperFieldsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RecurringProcessingModelEnum {
        CARDONFILE(String.valueOf("CardOnFile")),
        SUBSCRIPTION(String.valueOf("Subscription")),
        UNSCHEDULEDCARDONFILE(String.valueOf("UnscheduledCardOnFile"));

        private String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RecurringProcessingModelEnum fromValue(String value) {
            for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

