/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.AccountInfo;
import com.adyen.model.payment.Address;
import com.adyen.model.payment.Amount;
import com.adyen.model.payment.ApplicationInfo;
import com.adyen.model.payment.BankAccount;
import com.adyen.model.payment.BrowserInfo;
import com.adyen.model.payment.Card;
import com.adyen.model.payment.ForexQuote;
import com.adyen.model.payment.FundDestination;
import com.adyen.model.payment.FundSource;
import com.adyen.model.payment.Installments;
import com.adyen.model.payment.JSON;
import com.adyen.model.payment.Mandate;
import com.adyen.model.payment.MerchantRiskIndicator;
import com.adyen.model.payment.Name;
import com.adyen.model.payment.PlatformChargebackLogic;
import com.adyen.model.payment.Recurring;
import com.adyen.model.payment.SecureRemoteCommerceCheckoutData;
import com.adyen.model.payment.Split;
import com.adyen.model.payment.ThreeDS2RequestData;
import com.adyen.model.payment.ThreeDSecureData;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"accountInfo", "additionalAmount", "additionalData", "amount", "applicationInfo", "bankAccount", "billingAddress", "browserInfo", "captureDelayHours", "card", "dateOfBirth", "dccQuote", "deliveryAddress", "deliveryDate", "deviceFingerprint", "entityType", "fraudOffset", "fundDestination", "fundSource", "fundingSource", "installments", "localizedShopperStatement", "mandate", "mcc", "merchantAccount", "merchantOrderReference", "merchantRiskIndicator", "metadata", "mpiData", "nationality", "orderReference", "platformChargebackLogic", "recurring", "recurringProcessingModel", "reference", "secureRemoteCommerceCheckoutData", "selectedBrand", "selectedRecurringDetailReference", "sessionId", "shopperEmail", "shopperIP", "shopperInteraction", "shopperLocale", "shopperName", "shopperReference", "shopperStatement", "socialSecurityNumber", "splits", "store", "telephoneNumber", "threeDS2RequestData", "threeDSAuthenticationOnly", "totalsGroup", "trustedShopper"})
public class PaymentRequest {
    public static final String JSON_PROPERTY_ACCOUNT_INFO = "accountInfo";
    private AccountInfo accountInfo;
    public static final String JSON_PROPERTY_ADDITIONAL_AMOUNT = "additionalAmount";
    private Amount additionalAmount;
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData = null;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_APPLICATION_INFO = "applicationInfo";
    private ApplicationInfo applicationInfo;
    public static final String JSON_PROPERTY_BANK_ACCOUNT = "bankAccount";
    private BankAccount bankAccount;
    public static final String JSON_PROPERTY_BILLING_ADDRESS = "billingAddress";
    private Address billingAddress;
    public static final String JSON_PROPERTY_BROWSER_INFO = "browserInfo";
    private BrowserInfo browserInfo;
    public static final String JSON_PROPERTY_CAPTURE_DELAY_HOURS = "captureDelayHours";
    private Integer captureDelayHours;
    public static final String JSON_PROPERTY_CARD = "card";
    private Card card;
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
    private LocalDate dateOfBirth;
    public static final String JSON_PROPERTY_DCC_QUOTE = "dccQuote";
    private ForexQuote dccQuote;
    public static final String JSON_PROPERTY_DELIVERY_ADDRESS = "deliveryAddress";
    private Address deliveryAddress;
    public static final String JSON_PROPERTY_DELIVERY_DATE = "deliveryDate";
    private OffsetDateTime deliveryDate;
    public static final String JSON_PROPERTY_DEVICE_FINGERPRINT = "deviceFingerprint";
    private String deviceFingerprint;
    public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
    private EntityTypeEnum entityType;
    public static final String JSON_PROPERTY_FRAUD_OFFSET = "fraudOffset";
    private Integer fraudOffset;
    public static final String JSON_PROPERTY_FUND_DESTINATION = "fundDestination";
    private FundDestination fundDestination;
    public static final String JSON_PROPERTY_FUND_SOURCE = "fundSource";
    private FundSource fundSource;
    public static final String JSON_PROPERTY_FUNDING_SOURCE = "fundingSource";
    private FundingSourceEnum fundingSource;
    public static final String JSON_PROPERTY_INSTALLMENTS = "installments";
    private Installments installments;
    public static final String JSON_PROPERTY_LOCALIZED_SHOPPER_STATEMENT = "localizedShopperStatement";
    private Map<String, String> localizedShopperStatement = null;
    public static final String JSON_PROPERTY_MANDATE = "mandate";
    private Mandate mandate;
    public static final String JSON_PROPERTY_MCC = "mcc";
    private String mcc;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_MERCHANT_ORDER_REFERENCE = "merchantOrderReference";
    private String merchantOrderReference;
    public static final String JSON_PROPERTY_MERCHANT_RISK_INDICATOR = "merchantRiskIndicator";
    private MerchantRiskIndicator merchantRiskIndicator;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = null;
    public static final String JSON_PROPERTY_MPI_DATA = "mpiData";
    private ThreeDSecureData mpiData;
    public static final String JSON_PROPERTY_NATIONALITY = "nationality";
    private String nationality;
    public static final String JSON_PROPERTY_ORDER_REFERENCE = "orderReference";
    private String orderReference;
    public static final String JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
    private PlatformChargebackLogic platformChargebackLogic;
    public static final String JSON_PROPERTY_RECURRING = "recurring";
    private Recurring recurring;
    public static final String JSON_PROPERTY_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
    private RecurringProcessingModelEnum recurringProcessingModel;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SECURE_REMOTE_COMMERCE_CHECKOUT_DATA = "secureRemoteCommerceCheckoutData";
    private SecureRemoteCommerceCheckoutData secureRemoteCommerceCheckoutData;
    public static final String JSON_PROPERTY_SELECTED_BRAND = "selectedBrand";
    private String selectedBrand;
    public static final String JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE = "selectedRecurringDetailReference";
    private String selectedRecurringDetailReference;
    public static final String JSON_PROPERTY_SESSION_ID = "sessionId";
    private String sessionId;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    public static final String JSON_PROPERTY_SHOPPER_I_P = "shopperIP";
    private String shopperIP;
    public static final String JSON_PROPERTY_SHOPPER_INTERACTION = "shopperInteraction";
    private ShopperInteractionEnum shopperInteraction;
    public static final String JSON_PROPERTY_SHOPPER_LOCALE = "shopperLocale";
    private String shopperLocale;
    public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
    private Name shopperName;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    public static final String JSON_PROPERTY_SHOPPER_STATEMENT = "shopperStatement";
    private String shopperStatement;
    public static final String JSON_PROPERTY_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
    private String socialSecurityNumber;
    public static final String JSON_PROPERTY_SPLITS = "splits";
    private List<Split> splits = null;
    public static final String JSON_PROPERTY_STORE = "store";
    private String store;
    public static final String JSON_PROPERTY_TELEPHONE_NUMBER = "telephoneNumber";
    private String telephoneNumber;
    public static final String JSON_PROPERTY_THREE_D_S2_REQUEST_DATA = "threeDS2RequestData";
    private ThreeDS2RequestData threeDS2RequestData;
    public static final String JSON_PROPERTY_THREE_D_S_AUTHENTICATION_ONLY = "threeDSAuthenticationOnly";
    private Boolean threeDSAuthenticationOnly;
    public static final String JSON_PROPERTY_TOTALS_GROUP = "totalsGroup";
    private String totalsGroup;
    public static final String JSON_PROPERTY_TRUSTED_SHOPPER = "trustedShopper";
    private Boolean trustedShopper;

    public PaymentRequest accountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="accountInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    @JsonProperty(value="accountInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
    }

    public PaymentRequest additionalAmount(Amount additionalAmount) {
        this.additionalAmount = additionalAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="additionalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAdditionalAmount() {
        return this.additionalAmount;
    }

    @JsonProperty(value="additionalAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalAmount(Amount additionalAmount) {
        this.additionalAmount = additionalAmount;
    }

    public PaymentRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public PaymentRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="This field contains additional data, which may be required for a particular payment request.  The `additionalData` object consists of entries, each of which includes the key and value.")
    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public PaymentRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaymentRequest applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    @JsonProperty(value="applicationInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public PaymentRequest bankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="bankAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BankAccount getBankAccount() {
        return this.bankAccount;
    }

    @JsonProperty(value="bankAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccount(BankAccount bankAccount) {
        this.bankAccount = bankAccount;
    }

    public PaymentRequest billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="billingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public PaymentRequest browserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="browserInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BrowserInfo getBrowserInfo() {
        return this.browserInfo;
    }

    @JsonProperty(value="browserInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrowserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
    }

    public PaymentRequest captureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
        return this;
    }

    @ApiModelProperty(value="The delay between the authorisation and scheduled auto-capture, specified in hours.")
    @JsonProperty(value="captureDelayHours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getCaptureDelayHours() {
        return this.captureDelayHours;
    }

    @JsonProperty(value="captureDelayHours")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCaptureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
    }

    public PaymentRequest card(Card card) {
        this.card = card;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="card")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Card getCard() {
        return this.card;
    }

    @JsonProperty(value="card")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCard(Card card) {
        this.card = card;
    }

    public PaymentRequest dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @ApiModelProperty(value="The shopper's date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD")
    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public PaymentRequest dccQuote(ForexQuote dccQuote) {
        this.dccQuote = dccQuote;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="dccQuote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ForexQuote getDccQuote() {
        return this.dccQuote;
    }

    @JsonProperty(value="dccQuote")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDccQuote(ForexQuote dccQuote) {
        this.dccQuote = dccQuote;
    }

    public PaymentRequest deliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="deliveryAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getDeliveryAddress() {
        return this.deliveryAddress;
    }

    @JsonProperty(value="deliveryAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public PaymentRequest deliveryDate(OffsetDateTime deliveryDate) {
        this.deliveryDate = deliveryDate;
        return this;
    }

    @ApiModelProperty(value="The date and time the purchased goods should be delivered.  Format [ISO 8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DDThh:mm:ss.sssTZD  Example: 2017-07-17T13:42:40.428+01:00")
    @JsonProperty(value="deliveryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDeliveryDate() {
        return this.deliveryDate;
    }

    @JsonProperty(value="deliveryDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryDate(OffsetDateTime deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public PaymentRequest deviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
        return this;
    }

    @ApiModelProperty(value="A string containing the shopper's device fingerprint. For more information, refer to [Device fingerprinting](https://docs.adyen.com/risk-management/device-fingerprinting).")
    @JsonProperty(value="deviceFingerprint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceFingerprint() {
        return this.deviceFingerprint;
    }

    @JsonProperty(value="deviceFingerprint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
    }

    public PaymentRequest entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        return this;
    }

    @ApiModelProperty(value="The type of the entity the payment is processed for.")
    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public PaymentRequest fraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        return this;
    }

    @ApiModelProperty(value="An integer value that is added to the normal fraud score. The value can be either positive or negative.")
    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFraudOffset() {
        return this.fraudOffset;
    }

    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
    }

    public PaymentRequest fundDestination(FundDestination fundDestination) {
        this.fundDestination = fundDestination;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="fundDestination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FundDestination getFundDestination() {
        return this.fundDestination;
    }

    @JsonProperty(value="fundDestination")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundDestination(FundDestination fundDestination) {
        this.fundDestination = fundDestination;
    }

    public PaymentRequest fundSource(FundSource fundSource) {
        this.fundSource = fundSource;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="fundSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FundSource getFundSource() {
        return this.fundSource;
    }

    @JsonProperty(value="fundSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundSource(FundSource fundSource) {
        this.fundSource = fundSource;
    }

    public PaymentRequest fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    @ApiModelProperty(value="The funding source that should be used when multiple sources are available. For Brazilian combo cards, by default the funding source is credit. To use debit, set this value to **debit**.")
    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    public PaymentRequest installments(Installments installments) {
        this.installments = installments;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="installments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Installments getInstallments() {
        return this.installments;
    }

    @JsonProperty(value="installments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstallments(Installments installments) {
        this.installments = installments;
    }

    public PaymentRequest localizedShopperStatement(Map<String, String> localizedShopperStatement) {
        this.localizedShopperStatement = localizedShopperStatement;
        return this;
    }

    public PaymentRequest putLocalizedShopperStatementItem(String key, String localizedShopperStatementItem) {
        if (this.localizedShopperStatement == null) {
            this.localizedShopperStatement = new HashMap<String, String>();
        }
        this.localizedShopperStatement.put(key, localizedShopperStatementItem);
        return this;
    }

    @ApiModelProperty(value="The `localizedShopperStatement` field lets you use dynamic values for your shopper statement in a local character set. If not supplied, left empty, or for cross-border transactions, **shopperStatement** is used.  Adyen currently supports the ja-Kana character set for Visa and Mastercard payments in Japan using Japanese cards. This character set supports:  * UTF-8 based Katakana, capital letters, numbers and special characters.  * Half-width or full-width characters.")
    @JsonProperty(value="localizedShopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getLocalizedShopperStatement() {
        return this.localizedShopperStatement;
    }

    @JsonProperty(value="localizedShopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocalizedShopperStatement(Map<String, String> localizedShopperStatement) {
        this.localizedShopperStatement = localizedShopperStatement;
    }

    public PaymentRequest mandate(Mandate mandate) {
        this.mandate = mandate;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="mandate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Mandate getMandate() {
        return this.mandate;
    }

    @JsonProperty(value="mandate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMandate(Mandate mandate) {
        this.mandate = mandate;
    }

    public PaymentRequest mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @ApiModelProperty(value="The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.")
    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMcc() {
        return this.mcc;
    }

    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public PaymentRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier, with which you want to process the transaction.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public PaymentRequest merchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
        return this;
    }

    @ApiModelProperty(value="This reference allows linking multiple transactions to each other for reporting purposes (i.e. order auth-rate). The reference should be unique per billing cycle. The same merchant order reference should never be reused after the first authorised attempt. If used, this field should be supplied for all incoming authorisations. > We strongly recommend you send the `merchantOrderReference` value to benefit from linking payment requests when authorisation retries take place. In addition, we recommend you provide `retry.orderAttemptNumber`, `retry.chainAttemptNumber`, and `retry.skipRetry` values in `PaymentRequest.additionalData`.")
    @JsonProperty(value="merchantOrderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantOrderReference() {
        return this.merchantOrderReference;
    }

    @JsonProperty(value="merchantOrderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
    }

    public PaymentRequest merchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
        this.merchantRiskIndicator = merchantRiskIndicator;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="merchantRiskIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MerchantRiskIndicator getMerchantRiskIndicator() {
        return this.merchantRiskIndicator;
    }

    @JsonProperty(value="merchantRiskIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
        this.merchantRiskIndicator = merchantRiskIndicator;
    }

    public PaymentRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PaymentRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="Metadata consists of entries, each of which includes a key and a value. Limits: * Maximum 20 key-value pairs per request. When exceeding, the \"177\" error occurs: \"Metadata size exceeds limit\". * Maximum 20 characters per key. * Maximum 80 characters per value. ")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public PaymentRequest mpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="mpiData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDSecureData getMpiData() {
        return this.mpiData;
    }

    @JsonProperty(value="mpiData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
    }

    public PaymentRequest nationality(String nationality) {
        this.nationality = nationality;
        return this;
    }

    @ApiModelProperty(value="The two-character country code of the shopper's nationality.")
    @JsonProperty(value="nationality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNationality() {
        return this.nationality;
    }

    @JsonProperty(value="nationality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    public PaymentRequest orderReference(String orderReference) {
        this.orderReference = orderReference;
        return this;
    }

    @ApiModelProperty(value="When you are doing multiple partial (gift card) payments, this is the `pspReference` of the first payment. We use this to link the multiple payments to each other. As your own reference for linking multiple payments, use the `merchantOrderReference`instead.")
    @JsonProperty(value="orderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrderReference() {
        return this.orderReference;
    }

    @JsonProperty(value="orderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrderReference(String orderReference) {
        this.orderReference = orderReference;
    }

    public PaymentRequest platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlatformChargebackLogic getPlatformChargebackLogic() {
        return this.platformChargebackLogic;
    }

    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
    }

    public PaymentRequest recurring(Recurring recurring) {
        this.recurring = recurring;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="recurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Recurring getRecurring() {
        return this.recurring;
    }

    @JsonProperty(value="recurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    public PaymentRequest recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        return this;
    }

    @ApiModelProperty(value="Defines a recurring payment type. Required when creating a token to store payment details or using stored payment details. Allowed values: * `Subscription` \u2013 A transaction for a fixed or variable amount, which follows a fixed schedule. * `CardOnFile` \u2013 With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * `UnscheduledCardOnFile` \u2013 An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or have variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount. ")
    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RecurringProcessingModelEnum getRecurringProcessingModel() {
        return this.recurringProcessingModel;
    }

    @JsonProperty(value="recurringProcessingModel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
    }

    public PaymentRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="The reference to uniquely identify a payment. This reference is used in all communication with you about the payment status. We recommend using a unique value per payment; however, it is not a requirement. If you need to provide multiple references for a transaction, separate them with hyphens (\"-\"). Maximum length: 80 characters.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentRequest secureRemoteCommerceCheckoutData(SecureRemoteCommerceCheckoutData secureRemoteCommerceCheckoutData) {
        this.secureRemoteCommerceCheckoutData = secureRemoteCommerceCheckoutData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="secureRemoteCommerceCheckoutData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SecureRemoteCommerceCheckoutData getSecureRemoteCommerceCheckoutData() {
        return this.secureRemoteCommerceCheckoutData;
    }

    @JsonProperty(value="secureRemoteCommerceCheckoutData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecureRemoteCommerceCheckoutData(SecureRemoteCommerceCheckoutData secureRemoteCommerceCheckoutData) {
        this.secureRemoteCommerceCheckoutData = secureRemoteCommerceCheckoutData;
    }

    public PaymentRequest selectedBrand(String selectedBrand) {
        this.selectedBrand = selectedBrand;
        return this;
    }

    @ApiModelProperty(value="Some payment methods require defining a value for this field to specify how to process the transaction.  For the Bancontact payment method, it can be set to: * `maestro` (default), to be processed like a Maestro card, or * `bcmc`, to be processed like a Bancontact card.")
    @JsonProperty(value="selectedBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSelectedBrand() {
        return this.selectedBrand;
    }

    @JsonProperty(value="selectedBrand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelectedBrand(String selectedBrand) {
        this.selectedBrand = selectedBrand;
    }

    public PaymentRequest selectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
        return this;
    }

    @ApiModelProperty(value="The `recurringDetailReference` you want to use for this payment. The value `LATEST` can be used to select the most recently stored recurring detail.")
    @JsonProperty(value="selectedRecurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSelectedRecurringDetailReference() {
        return this.selectedRecurringDetailReference;
    }

    @JsonProperty(value="selectedRecurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
    }

    public PaymentRequest sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(value="A session ID used to identify a payment session.")
    @JsonProperty(value="sessionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSessionId() {
        return this.sessionId;
    }

    @JsonProperty(value="sessionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public PaymentRequest shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(value="The shopper's email address. We recommend that you provide this data, as it is used in velocity fraud checks. > For 3D Secure 2 transactions, schemes require `shopperEmail` for all browser-based and mobile implementations.")
    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public PaymentRequest shopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
        return this;
    }

    @ApiModelProperty(value="The shopper's IP address. In general, we recommend that you provide this data, as it is used in a number of risk checks (for instance, number of payment attempts or location-based checks). > For 3D Secure 2 transactions, schemes require `shopperIP` for all browser-based implementations. This field is also mandatory for some merchants depending on your business model. For more information, [contact Support](https://www.adyen.help/hc/en-us/requests/new).")
    @JsonProperty(value="shopperIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperIP() {
        return this.shopperIP;
    }

    @JsonProperty(value="shopperIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
    }

    public PaymentRequest shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @ApiModelProperty(value="Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * `Ecommerce` - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * `ContAuth` - Card on file and/or subscription transactions, where the cardholder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * `Moto` - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * `POS` - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.")
    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    @JsonProperty(value="shopperInteraction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public PaymentRequest shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    @ApiModelProperty(value="The combination of a language code and a country code to specify the language to be used in the payment.")
    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperLocale() {
        return this.shopperLocale;
    }

    @JsonProperty(value="shopperLocale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public PaymentRequest shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getShopperName() {
        return this.shopperName;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public PaymentRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. The value is case-sensitive and must be at least three characters. > Your reference must not include personally identifiable information (PII) such as name or email address.")
    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public PaymentRequest shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        return this;
    }

    @ApiModelProperty(value="The text to be shown on the shopper's bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , ' _ - ? + * /_**.")
    @JsonProperty(value="shopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperStatement() {
        return this.shopperStatement;
    }

    @JsonProperty(value="shopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public PaymentRequest socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return this;
    }

    @ApiModelProperty(value="The shopper's social security number.")
    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public PaymentRequest splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public PaymentRequest addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @ApiModelProperty(value="An array of objects specifying how the payment should be split when using either Adyen for Platforms for [marketplaces](https://docs.adyen.com/marketplaces/split-payments) or [platforms]((https://docs.adyen.com/platforms/split-payments), or standalone [Issuing](https://docs.adyen.com/issuing/add-manage-funds#split).")
    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Split> getSplits() {
        return this.splits;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public PaymentRequest store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="Required for Adyen for Platforms integrations if you are a platform model. This is your [reference](https://docs.adyen.com/api-explorer/Management/3/post/merchants/(merchantId)/stores#request-reference) (on [balance platform](https://docs.adyen.com/platforms)) or the [storeReference](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccountHolder#request-accountHolderDetails-storeDetails-storeReference) (in the [classic integration](https://docs.adyen.com/classic-platforms/processing-payments/route-payment-to-store/#route-a-payment-to-a-store)) for the ecommerce or point-of-sale store that is processing the payment.")
    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStore() {
        return this.store;
    }

    @JsonProperty(value="store")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStore(String store) {
        this.store = store;
    }

    public PaymentRequest telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @ApiModelProperty(value="The shopper's telephone number.")
    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @JsonProperty(value="telephoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public PaymentRequest threeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="threeDS2RequestData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDS2RequestData getThreeDS2RequestData() {
        return this.threeDS2RequestData;
    }

    @JsonProperty(value="threeDS2RequestData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
    }

    public PaymentRequest threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
        return this;
    }

    @ApiModelProperty(value="If set to true, you will only perform the [3D Secure 2 authentication](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only), and not the payment authorisation.")
    @JsonProperty(value="threeDSAuthenticationOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getThreeDSAuthenticationOnly() {
        return this.threeDSAuthenticationOnly;
    }

    @JsonProperty(value="threeDSAuthenticationOnly")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    }

    public PaymentRequest totalsGroup(String totalsGroup) {
        this.totalsGroup = totalsGroup;
        return this;
    }

    @ApiModelProperty(value="The reference value to aggregate sales totals in reporting. When not specified, the store field is used (if available).")
    @JsonProperty(value="totalsGroup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTotalsGroup() {
        return this.totalsGroup;
    }

    @JsonProperty(value="totalsGroup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalsGroup(String totalsGroup) {
        this.totalsGroup = totalsGroup;
    }

    public PaymentRequest trustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
        return this;
    }

    @ApiModelProperty(value="Set to true if the payment should be routed to a trusted MID.")
    @JsonProperty(value="trustedShopper")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getTrustedShopper() {
        return this.trustedShopper;
    }

    @JsonProperty(value="trustedShopper")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTrustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentRequest paymentRequest = (PaymentRequest)o;
        return Objects.equals(this.accountInfo, paymentRequest.accountInfo) && Objects.equals(this.additionalAmount, paymentRequest.additionalAmount) && Objects.equals(this.additionalData, paymentRequest.additionalData) && Objects.equals(this.amount, paymentRequest.amount) && Objects.equals(this.applicationInfo, paymentRequest.applicationInfo) && Objects.equals(this.bankAccount, paymentRequest.bankAccount) && Objects.equals(this.billingAddress, paymentRequest.billingAddress) && Objects.equals(this.browserInfo, paymentRequest.browserInfo) && Objects.equals(this.captureDelayHours, paymentRequest.captureDelayHours) && Objects.equals(this.card, paymentRequest.card) && Objects.equals(this.dateOfBirth, paymentRequest.dateOfBirth) && Objects.equals(this.dccQuote, paymentRequest.dccQuote) && Objects.equals(this.deliveryAddress, paymentRequest.deliveryAddress) && Objects.equals(this.deliveryDate, paymentRequest.deliveryDate) && Objects.equals(this.deviceFingerprint, paymentRequest.deviceFingerprint) && Objects.equals((Object)this.entityType, (Object)paymentRequest.entityType) && Objects.equals(this.fraudOffset, paymentRequest.fraudOffset) && Objects.equals(this.fundDestination, paymentRequest.fundDestination) && Objects.equals(this.fundSource, paymentRequest.fundSource) && Objects.equals((Object)this.fundingSource, (Object)paymentRequest.fundingSource) && Objects.equals(this.installments, paymentRequest.installments) && Objects.equals(this.localizedShopperStatement, paymentRequest.localizedShopperStatement) && Objects.equals(this.mandate, paymentRequest.mandate) && Objects.equals(this.mcc, paymentRequest.mcc) && Objects.equals(this.merchantAccount, paymentRequest.merchantAccount) && Objects.equals(this.merchantOrderReference, paymentRequest.merchantOrderReference) && Objects.equals(this.merchantRiskIndicator, paymentRequest.merchantRiskIndicator) && Objects.equals(this.metadata, paymentRequest.metadata) && Objects.equals(this.mpiData, paymentRequest.mpiData) && Objects.equals(this.nationality, paymentRequest.nationality) && Objects.equals(this.orderReference, paymentRequest.orderReference) && Objects.equals(this.platformChargebackLogic, paymentRequest.platformChargebackLogic) && Objects.equals(this.recurring, paymentRequest.recurring) && Objects.equals((Object)this.recurringProcessingModel, (Object)paymentRequest.recurringProcessingModel) && Objects.equals(this.reference, paymentRequest.reference) && Objects.equals(this.secureRemoteCommerceCheckoutData, paymentRequest.secureRemoteCommerceCheckoutData) && Objects.equals(this.selectedBrand, paymentRequest.selectedBrand) && Objects.equals(this.selectedRecurringDetailReference, paymentRequest.selectedRecurringDetailReference) && Objects.equals(this.sessionId, paymentRequest.sessionId) && Objects.equals(this.shopperEmail, paymentRequest.shopperEmail) && Objects.equals(this.shopperIP, paymentRequest.shopperIP) && Objects.equals((Object)this.shopperInteraction, (Object)paymentRequest.shopperInteraction) && Objects.equals(this.shopperLocale, paymentRequest.shopperLocale) && Objects.equals(this.shopperName, paymentRequest.shopperName) && Objects.equals(this.shopperReference, paymentRequest.shopperReference) && Objects.equals(this.shopperStatement, paymentRequest.shopperStatement) && Objects.equals(this.socialSecurityNumber, paymentRequest.socialSecurityNumber) && Objects.equals(this.splits, paymentRequest.splits) && Objects.equals(this.store, paymentRequest.store) && Objects.equals(this.telephoneNumber, paymentRequest.telephoneNumber) && Objects.equals(this.threeDS2RequestData, paymentRequest.threeDS2RequestData) && Objects.equals(this.threeDSAuthenticationOnly, paymentRequest.threeDSAuthenticationOnly) && Objects.equals(this.totalsGroup, paymentRequest.totalsGroup) && Objects.equals(this.trustedShopper, paymentRequest.trustedShopper);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountInfo, this.additionalAmount, this.additionalData, this.amount, this.applicationInfo, this.bankAccount, this.billingAddress, this.browserInfo, this.captureDelayHours, this.card, this.dateOfBirth, this.dccQuote, this.deliveryAddress, this.deliveryDate, this.deviceFingerprint, this.entityType, this.fraudOffset, this.fundDestination, this.fundSource, this.fundingSource, this.installments, this.localizedShopperStatement, this.mandate, this.mcc, this.merchantAccount, this.merchantOrderReference, this.merchantRiskIndicator, this.metadata, this.mpiData, this.nationality, this.orderReference, this.platformChargebackLogic, this.recurring, this.recurringProcessingModel, this.reference, this.secureRemoteCommerceCheckoutData, this.selectedBrand, this.selectedRecurringDetailReference, this.sessionId, this.shopperEmail, this.shopperIP, this.shopperInteraction, this.shopperLocale, this.shopperName, this.shopperReference, this.shopperStatement, this.socialSecurityNumber, this.splits, this.store, this.telephoneNumber, this.threeDS2RequestData, this.threeDSAuthenticationOnly, this.totalsGroup, this.trustedShopper});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentRequest {\n");
        sb.append("    accountInfo: ").append(this.toIndentedString(this.accountInfo)).append("\n");
        sb.append("    additionalAmount: ").append(this.toIndentedString(this.additionalAmount)).append("\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    bankAccount: ").append(this.toIndentedString(this.bankAccount)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    browserInfo: ").append(this.toIndentedString(this.browserInfo)).append("\n");
        sb.append("    captureDelayHours: ").append(this.toIndentedString(this.captureDelayHours)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    dccQuote: ").append(this.toIndentedString(this.dccQuote)).append("\n");
        sb.append("    deliveryAddress: ").append(this.toIndentedString(this.deliveryAddress)).append("\n");
        sb.append("    deliveryDate: ").append(this.toIndentedString(this.deliveryDate)).append("\n");
        sb.append("    deviceFingerprint: ").append(this.toIndentedString(this.deviceFingerprint)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    fraudOffset: ").append(this.toIndentedString(this.fraudOffset)).append("\n");
        sb.append("    fundDestination: ").append(this.toIndentedString(this.fundDestination)).append("\n");
        sb.append("    fundSource: ").append(this.toIndentedString(this.fundSource)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    installments: ").append(this.toIndentedString(this.installments)).append("\n");
        sb.append("    localizedShopperStatement: ").append(this.toIndentedString(this.localizedShopperStatement)).append("\n");
        sb.append("    mandate: ").append(this.toIndentedString(this.mandate)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantOrderReference: ").append(this.toIndentedString(this.merchantOrderReference)).append("\n");
        sb.append("    merchantRiskIndicator: ").append(this.toIndentedString(this.merchantRiskIndicator)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    mpiData: ").append(this.toIndentedString(this.mpiData)).append("\n");
        sb.append("    nationality: ").append(this.toIndentedString(this.nationality)).append("\n");
        sb.append("    orderReference: ").append(this.toIndentedString(this.orderReference)).append("\n");
        sb.append("    platformChargebackLogic: ").append(this.toIndentedString(this.platformChargebackLogic)).append("\n");
        sb.append("    recurring: ").append(this.toIndentedString(this.recurring)).append("\n");
        sb.append("    recurringProcessingModel: ").append(this.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    secureRemoteCommerceCheckoutData: ").append(this.toIndentedString(this.secureRemoteCommerceCheckoutData)).append("\n");
        sb.append("    selectedBrand: ").append(this.toIndentedString(this.selectedBrand)).append("\n");
        sb.append("    selectedRecurringDetailReference: ").append(this.toIndentedString(this.selectedRecurringDetailReference)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperIP: ").append(this.toIndentedString(this.shopperIP)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    shopperLocale: ").append(this.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    shopperStatement: ").append(this.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    socialSecurityNumber: ").append(this.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("    threeDS2RequestData: ").append(this.toIndentedString(this.threeDS2RequestData)).append("\n");
        sb.append("    threeDSAuthenticationOnly: ").append(this.toIndentedString(this.threeDSAuthenticationOnly)).append("\n");
        sb.append("    totalsGroup: ").append(this.toIndentedString(this.totalsGroup)).append("\n");
        sb.append("    trustedShopper: ").append(this.toIndentedString(this.trustedShopper)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static PaymentRequest fromJson(String jsonString) throws JsonProcessingException {
        return (PaymentRequest)JSON.getMapper().readValue(jsonString, PaymentRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ShopperInteractionEnum {
        ECOMMERCE("Ecommerce"),
        CONTAUTH("ContAuth"),
        MOTO("Moto"),
        POS("POS");

        private String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ShopperInteractionEnum fromValue(String value) {
            for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RecurringProcessingModelEnum {
        CARDONFILE("CardOnFile"),
        SUBSCRIPTION("Subscription"),
        UNSCHEDULEDCARDONFILE("UnscheduledCardOnFile");

        private String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RecurringProcessingModelEnum fromValue(String value) {
            for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FundingSourceEnum {
        CREDIT("credit"),
        DEBIT("debit");

        private String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FundingSourceEnum fromValue(String value) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EntityTypeEnum {
        NATURALPERSON("NaturalPerson"),
        COMPANYNAME("CompanyName");

        private String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EntityTypeEnum fromValue(String value) {
            for (EntityTypeEnum b : EntityTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

