/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.Amount;
import com.adyen.model.payment.JSON;
import com.adyen.model.payment.PlatformChargebackLogic;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"donationAccount", "merchantAccount", "modificationAmount", "originalReference", "platformChargebackLogic", "reference"})
public class DonationRequest {
    public static final String JSON_PROPERTY_DONATION_ACCOUNT = "donationAccount";
    private String donationAccount;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_MODIFICATION_AMOUNT = "modificationAmount";
    private Amount modificationAmount;
    public static final String JSON_PROPERTY_ORIGINAL_REFERENCE = "originalReference";
    private String originalReference;
    public static final String JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
    private PlatformChargebackLogic platformChargebackLogic;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;

    public DonationRequest donationAccount(String donationAccount) {
        this.donationAccount = donationAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The Adyen account name of the charity.")
    @JsonProperty(value="donationAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDonationAccount() {
        return this.donationAccount;
    }

    @JsonProperty(value="donationAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDonationAccount(String donationAccount) {
        this.donationAccount = donationAccount;
    }

    public DonationRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account that is used to process the payment.")
    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public DonationRequest modificationAmount(Amount modificationAmount) {
        this.modificationAmount = modificationAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="modificationAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getModificationAmount() {
        return this.modificationAmount;
    }

    @JsonProperty(value="modificationAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModificationAmount(Amount modificationAmount) {
        this.modificationAmount = modificationAmount;
    }

    public DonationRequest originalReference(String originalReference) {
        this.originalReference = originalReference;
        return this;
    }

    @ApiModelProperty(value="The original pspReference of the payment to modify. This reference is returned in: * authorisation response * authorisation notification  ")
    @JsonProperty(value="originalReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOriginalReference() {
        return this.originalReference;
    }

    @JsonProperty(value="originalReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginalReference(String originalReference) {
        this.originalReference = originalReference;
    }

    public DonationRequest platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlatformChargebackLogic getPlatformChargebackLogic() {
        return this.platformChargebackLogic;
    }

    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
    }

    public DonationRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the payment modification. This reference is visible in Customer Area and in reports. Maximum length: 80 characters.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DonationRequest donationRequest = (DonationRequest)o;
        return Objects.equals(this.donationAccount, donationRequest.donationAccount) && Objects.equals(this.merchantAccount, donationRequest.merchantAccount) && Objects.equals(this.modificationAmount, donationRequest.modificationAmount) && Objects.equals(this.originalReference, donationRequest.originalReference) && Objects.equals(this.platformChargebackLogic, donationRequest.platformChargebackLogic) && Objects.equals(this.reference, donationRequest.reference);
    }

    public int hashCode() {
        return Objects.hash(this.donationAccount, this.merchantAccount, this.modificationAmount, this.originalReference, this.platformChargebackLogic, this.reference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DonationRequest {\n");
        sb.append("    donationAccount: ").append(this.toIndentedString(this.donationAccount)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    modificationAmount: ").append(this.toIndentedString(this.modificationAmount)).append("\n");
        sb.append("    originalReference: ").append(this.toIndentedString(this.originalReference)).append("\n");
        sb.append("    platformChargebackLogic: ").append(this.toIndentedString(this.platformChargebackLogic)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static DonationRequest fromJson(String jsonString) throws JsonProcessingException {
        return (DonationRequest)JSON.getMapper().readValue(jsonString, DonationRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

