/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"numberOfApprovalsRequired", "scaOnApproval"})
public class TransferRequestReview {
    public static final String JSON_PROPERTY_NUMBER_OF_APPROVALS_REQUIRED = "numberOfApprovalsRequired";
    private Integer numberOfApprovalsRequired;
    public static final String JSON_PROPERTY_SCA_ON_APPROVAL = "scaOnApproval";
    private Boolean scaOnApproval;

    public TransferRequestReview numberOfApprovalsRequired(Integer numberOfApprovalsRequired) {
        this.numberOfApprovalsRequired = numberOfApprovalsRequired;
        return this;
    }

    @ApiModelProperty(value="Specifies the number of [approvals](https://docs.adyen.com/api-explorer/transfers/latest/post/transfers/approve) required to process the transfer.")
    @JsonProperty(value="numberOfApprovalsRequired")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getNumberOfApprovalsRequired() {
        return this.numberOfApprovalsRequired;
    }

    @JsonProperty(value="numberOfApprovalsRequired")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNumberOfApprovalsRequired(Integer numberOfApprovalsRequired) {
        this.numberOfApprovalsRequired = numberOfApprovalsRequired;
    }

    public TransferRequestReview scaOnApproval(Boolean scaOnApproval) {
        this.scaOnApproval = scaOnApproval;
        return this;
    }

    @ApiModelProperty(value="Specifies whether you will initiate Strong Customer Authentication (SCA) in thePOST [/transfers/approve](https://docs.adyen.com/api-explorer/transfers/latest/post/transfers/approve) request.  Only applies to transfers made with an Adyen [business account](https://docs.adyen.com/platforms/business-accounts).")
    @JsonProperty(value="scaOnApproval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getScaOnApproval() {
        return this.scaOnApproval;
    }

    @JsonProperty(value="scaOnApproval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScaOnApproval(Boolean scaOnApproval) {
        this.scaOnApproval = scaOnApproval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferRequestReview transferRequestReview = (TransferRequestReview)o;
        return Objects.equals(this.numberOfApprovalsRequired, transferRequestReview.numberOfApprovalsRequired) && Objects.equals(this.scaOnApproval, transferRequestReview.scaOnApproval);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfApprovalsRequired, this.scaOnApproval);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferRequestReview {\n");
        sb.append("    numberOfApprovalsRequired: ").append(this.toIndentedString(this.numberOfApprovalsRequired)).append("\n");
        sb.append("    scaOnApproval: ").append(this.toIndentedString(this.scaOnApproval)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransferRequestReview fromJson(String jsonString) throws JsonProcessingException {
        return (TransferRequestReview)JSON.getMapper().readValue(jsonString, TransferRequestReview.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

