/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "expiresAt", "orderData", "pspReference", "reference", "remainingAmount"})
public class CheckoutOrderResponse {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private String expiresAt;
    public static final String JSON_PROPERTY_ORDER_DATA = "orderData";
    private String orderData;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_REMAINING_AMOUNT = "remainingAmount";
    private Amount remainingAmount;

    public CheckoutOrderResponse amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public CheckoutOrderResponse expiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @ApiModelProperty(value="The expiry date for the order.")
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public CheckoutOrderResponse orderData(String orderData) {
        this.orderData = orderData;
        return this;
    }

    @ApiModelProperty(value="The encrypted order data.")
    @JsonProperty(value="orderData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrderData() {
        return this.orderData;
    }

    @JsonProperty(value="orderData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrderData(String orderData) {
        this.orderData = orderData;
    }

    public CheckoutOrderResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The `pspReference` that belongs to the order.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public CheckoutOrderResponse reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="The merchant reference for the order.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public CheckoutOrderResponse remainingAmount(Amount remainingAmount) {
        this.remainingAmount = remainingAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="remainingAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getRemainingAmount() {
        return this.remainingAmount;
    }

    @JsonProperty(value="remainingAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemainingAmount(Amount remainingAmount) {
        this.remainingAmount = remainingAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckoutOrderResponse checkoutOrderResponse = (CheckoutOrderResponse)o;
        return Objects.equals(this.amount, checkoutOrderResponse.amount) && Objects.equals(this.expiresAt, checkoutOrderResponse.expiresAt) && Objects.equals(this.orderData, checkoutOrderResponse.orderData) && Objects.equals(this.pspReference, checkoutOrderResponse.pspReference) && Objects.equals(this.reference, checkoutOrderResponse.reference) && Objects.equals(this.remainingAmount, checkoutOrderResponse.remainingAmount);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.expiresAt, this.orderData, this.pspReference, this.reference, this.remainingAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CheckoutOrderResponse {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    orderData: ").append(this.toIndentedString(this.orderData)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    remainingAmount: ").append(this.toIndentedString(this.remainingAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CheckoutOrderResponse fromJson(String jsonString) throws JsonProcessingException {
        return (CheckoutOrderResponse)JSON.getMapper().readValue(jsonString, CheckoutOrderResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

