/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"orderData", "pspReference"})
public class EncryptedOrderData {
    public static final String JSON_PROPERTY_ORDER_DATA = "orderData";
    private String orderData;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;

    public EncryptedOrderData orderData(String orderData) {
        this.orderData = orderData;
        return this;
    }

    @ApiModelProperty(required=true, value="The encrypted order data.")
    @JsonProperty(value="orderData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrderData() {
        return this.orderData;
    }

    @JsonProperty(value="orderData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrderData(String orderData) {
        this.orderData = orderData;
    }

    public EncryptedOrderData pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The `pspReference` that belongs to the order.")
    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptedOrderData encryptedOrderData = (EncryptedOrderData)o;
        return Objects.equals(this.orderData, encryptedOrderData.orderData) && Objects.equals(this.pspReference, encryptedOrderData.pspReference);
    }

    public int hashCode() {
        return Objects.hash(this.orderData, this.pspReference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EncryptedOrderData {\n");
        sb.append("    orderData: ").append(this.toIndentedString(this.orderData)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static EncryptedOrderData fromJson(String jsonString) throws JsonProcessingException {
        return (EncryptedOrderData)JSON.getMapper().readValue(jsonString, EncryptedOrderData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

