/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.binlookup;

import com.adyen.model.binlookup.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"countryCode", "enrolledIn3DSecure", "mcc"})
public class MerchantDetails {
    public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
    private String countryCode;
    public static final String JSON_PROPERTY_ENROLLED_IN3_D_SECURE = "enrolledIn3DSecure";
    private Boolean enrolledIn3DSecure;
    public static final String JSON_PROPERTY_MCC = "mcc";
    private String mcc;

    public MerchantDetails countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="2-letter ISO 3166 country code of the card acceptor location. > This parameter is required for the merchants who don't use Adyen as the payment authorisation gateway.")
    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="countryCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public MerchantDetails enrolledIn3DSecure(Boolean enrolledIn3DSecure) {
        this.enrolledIn3DSecure = enrolledIn3DSecure;
        return this;
    }

    @ApiModelProperty(value="If true, indicates that the merchant is enrolled in 3D Secure for the card network.")
    @JsonProperty(value="enrolledIn3DSecure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnrolledIn3DSecure() {
        return this.enrolledIn3DSecure;
    }

    @JsonProperty(value="enrolledIn3DSecure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnrolledIn3DSecure(Boolean enrolledIn3DSecure) {
        this.enrolledIn3DSecure = enrolledIn3DSecure;
    }

    public MerchantDetails mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @ApiModelProperty(value="The merchant category code (MCC) is a four-digit number which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.  The list of MCCs can be found [here](https://en.wikipedia.org/wiki/Merchant_category_code).")
    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMcc() {
        return this.mcc;
    }

    @JsonProperty(value="mcc")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantDetails merchantDetails = (MerchantDetails)o;
        return Objects.equals(this.countryCode, merchantDetails.countryCode) && Objects.equals(this.enrolledIn3DSecure, merchantDetails.enrolledIn3DSecure) && Objects.equals(this.mcc, merchantDetails.mcc);
    }

    public int hashCode() {
        return Objects.hash(this.countryCode, this.enrolledIn3DSecure, this.mcc);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantDetails {\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    enrolledIn3DSecure: ").append(this.toIndentedString(this.enrolledIn3DSecure)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static MerchantDetails fromJson(String jsonString) throws JsonProcessingException {
        return (MerchantDetails)JSON.getMapper().readValue(jsonString, MerchantDetails.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

