/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountCode", "accountHolderCode", "showDetails"})
public class GetAccountHolderRequest {
    public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
    private String accountCode;
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_SHOW_DETAILS = "showDetails";
    private Boolean showDetails;

    public GetAccountHolderRequest accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the account of which to retrieve the details. > Required if no `accountHolderCode` is provided.")
    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountCode() {
        return this.accountCode;
    }

    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public GetAccountHolderRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(value="The code of the account holder of which to retrieve the details. > Required if no `accountCode` is provided.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public GetAccountHolderRequest showDetails(Boolean showDetails) {
        this.showDetails = showDetails;
        return this;
    }

    @ApiModelProperty(value="True if the request should return the account holder details")
    @JsonProperty(value="showDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShowDetails() {
        return this.showDetails;
    }

    @JsonProperty(value="showDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowDetails(Boolean showDetails) {
        this.showDetails = showDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAccountHolderRequest getAccountHolderRequest = (GetAccountHolderRequest)o;
        return Objects.equals(this.accountCode, getAccountHolderRequest.accountCode) && Objects.equals(this.accountHolderCode, getAccountHolderRequest.accountHolderCode) && Objects.equals(this.showDetails, getAccountHolderRequest.showDetails);
    }

    public int hashCode() {
        return Objects.hash(this.accountCode, this.accountHolderCode, this.showDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetAccountHolderRequest {\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    showDetails: ").append(this.toIndentedString(this.showDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GetAccountHolderRequest fromJson(String jsonString) throws JsonProcessingException {
        return (GetAccountHolderRequest)JSON.getMapper().readValue(jsonString, GetAccountHolderRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

