/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.AdditionalCommission;
import com.adyen.model.management.Commission;
import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"acquiringFees", "additionalCommission", "adyenCommission", "adyenFees", "adyenMarkup", "chargeback", "chargebackCostAllocation", "commission", "interchange", "paymentFee", "refund", "refundCostAllocation", "remainder", "schemeFee", "splitLogicId", "surcharge", "tip"})
public class SplitConfigurationLogic {
    public static final String JSON_PROPERTY_ACQUIRING_FEES = "acquiringFees";
    private AcquiringFeesEnum acquiringFees;
    public static final String JSON_PROPERTY_ADDITIONAL_COMMISSION = "additionalCommission";
    private AdditionalCommission additionalCommission;
    public static final String JSON_PROPERTY_ADYEN_COMMISSION = "adyenCommission";
    private AdyenCommissionEnum adyenCommission;
    public static final String JSON_PROPERTY_ADYEN_FEES = "adyenFees";
    private AdyenFeesEnum adyenFees;
    public static final String JSON_PROPERTY_ADYEN_MARKUP = "adyenMarkup";
    private AdyenMarkupEnum adyenMarkup;
    public static final String JSON_PROPERTY_CHARGEBACK = "chargeback";
    private ChargebackEnum chargeback;
    public static final String JSON_PROPERTY_CHARGEBACK_COST_ALLOCATION = "chargebackCostAllocation";
    private ChargebackCostAllocationEnum chargebackCostAllocation;
    public static final String JSON_PROPERTY_COMMISSION = "commission";
    private Commission commission;
    public static final String JSON_PROPERTY_INTERCHANGE = "interchange";
    private InterchangeEnum interchange;
    public static final String JSON_PROPERTY_PAYMENT_FEE = "paymentFee";
    private PaymentFeeEnum paymentFee;
    public static final String JSON_PROPERTY_REFUND = "refund";
    private RefundEnum refund;
    public static final String JSON_PROPERTY_REFUND_COST_ALLOCATION = "refundCostAllocation";
    private RefundCostAllocationEnum refundCostAllocation;
    public static final String JSON_PROPERTY_REMAINDER = "remainder";
    private RemainderEnum remainder;
    public static final String JSON_PROPERTY_SCHEME_FEE = "schemeFee";
    private SchemeFeeEnum schemeFee;
    public static final String JSON_PROPERTY_SPLIT_LOGIC_ID = "splitLogicId";
    private String splitLogicId;
    public static final String JSON_PROPERTY_SURCHARGE = "surcharge";
    private SurchargeEnum surcharge;
    public static final String JSON_PROPERTY_TIP = "tip";
    private TipEnum tip;

    public SplitConfigurationLogic acquiringFees(AcquiringFeesEnum acquiringFees) {
        this.acquiringFees = acquiringFees;
        return this;
    }

    @ApiModelProperty(value="Deducts the acquiring fees (the aggregated amount of interchange and scheme fee) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
    @JsonProperty(value="acquiringFees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AcquiringFeesEnum getAcquiringFees() {
        return this.acquiringFees;
    }

    @JsonProperty(value="acquiringFees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcquiringFees(AcquiringFeesEnum acquiringFees) {
        this.acquiringFees = acquiringFees;
    }

    public SplitConfigurationLogic additionalCommission(AdditionalCommission additionalCommission) {
        this.additionalCommission = additionalCommission;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="additionalCommission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AdditionalCommission getAdditionalCommission() {
        return this.additionalCommission;
    }

    @JsonProperty(value="additionalCommission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalCommission(AdditionalCommission additionalCommission) {
        this.additionalCommission = additionalCommission;
    }

    public SplitConfigurationLogic adyenCommission(AdyenCommissionEnum adyenCommission) {
        this.adyenCommission = adyenCommission;
        return this;
    }

    @ApiModelProperty(value="Deducts the transaction fee due to Adyen under [blended rates](https://www.adyen.com/knowledge-hub/guides/payments-training-guide/get-the-best-from-your-card-processing) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
    @JsonProperty(value="adyenCommission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AdyenCommissionEnum getAdyenCommission() {
        return this.adyenCommission;
    }

    @JsonProperty(value="adyenCommission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdyenCommission(AdyenCommissionEnum adyenCommission) {
        this.adyenCommission = adyenCommission;
    }

    public SplitConfigurationLogic adyenFees(AdyenFeesEnum adyenFees) {
        this.adyenFees = adyenFees;
        return this;
    }

    @ApiModelProperty(value="Deducts the fees due to Adyen (markup or commission) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
    @JsonProperty(value="adyenFees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AdyenFeesEnum getAdyenFees() {
        return this.adyenFees;
    }

    @JsonProperty(value="adyenFees")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdyenFees(AdyenFeesEnum adyenFees) {
        this.adyenFees = adyenFees;
    }

    public SplitConfigurationLogic adyenMarkup(AdyenMarkupEnum adyenMarkup) {
        this.adyenMarkup = adyenMarkup;
        return this;
    }

    @ApiModelProperty(value="Deducts the transaction fee due to Adyen under [Interchange ++ pricing](https://www.adyen.com/what-is-interchange) from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
    @JsonProperty(value="adyenMarkup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AdyenMarkupEnum getAdyenMarkup() {
        return this.adyenMarkup;
    }

    @JsonProperty(value="adyenMarkup")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdyenMarkup(AdyenMarkupEnum adyenMarkup) {
        this.adyenMarkup = adyenMarkup;
    }

    public SplitConfigurationLogic chargeback(ChargebackEnum chargeback) {
        this.chargeback = chargeback;
        return this;
    }

    @ApiModelProperty(value="Specifies how and from which balance account(s) to deduct the chargeback amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**.")
    @JsonProperty(value="chargeback")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChargebackEnum getChargeback() {
        return this.chargeback;
    }

    @JsonProperty(value="chargeback")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChargeback(ChargebackEnum chargeback) {
        this.chargeback = chargeback;
    }

    public SplitConfigurationLogic chargebackCostAllocation(ChargebackCostAllocationEnum chargebackCostAllocation) {
        this.chargebackCostAllocation = chargebackCostAllocation;
        return this;
    }

    @ApiModelProperty(value="Deducts the chargeback costs from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**")
    @JsonProperty(value="chargebackCostAllocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChargebackCostAllocationEnum getChargebackCostAllocation() {
        return this.chargebackCostAllocation;
    }

    @JsonProperty(value="chargebackCostAllocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChargebackCostAllocation(ChargebackCostAllocationEnum chargebackCostAllocation) {
        this.chargebackCostAllocation = chargebackCostAllocation;
    }

    public SplitConfigurationLogic commission(Commission commission) {
        this.commission = commission;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Commission getCommission() {
        return this.commission;
    }

    @JsonProperty(value="commission")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommission(Commission commission) {
        this.commission = commission;
    }

    public SplitConfigurationLogic interchange(InterchangeEnum interchange) {
        this.interchange = interchange;
        return this;
    }

    @ApiModelProperty(value="Deducts the interchange fee from specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
    @JsonProperty(value="interchange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InterchangeEnum getInterchange() {
        return this.interchange;
    }

    @JsonProperty(value="interchange")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInterchange(InterchangeEnum interchange) {
        this.interchange = interchange;
    }

    public SplitConfigurationLogic paymentFee(PaymentFeeEnum paymentFee) {
        this.paymentFee = paymentFee;
        return this;
    }

    @ApiModelProperty(value="Deducts all transaction fees incurred by the payment from the specified balance account. The transaction fees include the acquiring fees (interchange and scheme fee), and the fees due to Adyen (markup or commission). You can book any and all these fees to different balance account by specifying other transaction fee parameters in your split configuration profile:  - [`adyenCommission`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenCommission): The transaction fee due to Adyen under [blended rates](https://www.adyen.com/knowledge-hub/interchange-fees-explained#interchange-vs-blended). - [`adyenMarkup`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenMarkup): The transaction fee due to Adyen under [Interchange ++ pricing](https://www.adyen.com/knowledge-hub/interchange-fees-explained#interchange-vs-blended). - [`schemeFee`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-schemeFee): The fee paid to the card scheme for using their network. - [`interchange`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-interchange): The fee paid to the issuer for each payment transaction made with the card network. - [`adyenFees`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-adyenFees): The aggregated amount of Adyen's commission and markup. - [`acquiringFees`](https://docs.adyen.com/api-explorer/Management/latest/post/merchants/(merchantId)/splitConfigurations#request-rules-splitLogic-acquiringFees): The aggregated amount of the interchange and scheme fees.  If you don't include at least one transaction fee type in the `splitLogic` object, Adyen updates the payment request with the `paymentFee` parameter, booking all transaction fees to your platform's liable balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
    @JsonProperty(value="paymentFee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentFeeEnum getPaymentFee() {
        return this.paymentFee;
    }

    @JsonProperty(value="paymentFee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentFee(PaymentFeeEnum paymentFee) {
        this.paymentFee = paymentFee;
    }

    public SplitConfigurationLogic refund(RefundEnum refund) {
        this.refund = refund;
        return this;
    }

    @ApiModelProperty(value="Specifies how and from which balance account(s) to deduct the refund amount.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**, **deductAccordingToSplitRatio**")
    @JsonProperty(value="refund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RefundEnum getRefund() {
        return this.refund;
    }

    @JsonProperty(value="refund")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefund(RefundEnum refund) {
        this.refund = refund;
    }

    public SplitConfigurationLogic refundCostAllocation(RefundCostAllocationEnum refundCostAllocation) {
        this.refundCostAllocation = refundCostAllocation;
        return this;
    }

    @ApiModelProperty(value="Deducts the refund costs from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**")
    @JsonProperty(value="refundCostAllocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RefundCostAllocationEnum getRefundCostAllocation() {
        return this.refundCostAllocation;
    }

    @JsonProperty(value="refundCostAllocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefundCostAllocation(RefundCostAllocationEnum refundCostAllocation) {
        this.refundCostAllocation = refundCostAllocation;
    }

    public SplitConfigurationLogic remainder(RemainderEnum remainder) {
        this.remainder = remainder;
        return this;
    }

    @ApiModelProperty(value="Books the amount left over after currency conversion to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.")
    @JsonProperty(value="remainder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RemainderEnum getRemainder() {
        return this.remainder;
    }

    @JsonProperty(value="remainder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRemainder(RemainderEnum remainder) {
        this.remainder = remainder;
    }

    public SplitConfigurationLogic schemeFee(SchemeFeeEnum schemeFee) {
        this.schemeFee = schemeFee;
        return this;
    }

    @ApiModelProperty(value="Deducts the scheme fee from the specified balance account.  Possible values: **deductFromLiableAccount**, **deductFromOneBalanceAccount**.")
    @JsonProperty(value="schemeFee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SchemeFeeEnum getSchemeFee() {
        return this.schemeFee;
    }

    @JsonProperty(value="schemeFee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemeFee(SchemeFeeEnum schemeFee) {
        this.schemeFee = schemeFee;
    }

    public SplitConfigurationLogic splitLogicId(String splitLogicId) {
        this.splitLogicId = splitLogicId;
        return this;
    }

    @ApiModelProperty(value="Unique identifier of the collection of split instructions that are applied when the rule conditions are met.")
    @JsonProperty(value="splitLogicId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSplitLogicId() {
        return this.splitLogicId;
    }

    @JsonProperty(value="splitLogicId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplitLogicId(String splitLogicId) {
        this.splitLogicId = splitLogicId;
    }

    public SplitConfigurationLogic surcharge(SurchargeEnum surcharge) {
        this.surcharge = surcharge;
        return this;
    }

    @ApiModelProperty(value="Books the surcharge amount to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**")
    @JsonProperty(value="surcharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SurchargeEnum getSurcharge() {
        return this.surcharge;
    }

    @JsonProperty(value="surcharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSurcharge(SurchargeEnum surcharge) {
        this.surcharge = surcharge;
    }

    public SplitConfigurationLogic tip(TipEnum tip) {
        this.tip = tip;
        return this;
    }

    @ApiModelProperty(value="Books the tips (gratuity) to the specified balance account.  Possible values: **addToLiableAccount**, **addToOneBalanceAccount**.")
    @JsonProperty(value="tip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TipEnum getTip() {
        return this.tip;
    }

    @JsonProperty(value="tip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTip(TipEnum tip) {
        this.tip = tip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitConfigurationLogic splitConfigurationLogic = (SplitConfigurationLogic)o;
        return Objects.equals((Object)this.acquiringFees, (Object)splitConfigurationLogic.acquiringFees) && Objects.equals(this.additionalCommission, splitConfigurationLogic.additionalCommission) && Objects.equals((Object)this.adyenCommission, (Object)splitConfigurationLogic.adyenCommission) && Objects.equals((Object)this.adyenFees, (Object)splitConfigurationLogic.adyenFees) && Objects.equals((Object)this.adyenMarkup, (Object)splitConfigurationLogic.adyenMarkup) && Objects.equals((Object)this.chargeback, (Object)splitConfigurationLogic.chargeback) && Objects.equals((Object)this.chargebackCostAllocation, (Object)splitConfigurationLogic.chargebackCostAllocation) && Objects.equals(this.commission, splitConfigurationLogic.commission) && Objects.equals((Object)this.interchange, (Object)splitConfigurationLogic.interchange) && Objects.equals((Object)this.paymentFee, (Object)splitConfigurationLogic.paymentFee) && Objects.equals((Object)this.refund, (Object)splitConfigurationLogic.refund) && Objects.equals((Object)this.refundCostAllocation, (Object)splitConfigurationLogic.refundCostAllocation) && Objects.equals((Object)this.remainder, (Object)splitConfigurationLogic.remainder) && Objects.equals((Object)this.schemeFee, (Object)splitConfigurationLogic.schemeFee) && Objects.equals(this.splitLogicId, splitConfigurationLogic.splitLogicId) && Objects.equals((Object)this.surcharge, (Object)splitConfigurationLogic.surcharge) && Objects.equals((Object)this.tip, (Object)splitConfigurationLogic.tip);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acquiringFees, this.additionalCommission, this.adyenCommission, this.adyenFees, this.adyenMarkup, this.chargeback, this.chargebackCostAllocation, this.commission, this.interchange, this.paymentFee, this.refund, this.refundCostAllocation, this.remainder, this.schemeFee, this.splitLogicId, this.surcharge, this.tip});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SplitConfigurationLogic {\n");
        sb.append("    acquiringFees: ").append(this.toIndentedString((Object)this.acquiringFees)).append("\n");
        sb.append("    additionalCommission: ").append(this.toIndentedString(this.additionalCommission)).append("\n");
        sb.append("    adyenCommission: ").append(this.toIndentedString((Object)this.adyenCommission)).append("\n");
        sb.append("    adyenFees: ").append(this.toIndentedString((Object)this.adyenFees)).append("\n");
        sb.append("    adyenMarkup: ").append(this.toIndentedString((Object)this.adyenMarkup)).append("\n");
        sb.append("    chargeback: ").append(this.toIndentedString((Object)this.chargeback)).append("\n");
        sb.append("    chargebackCostAllocation: ").append(this.toIndentedString((Object)this.chargebackCostAllocation)).append("\n");
        sb.append("    commission: ").append(this.toIndentedString(this.commission)).append("\n");
        sb.append("    interchange: ").append(this.toIndentedString((Object)this.interchange)).append("\n");
        sb.append("    paymentFee: ").append(this.toIndentedString((Object)this.paymentFee)).append("\n");
        sb.append("    refund: ").append(this.toIndentedString((Object)this.refund)).append("\n");
        sb.append("    refundCostAllocation: ").append(this.toIndentedString((Object)this.refundCostAllocation)).append("\n");
        sb.append("    remainder: ").append(this.toIndentedString((Object)this.remainder)).append("\n");
        sb.append("    schemeFee: ").append(this.toIndentedString((Object)this.schemeFee)).append("\n");
        sb.append("    splitLogicId: ").append(this.toIndentedString(this.splitLogicId)).append("\n");
        sb.append("    surcharge: ").append(this.toIndentedString((Object)this.surcharge)).append("\n");
        sb.append("    tip: ").append(this.toIndentedString((Object)this.tip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SplitConfigurationLogic fromJson(String jsonString) throws JsonProcessingException {
        return (SplitConfigurationLogic)JSON.getMapper().readValue(jsonString, SplitConfigurationLogic.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TipEnum {
        ADDTOLIABLEACCOUNT("addToLiableAccount"),
        ADDTOONEBALANCEACCOUNT("addToOneBalanceAccount");

        private String value;

        private TipEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TipEnum fromValue(String value) {
            for (TipEnum b : TipEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SurchargeEnum {
        ADDTOLIABLEACCOUNT("addToLiableAccount"),
        ADDTOONEBALANCEACCOUNT("addToOneBalanceAccount");

        private String value;

        private SurchargeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SurchargeEnum fromValue(String value) {
            for (SurchargeEnum b : SurchargeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SchemeFeeEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private SchemeFeeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SchemeFeeEnum fromValue(String value) {
            for (SchemeFeeEnum b : SchemeFeeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RemainderEnum {
        ADDTOLIABLEACCOUNT("addToLiableAccount"),
        ADDTOONEBALANCEACCOUNT("addToOneBalanceAccount");

        private String value;

        private RemainderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RemainderEnum fromValue(String value) {
            for (RemainderEnum b : RemainderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RefundCostAllocationEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private RefundCostAllocationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RefundCostAllocationEnum fromValue(String value) {
            for (RefundCostAllocationEnum b : RefundCostAllocationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum RefundEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount"),
        DEDUCTACCORDINGTOSPLITRATIO("deductAccordingToSplitRatio");

        private String value;

        private RefundEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RefundEnum fromValue(String value) {
            for (RefundEnum b : RefundEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PaymentFeeEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private PaymentFeeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PaymentFeeEnum fromValue(String value) {
            for (PaymentFeeEnum b : PaymentFeeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum InterchangeEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private InterchangeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InterchangeEnum fromValue(String value) {
            for (InterchangeEnum b : InterchangeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChargebackCostAllocationEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private ChargebackCostAllocationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChargebackCostAllocationEnum fromValue(String value) {
            for (ChargebackCostAllocationEnum b : ChargebackCostAllocationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChargebackEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount"),
        DEDUCTACCORDINGTOSPLITRATIO("deductAccordingToSplitRatio");

        private String value;

        private ChargebackEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChargebackEnum fromValue(String value) {
            for (ChargebackEnum b : ChargebackEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AdyenMarkupEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private AdyenMarkupEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AdyenMarkupEnum fromValue(String value) {
            for (AdyenMarkupEnum b : AdyenMarkupEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AdyenFeesEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private AdyenFeesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AdyenFeesEnum fromValue(String value) {
            for (AdyenFeesEnum b : AdyenFeesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AdyenCommissionEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private AdyenCommissionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AdyenCommissionEnum fromValue(String value) {
            for (AdyenCommissionEnum b : AdyenCommissionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AcquiringFeesEnum {
        DEDUCTFROMLIABLEACCOUNT("deductFromLiableAccount"),
        DEDUCTFROMONEBALANCEACCOUNT("deductFromOneBalanceAccount");

        private String value;

        private AcquiringFeesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AcquiringFeesEnum fromValue(String value) {
            for (AcquiringFeesEnum b : AcquiringFeesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

