/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"marketIdentifier", "stockNumber", "tickerSymbol"})
public class StockData {
    public static final String JSON_PROPERTY_MARKET_IDENTIFIER = "marketIdentifier";
    private String marketIdentifier;
    public static final String JSON_PROPERTY_STOCK_NUMBER = "stockNumber";
    private String stockNumber;
    public static final String JSON_PROPERTY_TICKER_SYMBOL = "tickerSymbol";
    private String tickerSymbol;

    public StockData marketIdentifier(String marketIdentifier) {
        this.marketIdentifier = marketIdentifier;
        return this;
    }

    @ApiModelProperty(value="The four-digit [Market Identifier Code](https://en.wikipedia.org/wiki/Market_Identifier_Code) of the stock market where the organization's stocks are traded.")
    @JsonProperty(value="marketIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMarketIdentifier() {
        return this.marketIdentifier;
    }

    @JsonProperty(value="marketIdentifier")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMarketIdentifier(String marketIdentifier) {
        this.marketIdentifier = marketIdentifier;
    }

    public StockData stockNumber(String stockNumber) {
        this.stockNumber = stockNumber;
        return this;
    }

    @ApiModelProperty(value="The 12-digit International Securities Identification Number (ISIN) of the company, without dashes (-).")
    @JsonProperty(value="stockNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStockNumber() {
        return this.stockNumber;
    }

    @JsonProperty(value="stockNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStockNumber(String stockNumber) {
        this.stockNumber = stockNumber;
    }

    public StockData tickerSymbol(String tickerSymbol) {
        this.tickerSymbol = tickerSymbol;
        return this;
    }

    @ApiModelProperty(value="The stock ticker symbol.")
    @JsonProperty(value="tickerSymbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTickerSymbol() {
        return this.tickerSymbol;
    }

    @JsonProperty(value="tickerSymbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTickerSymbol(String tickerSymbol) {
        this.tickerSymbol = tickerSymbol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StockData stockData = (StockData)o;
        return Objects.equals(this.marketIdentifier, stockData.marketIdentifier) && Objects.equals(this.stockNumber, stockData.stockNumber) && Objects.equals(this.tickerSymbol, stockData.tickerSymbol);
    }

    public int hashCode() {
        return Objects.hash(this.marketIdentifier, this.stockNumber, this.tickerSymbol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StockData {\n");
        sb.append("    marketIdentifier: ").append(this.toIndentedString(this.marketIdentifier)).append("\n");
        sb.append("    stockNumber: ").append(this.toIndentedString(this.stockNumber)).append("\n");
        sb.append("    tickerSymbol: ").append(this.toIndentedString(this.tickerSymbol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static StockData fromJson(String jsonString) throws JsonProcessingException {
        return (StockData)JSON.getMapper().readValue(jsonString, StockData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

