/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.SplitAmount;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"account", "amount", "description", "reference", "type"})
public class Split {
    public static final String JSON_PROPERTY_ACCOUNT = "account";
    private String account;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private SplitAmount amount;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public Split account(String account) {
        this.account = account;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the account to which the split amount is booked. Required if `type` is **MarketPlace** or **BalanceAccount**.  * [Classic Platforms integration](https://docs.adyen.com/marketplaces-and-platforms/classic): The [`accountCode`](https://docs.adyen.com/api-explorer/Account/latest/post/updateAccount#request-accountCode) of the account to which the split amount is booked. * [Balance Platform](https://docs.adyen.com/marketplaces-and-platforms): The [`balanceAccountId`](https://docs.adyen.com/api-explorer/balanceplatform/latest/get/balanceAccounts/_id_#path-id) of the account to which the split amount is booked.")
    @JsonProperty(value="account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccount() {
        return this.account;
    }

    @JsonProperty(value="account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccount(String account) {
        this.account = account;
    }

    public Split amount(SplitAmount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SplitAmount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(SplitAmount amount) {
        this.amount = amount;
    }

    public Split description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for the split item.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Split reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your unique reference for the split item.  This is required if `type` is **MarketPlace** ([Classic Platforms integration](https://docs.adyen.com/marketplaces-and-platforms/classic)) or **BalanceAccount** ([Balance Platform](https://docs.adyen.com/marketplaces-and-platforms)).  For the other types, we also recommend providing a **unique** reference so you can reconcile the split and the associated payment in the transaction overview and in the reports.")
    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public Split type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the split item.  Possible values:  * [Classic Platforms integration](https://docs.adyen.com/marketplaces-and-platforms/classic): **Commission**, **Default**, **Marketplace**, **PaymentFee**, **VAT**. * [Balance Platform](https://docs.adyen.com/marketplaces-and-platforms): **BalanceAccount**, **Commission**, **Default**, **PaymentFee**, **Remainder**, **Surcharge**, **Tip**, **VAT**.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Split split = (Split)o;
        return Objects.equals(this.account, split.account) && Objects.equals(this.amount, split.amount) && Objects.equals(this.description, split.description) && Objects.equals(this.reference, split.reference) && Objects.equals((Object)this.type, (Object)split.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.account, this.amount, this.description, this.reference, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Split {\n");
        sb.append("    account: ").append(this.toIndentedString(this.account)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Split fromJson(String jsonString) throws JsonProcessingException {
        return (Split)JSON.getMapper().readValue(jsonString, Split.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        ACQUIRINGFEES("AcquiringFees"),
        ADYENCOMMISSION("AdyenCommission"),
        ADYENFEES("AdyenFees"),
        ADYENMARKUP("AdyenMarkup"),
        BALANCEACCOUNT("BalanceAccount"),
        COMMISSION("Commission"),
        DEFAULT("Default"),
        INTERCHANGE("Interchange"),
        MARKETPLACE("MarketPlace"),
        PAYMENTFEE("PaymentFee"),
        REMAINDER("Remainder"),
        SCHEMEFEE("SchemeFee"),
        SURCHARGE("Surcharge"),
        TIP("Tip"),
        VAT("VAT");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

